/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.antarctica;

import ch.tachyon.sonics.antarctica.ConsoleProgressMonitor;
import ch.tachyon.sonics.effect.pitchtime.TimeStretchVocoder;
import ch.tachyon.tunnel.audio.file.AudioFileIO;
import ch.tachyon.tunnel.audio.file.AudioFileTypes;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.host.StreamProcessor;
import ch.tachyon.tunnel.host.effect.IPullEffect;
import ch.tachyon.tunnel.utils.IProgressMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Vocoder {
    public static void main(String[] args) {
        AudioFileFormat.Type outputType;
        if (args.length != 3) {
            Vocoder.printUsageAndExit();
        }
        File inputFile = new File(args[0]);
        double ratio = Double.parseDouble(args[1]);
        File outputFile = new File(args[2]);
        if (!inputFile.isFile()) {
            System.err.println("Cannot find input file " + inputFile);
            System.exit(1);
        }
        if (Double.isNaN(ratio) || ratio < 0.25 || ratio > 4.0) {
            System.err.println("Time stretching ratio is out of the [0.25 - 4] range");
            System.exit(1);
        }
        if (outputFile.exists()) {
            System.out.print("Output file already exists, replace it [y/n]? ");
            System.out.flush();
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            try {
                String answer = reader.readLine();
                if (!"y".equalsIgnoreCase(answer.trim())) {
                    System.exit(1);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
        if ((outputType = AudioFileTypes.instance().getWritableType4ext(outputFile.getName())) == null) {
            System.err.println("Unsupported output audio file format. Try using WAVE (*.wav), AIFF/AIFC (*.aif) or Sun Audio (*.au) files");
            System.exit(1);
        }
        try {
            System.out.println("Loading file " + inputFile + "...");
            AudioFileFormat inputFormat = AudioFileTypes.instance().getAudioFileFormat(inputFile, true);
            System.out.println("Sample rate: " + (int)inputFormat.getFormat().getSampleRate());
            System.out.println("Input duration: " + Vocoder.durationToString(inputFormat));
            float sampleRate = inputFormat.getFormat().getSampleRate();
            if (sampleRate < 44000.0f || sampleRate > 50000.0f) {
                System.err.println("Sorry, only sample rates of 44100Hz and 48000Hz are supported");
                System.exit(1);
            }
            IMultiChanAudioSource fileSource = AudioFileIO.createAudioSource(inputFile);
            StreamProcessor processor = new StreamProcessor(inputFormat);
            IPullEffect plugin = processor.getPlugin(TimeStretchVocoder.class);
            plugin.setParameterValue("ratio", (Object)ratio);
            plugin.setParameterValue("mode", (Object)TimeStretchVocoder.Mode.SCALED_LOCKING);
            IMultiChanAudioSource transformedSource = processor.filter(fileSource, plugin);
            AudioFileFormat format = new AudioFileFormat(outputType, new AudioFormat(inputFormat.getFormat().getSampleRate(), 16, inputFormat.getFormat().getChannels(), true, true), (int)((double)processor.getLength() * ratio + 0.5));
            System.out.println("Output duration: " + Vocoder.durationToString(format));
            System.out.println("\nProcessing...");
            ConsoleProgressMonitor progress = new ConsoleProgressMonitor();
            AudioFileIO.saveAudioFile(transformedSource, outputFile, format, (IProgressMonitor)progress);
            progress.setProgress(100.0, 100.0);
        }
        catch (UnsupportedAudioFileException ex) {
            System.err.println("Unsupported input audio file format. Try using WAVE (*.wav), AIFF/AIFC (*.aif) or Sun Audio (*.au) files");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("There was an unexpected I/O error");
            e.printStackTrace(System.err);
            System.exit(1);
        }
        System.out.println("Successful");
    }

    private static void printUsageAndExit() {
        System.out.println("Usage: java -jar Vocoder-ts.jar <input file> <ratio> <output file>");
        System.exit(1);
    }

    private static String durationToString(AudioFileFormat format) {
        int nbFramnes = format.getFrameLength();
        float sampleRate = format.getFormat().getSampleRate();
        int seconds = (int)((double)nbFramnes / (double)sampleRate + 0.5);
        int minutes = seconds / 60;
        seconds %= 60;
        int hours = minutes / 60;
        minutes %= 60;
        StringBuilder result = new StringBuilder();
        if (hours > 0) {
            result.append(hours);
            result.append("h");
        }
        if (minutes / 10 > 0 || hours > 0) {
            result.append(minutes / 10);
        }
        result.append(minutes % 10);
        result.append(":");
        result.append(seconds / 10);
        result.append(seconds % 10);
        return result.toString();
    }
}

