/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.adaptive;

import ch.tachyon.sonics.effect.base.stft.StftAnalyzer;
import ch.tachyon.sonics.effect.base.stft.StftSynthesizer;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.Arrays;
import java.util.BitSet;
import java.util.TreeSet;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;

public class Dish
implements IHasSerialSections {
    private static final int MIN_OVERLAP = 4;
    private static final String ANALYZER_SERIAL_SECTION_NAME = String.valueOf(Dish.class.getName()) + " analyzer";
    private static final String SYNTHESIZER_SERIAL_SECTION_NAME = String.valueOf(Dish.class.getName()) + " synthesizer";
    private final int nbLayers;
    private final int nbResolutions;
    private final int nbOutputs;
    private final int[][] resolutions;
    private final int[] fftSizes;
    private final StftAnalyzer[] analyzers;
    private final StftSynthesizer[][] synthesizers;
    private final float[][] outputs;
    private final float[] tempOutput;
    private final int[] lowBin;
    private final int[] hihBin;
    private final int[] lowBinLast;
    private final int[] hihBinLast;
    private final Cmplx[][] filtered;
    private final int[] baseIndexes;
    private ISerialSection analyzerSection;
    private ISerialSection synthesizerSection;

    public Dish(int[][] resolutions, float[] splitFreqs, int chunkSize, int fftSize, float sampleRate) {
        this(resolutions, splitFreqs, splitFreqs, chunkSize, fftSize, sampleRate);
    }

    public Dish(int[][] resolutions, float[] splitFreqs, float[] lastSplitFreqs, int chunkSize, int fftSize, float sampleRate) {
        this.resolutions = resolutions;
        this.nbLayers = resolutions.length;
        this.nbResolutions = splitFreqs.length + 1;
        TreeSet<Integer> sizes = new TreeSet<Integer>();
        int[][] nArray = resolutions;
        int n = resolutions.length;
        int n2 = 0;
        while (n2 < n) {
            int[] layerResolutions;
            int[] nArray2 = layerResolutions = nArray[n2];
            int n3 = layerResolutions.length;
            int n4 = 0;
            while (n4 < n3) {
                int resolution = nArray2[n4];
                sizes.add(resolution);
                ++n4;
            }
            ++n2;
        }
        Integer[] arrSizes = sizes.toArray(new Integer[sizes.size()]);
        this.fftSizes = new int[arrSizes.length];
        int i = 0;
        while (i < arrSizes.length) {
            this.fftSizes[i] = arrSizes[i];
            ++i;
        }
        this.nbOutputs = this.fftSizes.length;
        i = 0;
        while (i < resolutions.length) {
            if (resolutions[i].length != splitFreqs.length + 1 || resolutions[i].length != lastSplitFreqs.length + 1) {
                throw new IllegalArgumentException("resolutions[" + i + "].length != splitFreqs.length + 1");
            }
            ++i;
        }
        int overlap = fftSize / chunkSize;
        if (overlap < 4) {
            overlap = 4;
        }
        int hopSize = fftSize / overlap;
        int numHops = chunkSize / hopSize;
        float[] window = WindowsFactory.getHannWindow(fftSize);
        this.analyzers = new StftAnalyzer[this.nbLayers];
        int i2 = 0;
        while (i2 < this.nbLayers) {
            this.analyzers[i2] = new StftAnalyzer(fftSize, hopSize, numHops, window, true);
            this.analyzers[i2].setName("dish." + i2);
            ++i2;
        }
        this.baseIndexes = new int[this.nbLayers];
        this.synthesizers = new StftSynthesizer[this.nbLayers][this.nbResolutions];
        int layer = 0;
        while (layer < this.nbLayers) {
            int res = 0;
            while (res < this.nbResolutions) {
                if (res == 0 || resolutions[layer][res] != resolutions[layer][res - 1]) {
                    this.synthesizers[layer][res] = new StftSynthesizer(fftSize, hopSize, numHops, window, window);
                    this.synthesizers[layer][res].setName("dish." + layer + "." + res);
                }
                ++res;
            }
            ++layer;
        }
        this.filtered = Cmplx.newArray(numHops, fftSize / 2 + 1);
        this.outputs = new float[this.nbOutputs][chunkSize];
        this.tempOutput = new float[chunkSize];
        this.lowBin = new int[this.nbResolutions];
        this.hihBin = new int[this.nbResolutions];
        this.lowBinLast = new int[this.nbResolutions];
        this.hihBinLast = new int[this.nbResolutions];
        this.fillBinBounds(this.lowBin, this.hihBin, splitFreqs, sampleRate, fftSize);
        this.fillBinBounds(this.lowBinLast, this.hihBinLast, lastSplitFreqs, sampleRate, fftSize);
    }

    private void fillBinBounds(int[] lowBin, int[] hihBin, float[] splitFreqs, float sampleRate, int fftSize) {
        int r = 0;
        while (r < this.nbResolutions) {
            float lowFreq = r == 0 ? 0.0f : splitFreqs[r - 1];
            float hihFreq = r >= splitFreqs.length ? sampleRate / 2.0f : splitFreqs[r];
            lowBin[r] = AudioMath.freq2bin(fftSize, lowFreq, sampleRate, 0);
            hihBin[r] = AudioMath.freq2bin(fftSize, hihFreq, sampleRate, 0);
            ++r;
        }
    }

    public void init() {
        StftAnalyzer[] stftAnalyzerArray = this.analyzers;
        int n = this.analyzers.length;
        int n2 = 0;
        while (n2 < n) {
            StftAnalyzer analyzer = stftAnalyzerArray[n2];
            analyzer.init();
            ++n2;
        }
        stftAnalyzerArray = this.synthesizers;
        n = this.synthesizers.length;
        n2 = 0;
        while (n2 < n) {
            StftAnalyzer synthesizers0;
            StftAnalyzer stftAnalyzer = synthesizers0 = stftAnalyzerArray[n2];
            int n3 = ((StftAnalyzer)stftAnalyzer).length;
            int n4 = 0;
            while (n4 < n3) {
                StftAnalyzer synthesizer = stftAnalyzer[n4];
                if (synthesizer != null) {
                    ((StftSynthesizer)((Object)synthesizer)).init();
                }
                ++n4;
            }
            ++n2;
        }
    }

    public float[][] process(float[][] inputs) {
        int maxRes;
        int minRes;
        int res;
        if (inputs.length != this.nbLayers) {
            throw new IllegalArgumentException();
        }
        int layer = 0;
        while (layer < this.nbLayers) {
            this.baseIndexes[layer] = this.analyzers[layer].pushInput(inputs[layer], this.analyzerSection.getClock());
            ++layer;
        }
        this.analyzerSection.sync();
        long synthClock = this.synthesizerSection.getClock();
        int nbFrames = -1;
        int layer2 = 0;
        while (layer2 < this.nbLayers) {
            Cmplx[][] spectrums = this.analyzers[layer2].analyzePushedInput(this.baseIndexes[layer2]);
            if (nbFrames < 0) {
                nbFrames = spectrums.length;
            } else assert (nbFrames == spectrums.length);
            res = 0;
            while (res < this.nbResolutions) {
                minRes = res;
                maxRes = res + 1;
                while (maxRes < this.nbResolutions && this.resolutions[layer2][maxRes] == this.resolutions[layer2][minRes]) {
                    ++maxRes;
                }
                this.filter(spectrums, layer2, minRes, maxRes - 1, this.filtered);
                this.synthesizers[layer2][res].preSynthesize(this.filtered, synthClock);
                res = maxRes;
            }
            ++layer2;
        }
        this.synthesizerSection.sync();
        BitSet firstMask = new BitSet(this.nbOutputs);
        int layer3 = 0;
        while (layer3 < inputs.length) {
            res = 0;
            while (res < this.nbResolutions) {
                minRes = res;
                maxRes = res + 1;
                while (maxRes < this.nbResolutions && this.resolutions[layer3][maxRes] == this.resolutions[layer3][minRes]) {
                    ++maxRes;
                }
                int outputIndex = this.getOutputIndex(layer3, res);
                boolean isFirst = !firstMask.get(outputIndex);
                firstMask.set(outputIndex);
                if (isFirst) {
                    this.synthesizers[layer3][res].renderResult(this.outputs[outputIndex], synthClock);
                } else {
                    this.synthesizers[layer3][res].renderResult(this.tempOutput, synthClock);
                    int i = 0;
                    while (i < this.tempOutput.length) {
                        float[] fArray = this.outputs[outputIndex];
                        int n = i;
                        fArray[n] = fArray[n] + this.tempOutput[i];
                        ++i;
                    }
                }
                res = maxRes;
            }
            ++layer3;
        }
        return this.outputs;
    }

    private int getOutputIndex(int layer, int resolution) {
        int fftSize = this.resolutions[layer][resolution];
        int result = Arrays.binarySearch(this.fftSizes, fftSize);
        assert (result >= 0) : "Could not find output index for FFT size " + fftSize;
        return result;
    }

    private void filter(Cmplx[][] spectrums, int layer, int minRes, int maxRes, Cmplx[][] targets) {
        int[] hihBin;
        int[] lowBin = layer == this.nbLayers - 1 ? this.lowBinLast : this.lowBin;
        int[] nArray = hihBin = layer == this.nbLayers - 1 ? this.hihBinLast : this.hihBin;
        assert (spectrums.length == targets.length);
        int k = 0;
        while (k < spectrums.length) {
            Cmplx[] spectrum = spectrums[k];
            Cmplx[] target = targets[k];
            assert (spectrum.length == target.length);
            int i = 0;
            while (i < spectrum.length) {
                if (i < lowBin[minRes] || i >= hihBin[maxRes]) {
                    target[i].set(0.0f, 0.0f);
                } else {
                    target[i].set(spectrum[i]);
                }
                ++i;
            }
            ++k;
        }
    }

    public int getLatency() {
        return this.synthesizers[0][0].getLatency();
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.analyzerSection = factory.createSerialSection(ANALYZER_SERIAL_SECTION_NAME, null);
        this.synthesizerSection = factory.createSerialSection(SYNTHESIZER_SERIAL_SECTION_NAME, null);
        StftAnalyzer[] stftAnalyzerArray = this.analyzers;
        int n = this.analyzers.length;
        int n2 = 0;
        while (n2 < n) {
            StftAnalyzer analyzer = stftAnalyzerArray[n2];
            analyzer.createSerialSections(factory);
            ++n2;
        }
        stftAnalyzerArray = this.synthesizers;
        n = this.synthesizers.length;
        n2 = 0;
        while (n2 < n) {
            StftAnalyzer sArr;
            StftAnalyzer stftAnalyzer = sArr = stftAnalyzerArray[n2];
            int n3 = ((StftAnalyzer)stftAnalyzer).length;
            int n4 = 0;
            while (n4 < n3) {
                StftAnalyzer synthesizer = stftAnalyzer[n4];
                if (synthesizer != null) {
                    ((StftSynthesizer)((Object)synthesizer)).createSerialSections(factory);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.analyzerSection = pool.getSerialSection(ANALYZER_SERIAL_SECTION_NAME);
        this.synthesizerSection = pool.getSerialSection(SYNTHESIZER_SERIAL_SECTION_NAME);
        StftAnalyzer[] stftAnalyzerArray = this.analyzers;
        int n = this.analyzers.length;
        int n2 = 0;
        while (n2 < n) {
            StftAnalyzer analyzer = stftAnalyzerArray[n2];
            analyzer.setSerialSections(pool);
            ++n2;
        }
        stftAnalyzerArray = this.synthesizers;
        n = this.synthesizers.length;
        n2 = 0;
        while (n2 < n) {
            StftAnalyzer sArr;
            StftAnalyzer stftAnalyzer = sArr = stftAnalyzerArray[n2];
            int n3 = ((StftAnalyzer)stftAnalyzer).length;
            int n4 = 0;
            while (n4 < n3) {
                StftAnalyzer synthesizer = stftAnalyzer[n4];
                if (synthesizer != null) {
                    ((StftSynthesizer)((Object)synthesizer)).setSerialSections(pool);
                }
                ++n4;
            }
            ++n2;
        }
    }
}

