/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.adaptive;

import ch.tachyon.sonics.effect.base.adaptive.Knife;
import ch.tachyon.sonics.effect.base.adaptive.KnifeInfo;
import ch.tachyon.sonics.effect.base.adaptive.SharpInfo;
import ch.tachyon.sonics.effect.utils.buffer.ConcurrentDelayBuffer;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.utils.Out;

public class Fork
implements IHasSerialSections {
    private static final String SERIAL_SECTION_NAME = Fork.class.getName();
    private final int nbChans;
    private final int nbLayers;
    private final int hopSize;
    private final float[][] srcBuffer;
    private String name = "";
    private final Knife[] knifes;
    private final float[][][] outputs;
    private float[][] monoOutputs;
    private ISerialSection[] sss;
    private final SharedData[] delayers;

    public Fork(int nbChans, SharpInfo info) {
        this(nbChans, info, false, false, 1.85f);
    }

    public Fork(int nbChans, SharpInfo info, boolean acceptMelodyLess, boolean noise, float noiseCorrection) {
        this(nbChans, info, info.hopSize, acceptMelodyLess, noise, noiseCorrection);
    }

    public Fork(int nbChans, SharpInfo info, int hopSize, boolean acceptMelodyLess, boolean noise, float noiseCorrection) {
        this("", nbChans, info, hopSize, acceptMelodyLess, noise, noiseCorrection);
    }

    public Fork(String name, int nbChans, SharpInfo info, int hopSize, boolean acceptMelodyLess, boolean noise, float noiseCorrection) {
        this.name = name;
        this.nbChans = nbChans;
        this.nbLayers = info.nbLayers;
        this.hopSize = hopSize;
        this.srcBuffer = new float[nbChans][hopSize];
        this.knifes = new Knife[info.nbLayers - 1];
        this.sss = new ISerialSection[Fork.z(info.nbLayers - 2)];
        this.outputs = new float[info.nbLayers][nbChans][hopSize];
        int i = 0;
        while (i < this.knifes.length) {
            KnifeInfo knifeInfo = info.knifeInfo[i];
            if (knifeInfo.hopSize > hopSize) {
                knifeInfo = knifeInfo.copyWithHopSize(hopSize);
            }
            this.knifes[i] = new Knife(nbChans, hopSize, knifeInfo, String.valueOf(name) + "layer" + i, i == 0 && acceptMelodyLess, i == this.knifes.length - 1 && noise, noiseCorrection);
            ++i;
        }
        i = 0;
        while (i < this.sss.length) {
            this.sss[i] = new DummySerialSection();
            ++i;
        }
        this.delayers = new SharedData[this.sss.length];
    }

    private void setupDelayers(IMtContext mtContext, int nbChans) {
        int chan;
        int delayerCapacity;
        int j;
        int totalLatency;
        int i = 0;
        while (i < this.delayers.length) {
            this.delayers[i] = new SharedData();
            this.delayers[i].preDelay = new ConcurrentDelayBuffer[nbChans];
            this.delayers[i].postDelay = new ConcurrentDelayBuffer[nbChans];
            ++i;
        }
        i = 0;
        while (i < this.delayers.length) {
            totalLatency = 0;
            j = 0;
            while (j < i + 1) {
                totalLatency += this.knifes[j].getLatency();
                ++j;
            }
            delayerCapacity = totalLatency + this.hopSize * mtContext.getSerialRunningMaxSkew();
            chan = 0;
            while (chan < nbChans) {
                this.delayers[i].preDelay[chan] = new ConcurrentDelayBuffer(totalLatency, delayerCapacity, this.hopSize);
                ++chan;
            }
            ++i;
        }
        i = 0;
        while (i < this.delayers.length) {
            totalLatency = 0;
            j = i + 1;
            while (j < this.knifes.length) {
                totalLatency += this.knifes[j].getLatency();
                ++j;
            }
            delayerCapacity = totalLatency + this.hopSize * mtContext.getSerialRunningMaxSkew();
            chan = 0;
            while (chan < nbChans) {
                this.delayers[i].postDelay[chan] = new ConcurrentDelayBuffer(totalLatency, delayerCapacity, this.hopSize);
                ++chan;
            }
            ++i;
        }
    }

    public void init() {
        Knife[] knifeArray = this.knifes;
        int n = this.knifes.length;
        int n2 = 0;
        while (n2 < n) {
            Knife knife = knifeArray[n2];
            knife.init();
            ++n2;
        }
    }

    private static int z(int value) {
        return value < 0 ? 0 : value;
    }

    public int getInputSize() {
        return this.hopSize;
    }

    public void process(float[][] input) {
        this.process(input, null);
    }

    public void process(float[][] inputBlock, float[][] melodyLess) {
        float[][] source;
        if (inputBlock.length != this.nbChans) {
            throw new IllegalArgumentException("Illegal number of channels");
        }
        int chan = 0;
        while (chan < this.nbChans) {
            if (inputBlock[chan].length != this.hopSize) {
                throw new IllegalArgumentException("Illegal block size");
            }
            System.arraycopy(inputBlock[chan], 0, this.srcBuffer[chan], 0, this.hopSize);
            ++chan;
        }
        float[][] input = inputBlock;
        float[][] fArray = source = melodyLess == null ? this.srcBuffer : melodyLess;
        if (this.knifes.length > 0) {
            int s = 0;
            while (s < this.knifes.length) {
                if (s == 0 && melodyLess != null) {
                    this.knifes[s].processMonitored(source, input, this.outputs[s], this.outputs[s + 1]);
                } else {
                    this.knifes[s].process(source, input, this.outputs[s], this.outputs[s + 1]);
                }
                input = this.outputs[s + 1];
                if (s < this.delayers.length) {
                    long clock = this.sss[s].getClock();
                    int chan2 = 0;
                    while (chan2 < this.nbChans) {
                        this.delayers[s].postDelay[chan2].push(this.outputs[s][chan2], clock);
                        ++chan2;
                    }
                    chan2 = 0;
                    while (chan2 < this.nbChans) {
                        this.delayers[s].preDelay[chan2].push(this.srcBuffer[chan2], clock);
                        ++chan2;
                    }
                    this.sss[s].sync();
                    chan2 = 0;
                    while (chan2 < this.nbChans) {
                        this.delayers[s].postDelay[chan2].pop(this.outputs[s][chan2], clock);
                        ++chan2;
                    }
                    chan2 = 0;
                    while (chan2 < this.nbChans) {
                        this.delayers[s].preDelay[chan2].pop(this.srcBuffer[chan2], clock);
                        ++chan2;
                    }
                }
                source = this.srcBuffer;
                ++s;
            }
        } else {
            int chan3 = 0;
            while (chan3 < this.nbChans) {
                System.arraycopy(input[chan3], 0, this.outputs[0][chan3], 0, input[chan3].length);
                ++chan3;
            }
        }
    }

    public float[] getOutput(int layer, int chan) {
        return this.outputs[layer][chan];
    }

    public float[][] getOutputs(int chan) {
        if (this.monoOutputs == null || this.monoOutputs.length != this.nbLayers) {
            this.monoOutputs = new float[this.nbLayers][];
        }
        int layer = 0;
        while (layer < this.nbLayers) {
            this.monoOutputs[layer] = this.outputs[layer][chan];
            ++layer;
        }
        return this.monoOutputs;
    }

    public int getNumHops(int knifeIndex) {
        return this.knifes[knifeIndex].getNumHops();
    }

    public float[] getEdgeRatios(int knifeIndex, int k, int chan) {
        return this.knifes[knifeIndex].getEdgeRatios(k, chan);
    }

    public void fillEdgeRatios(int knifeIndex, int chan, @Out float[][] edgeRatios) {
        this.knifes[knifeIndex].fillEdgeRatios(chan, edgeRatios);
    }

    public int getLatency() {
        int total = 0;
        Knife[] knifeArray = this.knifes;
        int n = this.knifes.length;
        int n2 = 0;
        while (n2 < n) {
            Knife knife = knifeArray[n2];
            total += knife.getLatency();
            ++n2;
        }
        return total;
    }

    public int getNbChans() {
        return this.nbChans;
    }

    public int getNbLayers() {
        return this.nbLayers;
    }

    public int getNbKnifes() {
        return this.knifes.length;
    }

    public int getNbBins(int knifeIndex) {
        return this.knifes[knifeIndex].getNbBins();
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.setupDelayers(factory.getMtContext(), this.nbChans);
        Knife[] knifeArray = this.knifes;
        int n = this.knifes.length;
        int n2 = 0;
        while (n2 < n) {
            Knife knife = knifeArray[n2];
            knife.createSerialSections(factory);
            ++n2;
        }
        int i = 0;
        while (i < this.sss.length) {
            this.sss[i] = factory.createSerialSection(String.valueOf(SERIAL_SECTION_NAME) + this.name + i, this.delayers[i]);
            ++i;
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        Knife[] knifeArray = this.knifes;
        int n = this.knifes.length;
        int n2 = 0;
        while (n2 < n) {
            Knife knife = knifeArray[n2];
            knife.setSerialSections(pool);
            ++n2;
        }
        int i = 0;
        while (i < this.sss.length) {
            this.sss[i] = pool.getSerialSection(String.valueOf(SERIAL_SECTION_NAME) + this.name + i);
            this.delayers[i] = (SharedData)this.sss[i].getUserData();
            ++i;
        }
    }

    static class SharedData {
        public ConcurrentDelayBuffer[] preDelay;
        public ConcurrentDelayBuffer[] postDelay;

        SharedData() {
        }
    }
}

