/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.adaptive;

import ch.tachyon.sonics.effect.base.adaptive.KnifeInfo;
import ch.tachyon.sonics.effect.base.adaptive.TransientExtractor;
import ch.tachyon.sonics.effect.base.stft.StftAnalyzer;
import ch.tachyon.sonics.effect.base.stft.StftSynthesizer;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import ch.tachyon.sonics.effect.separation.NoiseExtractor;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.BitSet;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.utils.Out;

public class Knife
implements IHasSerialSections {
    private static final float MAX_JUMP = (float)AudioMath.dbToLevel(50.0);
    private static final String ANALYZER_SECTION_NAME = String.valueOf(Knife.class.getName()) + " analyzer";
    private static final String SYNTHESIZER_SECTION_NAME = String.valueOf(Knife.class.getName()) + " synthesizer";
    private final String name;
    private final int nbChans;
    private final int inputSize;
    private final int blockSize;
    private final int hopSize;
    private final int numHops;
    private final float noiseCorrection;
    private TransientExtractor engine;
    private NoiseExtractor noiseExtractor;
    private StftAnalyzer[] sourceAnalyzers;
    private StftAnalyzer[] signalAnalyzers;
    private StftSynthesizer[] shortSynthesizers;
    private StftSynthesizer[] longSynthesizers;
    private int[] sourceIndexes;
    private int[] signalIndexes;
    private ISerialSection analyzerSection;
    private ISerialSection synthesizerSection;
    private Cmplx[][][] inSpectrum;
    private Cmplx[][][] srcSpectrum;
    private Cmplx[][][] shortx;
    private Cmplx[][][] longx;

    public Knife(int nbChans, int inputSize, KnifeInfo info, String name) {
        this(nbChans, inputSize, info, name, false, false, 1.85f);
    }

    public Knife(int nbChans, int inputSize, KnifeInfo info, String name, boolean enableMonitorMode, boolean noiseOnly, float noiseCorrection) {
        if (inputSize < info.hopSize) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.nbChans = nbChans;
        this.inputSize = inputSize;
        this.blockSize = info.blockSize;
        this.hopSize = info.hopSize;
        int nbBins = this.blockSize / 2 + 1;
        this.numHops = inputSize / this.hopSize;
        this.noiseCorrection = noiseCorrection;
        this.engine = new TransientExtractor(name, this.numHops, nbChans, nbBins, info.minimizerLength, info.averagerLength, info.sensivityDb, info.attackSpeedDb, info.minSpan, info.spread, info.hard, true, MAX_JUMP, (float)info.hopSize / 44100.0f, nbBins <= 129);
        if (noiseOnly) {
            this.noiseExtractor = new NoiseExtractor(nbBins, (float)AudioMath.dbToLevel(10.0), 0.5f, 44100.0f, 20.0f);
        }
        this.sourceAnalyzers = new StftAnalyzer[nbChans];
        this.signalAnalyzers = new StftAnalyzer[nbChans];
        this.shortSynthesizers = new StftSynthesizer[nbChans];
        this.longSynthesizers = new StftSynthesizer[nbChans];
        float[] window = WindowsFactory.getHannWindow(this.blockSize);
        int chan = 0;
        while (chan < nbChans) {
            this.sourceAnalyzers[chan] = new StftAnalyzer(this.blockSize, this.hopSize, this.numHops, window, true);
            this.sourceAnalyzers[chan].setName(String.valueOf(name) + ".sourceKnife" + chan);
            this.signalAnalyzers[chan] = new StftAnalyzer(this.blockSize, this.hopSize, this.numHops, window, true);
            this.signalAnalyzers[chan].setName(String.valueOf(name) + ".signalKnife" + chan);
            this.shortSynthesizers[chan] = new StftSynthesizer(this.blockSize, this.hopSize, this.numHops, window, window);
            this.shortSynthesizers[chan].setName(String.valueOf(name) + ".shortKnife" + chan);
            this.longSynthesizers[chan] = new StftSynthesizer(this.blockSize, this.hopSize, this.numHops, window, window);
            this.longSynthesizers[chan].setName(String.valueOf(name) + ".longKnife" + chan);
            ++chan;
        }
        this.sourceIndexes = new int[nbChans];
        this.signalIndexes = new int[nbChans];
        this.inSpectrum = new Cmplx[this.numHops][nbChans][];
        this.srcSpectrum = new Cmplx[this.numHops][nbChans][];
        this.shortx = Cmplx.newArray(nbChans, this.numHops, nbBins);
        this.longx = Cmplx.newArray(nbChans, this.numHops, nbBins);
    }

    public void init() {
        int chan = 0;
        while (chan < this.nbChans) {
            this.sourceAnalyzers[chan].init();
            this.signalAnalyzers[chan].init(this.sourceAnalyzers[chan]);
            this.shortSynthesizers[chan].init(this.sourceAnalyzers[chan]);
            this.longSynthesizers[chan].init(this.sourceAnalyzers[chan]);
            ++chan;
        }
    }

    public String getName() {
        return this.name;
    }

    public void processMonitored(float[][] source, float[][] input, float[][] outShort, float[][] outLong) {
        if (source.length != this.nbChans || input.length != this.nbChans) {
            throw new IllegalArgumentException("Wrong number of channels");
        }
        if (source[0].length != this.inputSize || input[0].length != this.inputSize) {
            throw new IllegalArgumentException("Wrong input size");
        }
        long analyzerClock = this.analyzerSection.getClock();
        int chan = 0;
        while (chan < this.nbChans) {
            this.sourceIndexes[chan] = this.sourceAnalyzers[chan].pushInput(source[chan], analyzerClock);
            this.signalIndexes[chan] = this.signalAnalyzers[chan].pushInput(input[chan], analyzerClock);
            ++chan;
        }
        this.analyzerSection.sync();
        chan = 0;
        while (chan < this.nbChans) {
            Cmplx[][] frames = this.sourceAnalyzers[chan].analyzePushedInput(this.sourceIndexes[chan]);
            int k = 0;
            while (k < this.numHops) {
                this.srcSpectrum[k][chan] = frames[k];
                ++k;
            }
            frames = this.signalAnalyzers[chan].analyzePushedInput(this.signalIndexes[chan]);
            k = 0;
            while (k < this.numHops) {
                this.inSpectrum[k][chan] = frames[k];
                ++k;
            }
            ++chan;
        }
        this.engine.analyseMonitored(this.srcSpectrum, this.inSpectrum);
        chan = 0;
        while (chan < this.nbChans) {
            this.engine.processSplitted(this.inSpectrum, chan, this.shortx[chan], this.longx[chan]);
            ++chan;
        }
        long synthClock = this.synthesizerSection.getClock();
        int chan2 = 0;
        while (chan2 < this.nbChans) {
            this.shortSynthesizers[chan2].preSynthesize(this.shortx[chan2], synthClock);
            this.longSynthesizers[chan2].preSynthesize(this.longx[chan2], synthClock);
            ++chan2;
        }
        this.synthesizerSection.sync();
        chan2 = 0;
        while (chan2 < this.nbChans) {
            this.shortSynthesizers[chan2].renderResult(outShort[chan2], synthClock);
            this.longSynthesizers[chan2].renderResult(outLong[chan2], synthClock);
            ++chan2;
        }
    }

    public void process(float[][] source, float[][] input, float[][] outShort, float[][] outLong) {
        if (source.length != this.nbChans || input.length != this.nbChans) {
            throw new IllegalArgumentException("Wrong number of channels");
        }
        if (source[0].length != this.inputSize || input[0].length != this.inputSize) {
            throw new IllegalArgumentException("Wrong input size");
        }
        long analyzerClock = this.analyzerSection.getClock();
        int chan = 0;
        while (chan < this.nbChans) {
            this.sourceIndexes[chan] = this.sourceAnalyzers[chan].pushInput(source[chan], analyzerClock);
            this.signalIndexes[chan] = this.signalAnalyzers[chan].pushInput(input[chan], analyzerClock);
            ++chan;
        }
        this.analyzerSection.sync();
        chan = 0;
        while (chan < this.nbChans) {
            Cmplx[][] frames = this.sourceAnalyzers[chan].analyzePushedInput(this.sourceIndexes[chan]);
            int k = 0;
            while (k < this.numHops) {
                this.srcSpectrum[k][chan] = frames[k];
                ++k;
            }
            frames = this.signalAnalyzers[chan].analyzePushedInput(this.signalIndexes[chan]);
            k = 0;
            while (k < this.numHops) {
                this.inSpectrum[k][chan] = frames[k];
                ++k;
            }
            ++chan;
        }
        this.engine.analyseSplitted(this.srcSpectrum, this.inSpectrum);
        chan = 0;
        while (chan < this.nbChans) {
            this.engine.processSplitted(this.inSpectrum, chan, this.shortx[chan], this.longx[chan]);
            ++chan;
        }
        if (this.noiseExtractor != null) {
            chan = 0;
            while (chan < this.nbChans) {
                int k = 0;
                while (k < this.longx.length) {
                    Cmplx[] sLong = this.longx[chan][k];
                    Cmplx[] sShort = this.shortx[chan][k];
                    BitSet noisy = this.noiseExtractor.analyze(sLong);
                    int i = 0;
                    while (i < sLong.length) {
                        if (!noisy.get(i)) {
                            sShort[i].add(sLong[i]);
                            sLong[i].clear();
                        } else {
                            sLong[i].mul(this.noiseCorrection);
                        }
                        ++i;
                    }
                    ++k;
                }
                ++chan;
            }
        }
        long synthClock = this.synthesizerSection.getClock();
        int chan2 = 0;
        while (chan2 < this.nbChans) {
            if (outShort != null) {
                this.shortSynthesizers[chan2].preSynthesize(this.shortx[chan2], synthClock);
            }
            if (outLong != null) {
                this.longSynthesizers[chan2].preSynthesize(this.longx[chan2], synthClock);
            }
            ++chan2;
        }
        this.synthesizerSection.sync();
        chan2 = 0;
        while (chan2 < this.nbChans) {
            if (outShort != null) {
                this.shortSynthesizers[chan2].renderResult(outShort[chan2], synthClock);
            }
            if (outLong != null) {
                this.longSynthesizers[chan2].renderResult(outLong[chan2], synthClock);
            }
            ++chan2;
        }
    }

    public int getLatency() {
        return this.longSynthesizers[0].getLatency();
    }

    public int getNumHops() {
        return this.numHops;
    }

    public int getNbBins() {
        return this.engine.getNbBins();
    }

    public float[] getEdgeRatios(int k, int chan) {
        return this.engine.getEdgeRatios(k, chan);
    }

    public void fillEdgeRatios(int chan, @Out float[][] edgeRatios) {
        this.engine.fillEdgeRatios(chan, edgeRatios);
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.analyzerSection = factory.createSerialSection(String.valueOf(ANALYZER_SECTION_NAME) + "." + this.name, null);
        this.synthesizerSection = factory.createSerialSection(String.valueOf(SYNTHESIZER_SECTION_NAME) + "." + this.name, null);
        int chan = 0;
        while (chan < this.nbChans) {
            this.sourceAnalyzers[chan].createSerialSections(factory);
            this.signalAnalyzers[chan].createSerialSections(factory);
            this.shortSynthesizers[chan].createSerialSections(factory);
            this.longSynthesizers[chan].createSerialSections(factory);
            ++chan;
        }
        this.engine.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.analyzerSection = pool.getSerialSection(String.valueOf(ANALYZER_SECTION_NAME) + "." + this.name);
        this.synthesizerSection = pool.getSerialSection(String.valueOf(SYNTHESIZER_SECTION_NAME) + "." + this.name);
        this.engine.setSerialSections(pool);
        int chan = 0;
        while (chan < this.nbChans) {
            this.sourceAnalyzers[chan].setSerialSections(pool);
            this.signalAnalyzers[chan].setSerialSections(pool);
            this.shortSynthesizers[chan].setSerialSections(pool);
            this.longSynthesizers[chan].setSerialSections(pool);
            ++chan;
        }
    }
}

