/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.adaptive;

import ch.tachyon.sonics.effect.base.adaptive.Cup;
import ch.tachyon.sonics.effect.base.adaptive.Dish;
import ch.tachyon.sonics.effect.base.adaptive.Fork;
import ch.tachyon.sonics.effect.base.adaptive.SharpInfo;
import ch.tachyon.sonics.effect.base.adaptive.Spoon;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IFourierEngine;
import ch.tachyon.sonics.effect.base.fourier.ISpectrumProcessor;
import ch.tachyon.sonics.effect.base.pyramid.PyramidAnalyzer;
import ch.tachyon.sonics.effect.base.pyramid.PyramidSynthesizer;
import ch.tachyon.sonics.effect.utils.buffer.ConcurrentDelayBuffer;
import ch.tachyon.sonics.effect.utils.buffer.ConcurrentDivider;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.Arrays;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;

public class LockedAdaptiveFourierEngine
implements IFourierEngine {
    private static final float NOISE_AMPLIFICATION = 1.5f;
    private static final String SPOON_SERIAL_SECTION_NAME = String.valueOf(LockedAdaptiveFourierEngine.class.getName()) + " spoon";
    private static final String CUP_SERIAL_SECTION_NAME = String.valueOf(LockedAdaptiveFourierEngine.class.getName()) + " cup";
    private static final String DELAYER_SERIAL_SECTION_NAME = String.valueOf(LockedAdaptiveFourierEngine.class.getName()) + " delayer";
    private static final String LOCK_SERIAL_SECTION_NAME = String.valueOf(LockedAdaptiveFourierEngine.class.getName()) + " lock";
    private FourierSpec specs;
    private boolean antiLeakage = false;
    private boolean requiresSource = false;
    private int nbLockedScales;
    private int nbBins;
    private int rlmaxBin;
    private float[][] mChan;
    private Fork fork;
    private Dish dish;
    private boolean ownForkAndDish = true;
    private Spoon[] spoons;
    private ConcurrentDelayBuffer orgDelayer;
    private ConcurrentDelayBuffer lockedDelayer;
    private Spoon[] orgSpoons;
    private Cup[] cups;
    private PyramidAnalyzer noiseAnalyzer;
    private ConcurrentDivider noiseDivider;
    private PyramidSynthesizer noiseSynthesizer;
    private Cmplx[][] spectrums;
    private Cmplx[][] orgSpectrums;
    private Cmplx[] sourcePhi;
    private float[] delayed;
    private float[] output;
    private float[][] noiseBlockIn;
    private float[] noiseBlockOut;
    private float[] noiseOutput;
    private PyramidAnalyzer orgNoiseAnalyzer;
    private ISerialSection spoonSerialSection;
    private ISerialSection cupSerialSection;
    private ISerialSection delayerSerialSection;
    private ISerialSection lockedSerialSection;
    private transient boolean noiseReady;
    private transient float[][] scales;
    private transient Cmplx[][][] noiseSpectrums;
    private transient long clock;

    public void setSpecs(FourierSpec specs) {
        this.specs = specs;
        this.antiLeakage = specs.getAntiLeakage();
        this.requiresSource = specs.getRequiresSource();
    }

    public void setForkAndDish(Fork fork, Dish dish) {
        this.fork = fork;
        this.dish = dish;
        this.ownForkAndDish = false;
    }

    public void startProcessing(IProcessingInfo info) {
        SharpInfo sharpInfoIn = this.specs.getLockedSharpInfo();
        SharpInfo sharpInfoSplit = this.specs.getLockedSharpInfoSplit();
        SharpInfo sharpInfoOut = this.specs.getLockedSharpInfoOut();
        this.nbLockedScales = this.specs.getNbLockedScales();
        if (this.fork == null) {
            this.fork = new Fork(1, sharpInfoSplit, false, this.specs.getNoiseMode(), 1.5f);
        }
        if (this.dish == null) {
            this.dish = new Dish(this.specs.getAdaptiveResolutions(), this.specs.getSplitFreqs(), this.specs.getNoiseSplitFreqs(), this.fork.getInputSize(), AudioMath.adjustPowerOf2(this.specs.getDishFftSize(), 44100.0f, info.getSampleRate()), info.getSampleRate());
        }
        this.spoons = new Spoon[this.nbLockedScales];
        this.orgSpoons = new Spoon[this.nbLockedScales];
        if (this.specs.isIncludeSynthesis()) {
            this.cups = new Cup[this.nbLockedScales];
        }
        int i = 0;
        while (i < this.nbLockedScales) {
            this.spoons[i] = new Spoon(sharpInfoIn, i);
            if (this.antiLeakage && i > 0 || this.requiresSource) {
                this.orgSpoons[i] = new Spoon("org", sharpInfoIn, i);
            }
            if (this.cups != null) {
                this.cups[i] = new Cup(sharpInfoOut, i, this.specs.getPostFftProcessor());
            }
            ++i;
        }
        if (this.specs.isUnlockedMode()) {
            int inChunkSize = this.fork.getInputSize();
            int outChunkSize = (int)((float)inChunkSize * this.specs.getTimeScale() + 0.5f);
            int inOverlap = (int)(this.specs.getOverlap() + 0.5f) * 2;
            int outOverlap = (int)(this.specs.getOverlap() / this.specs.getTimeScale() + 0.5f) * 2;
            int baseBlockSize = AudioMath.getCeilingPowerOf2(this.specs.getUnlockedResolutions()[0]);
            int noiseInChunkSize = baseBlockSize / inOverlap;
            int noiseOutChunkSize = baseBlockSize / outOverlap;
            int division = noiseInChunkSize / inChunkSize;
            int nLayers = this.specs.getNbUnLockedScales();
            this.noiseDivider = new ConcurrentDivider(inChunkSize, outChunkSize, division, nLayers * 2);
            this.noiseAnalyzer = new PyramidAnalyzer(this.specs.getUnlockedResolutions(), noiseInChunkSize, inOverlap, this.specs.getAnalysisWindow());
            this.noiseSynthesizer = new PyramidSynthesizer(this.specs.getUnlockedResolutions(), noiseOutChunkSize, outOverlap, this.specs.getModifiedWindow(), this.specs.getSynthesisWindow(), this.specs.getPostFftProcessor(), this.specs.getSynthesisShrink(), this.specs.getEnergyCorrection(), this.specs.getTimeScale());
            this.noiseAnalyzer.setClockDiv((long)division);
            this.noiseSynthesizer.setClockDiv((long)division);
            this.noiseOutput = new float[outChunkSize];
            this.noiseBlockIn = new float[nLayers * 2][noiseInChunkSize];
            this.noiseBlockOut = new float[noiseOutChunkSize];
            if (this.antiLeakage || this.requiresSource) {
                this.orgNoiseAnalyzer = new PyramidAnalyzer("orgNoise", this.specs.getUnlockedResolutions(), noiseInChunkSize, inOverlap, this.specs.getAnalysisWindow());
                this.orgNoiseAnalyzer.setClockDiv((long)division);
            }
        }
    }

    private void setupOrgDelayer(IMtContext mtContext) {
        int delayAmount = this.fork.getLatency() + this.dish.getLatency();
        int inputSize = this.fork.getInputSize();
        this.orgDelayer = new ConcurrentDelayBuffer(delayAmount, delayAmount + inputSize * mtContext.getSerialRunningMaxSkew(), inputSize);
    }

    private void setupLockDelayer(IMtContext mtContext) {
        int outputSize = this.cups[0].getHopSize();
        int lockLatency = this.cups[0].getLatency();
        int unlockLatency = this.noiseDivider.getLatency() + this.noiseSynthesizer.getLatency();
        int delayAmount = (unlockLatency += (int)((float)this.noiseSynthesizer.getBaseBlockSize() / 2.0f * (this.specs.getTimeScale() - 1.0f) + 0.5f)) - (lockLatency += (int)((float)this.cups[0].getBlockSize() / 2.0f * (this.specs.getTimeScale() - 1.0f) + 0.5f));
        this.lockedDelayer = new ConcurrentDelayBuffer(delayAmount, delayAmount + outputSize * mtContext.getSerialRunningMaxSkew(), outputSize);
    }

    public int getFixedChunkLength() {
        return this.fork.getInputSize();
    }

    public int getLatency() {
        int result = (int)((float)(this.fork.getLatency() + this.dish.getLatency()) * this.specs.getTimeScale() + 0.5f) + this.cups[0].getLatency();
        result += (int)((float)this.cups[0].getBlockSize() / 2.0f * (this.specs.getTimeScale() - 1.0f) + 0.5f);
        if (this.lockedDelayer != null) {
            result += this.lockedDelayer.getDelay();
        }
        return result;
    }

    public int getAnalysisLatency() {
        int result = 0;
        if (this.ownForkAndDish) {
            result += this.fork.getLatency();
            result += this.dish.getLatency();
        }
        return result += this.spoons[0].getAnalysisLatency();
    }

    public int getNbScales() {
        return this.specs.getNbScales();
    }

    public int getNbResolutions() {
        return 1;
    }

    public int getNbBins(int layer) {
        return this.getNbBins();
    }

    public int getNbBins() {
        return this.specs.getBaseResolution() / 2 + 1;
    }

    public int getEffectiveResolution(int layer) {
        return (int)(this.specs.getSharpInfo().layerInfo[layer].getAnalysisResolution() + 0.5f);
    }

    public int getNumHops(int scale) {
        return 1;
    }

    public int getInputHopSize() {
        return this.specs.getSharpInfo().hopSize;
    }

    public int getDistanceBetweenFrames(int res) {
        return this.specs.getSharpInfo().hopSize;
    }

    public void beginProcessing(IProcessingInfo info) {
        Spoon spoon;
        this.mChan = new float[1][];
        int blockSize = this.specs.getLockedSharpInfo().blockSize;
        this.rlmaxBin = this.nbBins = blockSize / 2 + 1;
        if (this.specs.isUnlockedMode()) {
            int[][] aRes = this.specs.getAdaptiveResolutions();
            int minNoiseRes = aRes[aRes.length - 1][aRes[aRes.length - 1].length - 1];
            int maxLockedIndex = 0;
            while (aRes[aRes.length - this.specs.getNbUnLockedScales() - 1][maxLockedIndex] >= minNoiseRes) {
                ++maxLockedIndex;
            }
            float[] sf = this.specs.getSplitFreqs();
            float splitFreq = maxLockedIndex == 0 ? 0.0f : sf[maxLockedIndex - 1];
            this.rlmaxBin = (int)((float)blockSize * splitFreq / info.getSampleRate()) + 1;
        }
        this.spectrums = new Cmplx[this.nbLockedScales][];
        if (this.antiLeakage || this.requiresSource) {
            this.orgSpectrums = new Cmplx[this.nbLockedScales][];
            this.delayed = new float[this.fork.getInputSize()];
            this.sourcePhi = Cmplx.newArray(this.nbBins);
        }
        if (this.ownForkAndDish) {
            this.fork.init();
            this.dish.init();
        }
        IHasSerialSections[] iHasSerialSectionsArray = this.spoons;
        int n = this.spoons.length;
        int n2 = 0;
        while (n2 < n) {
            spoon = iHasSerialSectionsArray[n2];
            spoon.init();
            ++n2;
        }
        iHasSerialSectionsArray = this.orgSpoons;
        n = this.orgSpoons.length;
        n2 = 0;
        while (n2 < n) {
            spoon = iHasSerialSectionsArray[n2];
            if (spoon != null) {
                spoon.init();
            }
            ++n2;
        }
        if (this.cups != null) {
            assert (this.specs.isIncludeSynthesis());
            iHasSerialSectionsArray = this.cups;
            n = this.cups.length;
            n2 = 0;
            while (n2 < n) {
                IHasSerialSections cup = iHasSerialSectionsArray[n2];
                ((Cup)cup).init();
                ++n2;
            }
        }
        if (this.specs.isUnlockedMode()) {
            this.noiseAnalyzer.init();
            this.noiseSynthesizer.init();
            if (this.antiLeakage || this.requiresSource) {
                this.orgNoiseAnalyzer.init();
            }
        }
        if (this.specs.getTimeScale() != 1.0f && this.specs.isIncludeSynthesis()) {
            this.output = new float[this.cups[0].getHopSize()];
        }
    }

    public float[] process(float[] input, ISpectrumProcessor processor) {
        this.mChan[0] = input;
        this.fork.process(this.mChan);
        if (this.antiLeakage || this.requiresSource) {
            long delayerClock = this.delayerSerialSection.getClock();
            this.orgDelayer.push(input, delayerClock);
            this.delayerSerialSection.sync();
            this.orgDelayer.pop(this.delayed, delayerClock);
        }
        this.analyze(0, this.delayed);
        this.process(processor, this.scales);
        return this.synthesize(input, this.noiseSpectrums, this.noiseReady);
    }

    public Cmplx[][] analyze(int chan, float[] delayedSource) {
        float[][] layers = this.fork.getOutputs(chan);
        float[][] scales = this.dish.process(layers);
        return this.analyze(scales, delayedSource);
    }

    public Cmplx[][] analyze(float[][] scales, float[] delayedSource) {
        this.scales = scales;
        int scale = 0;
        while (scale < this.nbLockedScales) {
            this.spoons[scale].preProcess(scales[scale], this.spoonSerialSection.getClock());
            ++scale;
        }
        if (this.antiLeakage || this.requiresSource) {
            scale = 0;
            while (scale < this.nbLockedScales) {
                if (this.orgSpoons[scale] != null) {
                    this.orgSpoons[scale].preProcess(delayedSource, this.spoonSerialSection.getClock());
                }
                ++scale;
            }
        }
        this.clock = this.spoonSerialSection.getClock();
        this.spoonSerialSection.sync();
        if (this.antiLeakage || this.requiresSource) {
            scale = 0;
            while (scale < this.nbLockedScales) {
                if (this.orgSpoons[scale] != null) {
                    this.orgSpectrums[scale] = this.orgSpoons[scale].postProcess();
                }
                ++scale;
            }
        }
        scale = 0;
        while (scale < this.nbLockedScales) {
            this.spectrums[scale] = this.spoons[scale].postProcess();
            ++scale;
        }
        if (this.antiLeakage) {
            int r = 1;
            while (r < this.nbLockedScales) {
                Cmplx[] orgSpectrum = this.orgSpectrums[r];
                Cmplx[] spectrum = this.spectrums[r];
                int maxBin = r == this.nbLockedScales - 1 ? this.rlmaxBin : spectrum.length;
                int i = 0;
                while (i < maxBin) {
                    float sigMag = spectrum[i].magApprox();
                    float srcMag = orgSpectrum[i].magApprox();
                    if (srcMag < sigMag) {
                        spectrum[i].mul(srcMag / sigMag);
                    }
                    ++i;
                }
                ++r;
            }
            this.fillAveragedPhases(this.spectrums);
            this.lockPhases(this.spectrums);
        }
        return this.spectrums;
    }

    private void process(ISpectrumProcessor processor, float[][] scales) {
        Cmplx[][] sources = this.requiresSource ? this.orgSpectrums : this.spectrums;
        int layer = 0;
        while (layer < this.spectrums.length) {
            processor.process(0, layer, sources[layer], this.spectrums[layer], 0, this.clock);
            ++layer;
        }
        this.noiseSpectrums = null;
        this.noiseReady = false;
        if (this.specs.isUnlockedMode()) {
            int noiseScaleIndex = this.specs.getNbLockedScales();
            int nbNoiseScales = this.specs.getNbUnLockedScales();
            float[][] noise = new float[nbNoiseScales * 2][];
            int i = 0;
            while (i < nbNoiseScales) {
                noise[nbNoiseScales - 1 - i] = scales[noiseScaleIndex + i];
                ++i;
            }
            i = 0;
            while (i < this.delayed.length) {
                int n = i++;
                this.delayed[n] = this.delayed[n] * 1.5f;
            }
            i = 0;
            while (i < nbNoiseScales) {
                noise[nbNoiseScales + i] = this.delayed;
                ++i;
            }
            this.noiseReady = this.noiseDivider.push(noise, this.noiseBlockIn);
            if (this.noiseReady) {
                int r;
                float[][] noiseSignal = new float[nbNoiseScales][];
                float[][] noiseOrg = new float[nbNoiseScales][];
                int i2 = 0;
                while (i2 < nbNoiseScales) {
                    noiseSignal[i2] = this.noiseBlockIn[i2];
                    noiseOrg[i2] = this.noiseBlockIn[nbNoiseScales + i2];
                    ++i2;
                }
                long noiseClock = this.noiseAnalyzer.getClock();
                this.noiseSpectrums = this.noiseAnalyzer.analyze((float[][])noiseSignal);
                Cmplx[][][] orgNoiseSpectrums = null;
                if (this.antiLeakage || this.requiresSource) {
                    orgNoiseSpectrums = this.orgNoiseAnalyzer.analyze((float[][])noiseOrg);
                    assert (this.noiseSpectrums.length == orgNoiseSpectrums.length);
                    r = 0;
                    while (r < this.noiseSpectrums.length) {
                        assert (this.noiseSpectrums[r].length == orgNoiseSpectrums[r].length);
                        int k = 0;
                        while (k < this.noiseSpectrums[r].length) {
                            Cmplx[] orgSpectrum = orgNoiseSpectrums[r][k];
                            Cmplx[] spectrum = this.noiseSpectrums[r][k];
                            int i3 = 0;
                            while (i3 < spectrum.length) {
                                float sigMag = spectrum[i3].magApprox();
                                float srcMag = orgSpectrum[i3].magApprox();
                                if (srcMag < sigMag) {
                                    spectrum[i3].mul(srcMag / sigMag);
                                }
                                ++i3;
                            }
                            ++k;
                        }
                        ++r;
                    }
                }
                r = 0;
                while (r < this.noiseSpectrums.length) {
                    Cmplx[][] frames = this.noiseSpectrums[r];
                    Cmplx[][] nsources = this.requiresSource ? orgNoiseSpectrums[r] : this.noiseSpectrums[r];
                    int numHops = this.noiseAnalyzer.getNumHops(r);
                    assert (frames.length == numHops && nsources.length == numHops);
                    int k = 0;
                    while (k < frames.length) {
                        processor.process(r + 1, 0, nsources[k], frames[k], 0, noiseClock * (long)numHops + (long)k);
                        ++k;
                    }
                    ++r;
                }
            } else {
                this.noiseAnalyzer.pass();
                if (this.antiLeakage || this.requiresSource) {
                    this.orgNoiseAnalyzer.pass();
                }
            }
        }
    }

    private float[] synthesize(float[] input, Cmplx[][][] noiseSpectrums, boolean noiseReady) {
        float[] output = this.output == null ? input : this.output;
        Arrays.fill(output, 0.0f);
        long cupClock = this.cupSerialSection.getClock();
        int scale = 0;
        while (scale < this.nbLockedScales) {
            this.cups[scale].preProcessAdd(this.spectrums[scale], cupClock);
            ++scale;
        }
        this.cupSerialSection.sync();
        scale = 0;
        while (scale < this.nbLockedScales) {
            this.cups[scale].postProcessAdd(output, cupClock);
            ++scale;
        }
        if (this.specs.isUnlockedMode()) {
            long lockedClock = this.lockedSerialSection.getClock();
            this.lockedDelayer.push(output, lockedClock);
            this.lockedSerialSection.sync();
            this.lockedDelayer.pop(output, lockedClock);
            if (noiseReady) {
                this.noiseSynthesizer.synthesize(noiseSpectrums, this.noiseBlockOut);
            } else {
                this.noiseSynthesizer.pass();
            }
            this.noiseDivider.pop(this.noiseBlockOut, this.noiseOutput);
            assert (output.length == this.noiseOutput.length);
            if (this.specs.getPostLockedProcessor() != null) {
                this.specs.getPostLockedProcessor().postProcess(output, this.noiseOutput);
            }
            int i = 0;
            while (i < this.noiseOutput.length) {
                int n = i;
                output[n] = output[n] + this.noiseOutput[i];
                ++i;
            }
        }
        return output;
    }

    private void fillAveragedPhases(Cmplx[][] spectrums) {
        Cmplx[] spectrum = spectrums[0];
        int i = 0;
        while (i < this.nbBins) {
            this.sourcePhi[i].set(spectrum[i]);
            ++i;
        }
        int scale = 1;
        while (scale < this.nbLockedScales) {
            Cmplx[] spectrum2 = spectrums[scale];
            int i2 = 0;
            while (i2 < this.nbBins) {
                this.sourcePhi[i2].add(spectrum2[i2]);
                ++i2;
            }
            ++scale;
        }
        int i3 = 0;
        while (i3 < this.nbBins) {
            float mag = this.sourcePhi[i3].magApprox();
            if (mag > Float.MIN_NORMAL) {
                this.sourcePhi[i3].mul(1.0f / mag);
            }
            ++i3;
        }
    }

    private void lockPhases(Cmplx[][] spectrums) {
        Cmplx[][] cmplxArray = spectrums;
        int n = spectrums.length;
        int n2 = 0;
        while (n2 < n) {
            Cmplx[] spectrum = cmplxArray[n2];
            int i = 0;
            while (i < this.nbBins) {
                float mag = spectrum[i].magApprox();
                spectrum[i].set(this.sourcePhi[i]);
                spectrum[i].mul(mag);
                ++i;
            }
            ++n2;
        }
    }

    public void stopProcessing() {
        this.noiseSpectrums = null;
        this.scales = null;
        this.mChan = null;
        this.fork = null;
        this.dish = null;
        this.spoons = null;
        this.orgSpoons = null;
        this.orgDelayer = null;
        this.lockedDelayer = null;
        this.noiseDivider = null;
        this.noiseAnalyzer = null;
        this.orgNoiseAnalyzer = null;
        this.noiseSynthesizer = null;
        this.noiseOutput = null;
        this.delayed = null;
        this.cups = null;
        this.mChan = null;
        this.spectrums = null;
        this.orgSpectrums = null;
        this.sourcePhi = null;
        this.specs = null;
        this.output = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        Spoon spoon;
        if (this.ownForkAndDish) {
            this.fork.createSerialSections(factory);
            this.dish.createSerialSections(factory);
        }
        this.spoonSerialSection = factory.createSerialSection(SPOON_SERIAL_SECTION_NAME, null);
        this.cupSerialSection = factory.createSerialSection(CUP_SERIAL_SECTION_NAME, null);
        IHasSerialSections[] iHasSerialSectionsArray = this.spoons;
        int n = this.spoons.length;
        int n2 = 0;
        while (n2 < n) {
            spoon = iHasSerialSectionsArray[n2];
            spoon.createSerialSections(factory);
            ++n2;
        }
        iHasSerialSectionsArray = this.orgSpoons;
        n = this.orgSpoons.length;
        n2 = 0;
        while (n2 < n) {
            spoon = iHasSerialSectionsArray[n2];
            if (spoon != null) {
                spoon.createSerialSections(factory);
            }
            ++n2;
        }
        if (this.cups != null) {
            assert (this.specs.isIncludeSynthesis());
            iHasSerialSectionsArray = this.cups;
            n = this.cups.length;
            n2 = 0;
            while (n2 < n) {
                IHasSerialSections cup = iHasSerialSectionsArray[n2];
                ((Cup)cup).createSerialSections(factory);
                ++n2;
            }
        }
        if (this.antiLeakage || this.requiresSource) {
            this.setupOrgDelayer(factory.getMtContext());
            this.delayerSerialSection = factory.createSerialSection(DELAYER_SERIAL_SECTION_NAME, this.orgDelayer);
        }
        if (this.specs.isUnlockedMode()) {
            this.setupLockDelayer(factory.getMtContext());
            this.noiseDivider.createSerialSections(factory);
            this.noiseAnalyzer.createSerialSections(factory);
            this.noiseSynthesizer.createSerialSections(factory);
            this.lockedSerialSection = factory.createSerialSection(LOCK_SERIAL_SECTION_NAME, this.lockedDelayer);
            if (this.antiLeakage || this.requiresSource) {
                this.orgNoiseAnalyzer.createSerialSections(factory);
            }
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        Spoon spoon;
        if (this.ownForkAndDish) {
            this.fork.setSerialSections(pool);
            this.dish.setSerialSections(pool);
        }
        this.spoonSerialSection = pool.getSerialSection(SPOON_SERIAL_SECTION_NAME);
        this.cupSerialSection = pool.getSerialSection(CUP_SERIAL_SECTION_NAME);
        IHasSerialSections[] iHasSerialSectionsArray = this.spoons;
        int n = this.spoons.length;
        int n2 = 0;
        while (n2 < n) {
            spoon = iHasSerialSectionsArray[n2];
            spoon.setSerialSections(pool);
            ++n2;
        }
        iHasSerialSectionsArray = this.orgSpoons;
        n = this.orgSpoons.length;
        n2 = 0;
        while (n2 < n) {
            spoon = iHasSerialSectionsArray[n2];
            if (spoon != null) {
                spoon.setSerialSections(pool);
            }
            ++n2;
        }
        if (this.cups != null) {
            iHasSerialSectionsArray = this.cups;
            n = this.cups.length;
            n2 = 0;
            while (n2 < n) {
                IHasSerialSections cup = iHasSerialSectionsArray[n2];
                ((Cup)cup).setSerialSections(pool);
                ++n2;
            }
        }
        if (this.antiLeakage || this.requiresSource) {
            this.delayerSerialSection = pool.getSerialSection(DELAYER_SERIAL_SECTION_NAME);
            this.orgDelayer = (ConcurrentDelayBuffer)this.delayerSerialSection.getUserData();
        }
        if (this.specs.isUnlockedMode()) {
            this.noiseDivider.setSerialSections(pool);
            this.noiseAnalyzer.setSerialSections(pool);
            this.noiseSynthesizer.setSerialSections(pool);
            this.lockedSerialSection = pool.getSerialSection(LOCK_SERIAL_SECTION_NAME);
            this.lockedDelayer = (ConcurrentDelayBuffer)this.lockedSerialSection.getUserData();
            if (this.antiLeakage || this.requiresSource) {
                this.orgNoiseAnalyzer.setSerialSections(pool);
            }
        }
    }
}

