/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.fourier;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IFourierEngine;
import ch.tachyon.sonics.effect.base.fourier.ISpectrumProcessor;
import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IPushEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.math.Cmplx;

public abstract class FourierPushEffectBase
extends EffectBase
implements IPushEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections,
ISpectrumProcessor {
    private FourierSpec specs;
    private IFourierEngine engine;

    protected FourierPushEffectBase() {
    }

    protected abstract FourierSpec getSpecs(IProcessingInfo var1);

    protected int getNbScales() {
        return this.engine != null ? this.engine.getNbScales() : this.specs.getNbLayers();
    }

    protected final int getNbResolutions() {
        return this.engine.getNbResolutions();
    }

    protected final int getNumHops(int scale) {
        return this.engine.getNumHops(scale);
    }

    protected final int getInputHopSize() {
        return this.engine.getInputHopSize();
    }

    public void startProcessing(IProcessingInfo info) {
        this.specs = this.getSpecs(info);
        this.engine = this.specs.getProcessingType().createEngine();
        this.engine.setSpecs(this.specs);
        this.engine.startProcessing(info);
    }

    public final int getFixedChunkLength() {
        return this.engine.getFixedChunkLength();
    }

    public int getLatency(IoDirection ioDirection) {
        int result = this.engine.getLatency();
        if (ioDirection == IoDirection.INPUT) {
            result = (int)((float)result / this.specs.getTimeScale() + 0.5f);
        }
        return result;
    }

    public void beginProcessing(IProcessingInfo info) {
        this.engine.beginProcessing(info);
    }

    public boolean canWriteFasterThanRead() {
        return true;
    }

    public void process(float[] input, int length, ISingleChanAudioSink target) {
        float[] output = this.engine.process(input, this);
        if (length == input.length) {
            target.writeSamples(output);
        } else {
            float[] lastOutput = new float[(int)((long)length * (long)output.length / (long)input.length)];
            System.arraycopy(output, 0, lastOutput, 0, lastOutput.length);
            target.writeSamples(lastOutput);
        }
    }

    public abstract void process(int var1, int var2, Cmplx[] var3, Cmplx[] var4, int var5, long var6);

    public void stopProcessing() {
        this.engine.stopProcessing();
        this.engine = null;
        this.specs = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.engine.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.engine.setSerialSections(pool);
    }
}

