/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.fourier;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IFourierEngine;
import ch.tachyon.sonics.effect.base.fourier.ISpectrumProcessor;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.ISimpleEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.math.Cmplx;

public abstract class FourierSimpleEffectBase
extends EffectBase
implements ISimpleEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections,
ISpectrumProcessor {
    private IFourierEngine engine;
    private FourierSpec specs;

    protected FourierSimpleEffectBase() {
    }

    protected abstract FourierSpec getSpecs(IProcessingInfo var1);

    protected int getNbScales() {
        return this.engine != null ? this.engine.getNbScales() : this.specs.getNbLayers();
    }

    protected final int getNbResolutions() {
        return this.engine.getNbResolutions();
    }

    protected final int getNumHops(int scale) {
        return this.engine.getNumHops(scale);
    }

    public void startProcessing(IProcessingInfo info) {
        this.specs = this.getSpecs(info);
        this.engine = this.specs.getProcessingType().createEngine();
        this.engine.setSpecs(this.specs);
        this.engine.startProcessing(info);
    }

    public final int getFixedChunkLength() {
        return this.engine.getFixedChunkLength();
    }

    public int getLatency(IoDirection ioDirection) {
        return this.engine.getLatency();
    }

    public void beginProcessing(IProcessingInfo info) {
        this.engine.beginProcessing(info);
    }

    public void process(float[] data) {
        this.engine.process(data, this);
    }

    public int getNumSteps() {
        return 1;
    }

    public abstract void process(int var1, int var2, Cmplx[] var3, Cmplx[] var4, int var5, long var6);

    protected final int getNbBins() {
        return this.engine.getNbBins();
    }

    protected final int getNbBins(int res) {
        return this.engine.getNbBins(res);
    }

    protected final int getInputHopSize() {
        return this.specs.getInputHopSize();
    }

    protected final int getDistanceBetweenFrames(int res) {
        return this.engine.getDistanceBetweenFrames(res);
    }

    public void stopProcessing() {
        this.engine.stopProcessing();
        this.engine = null;
        this.specs = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.engine.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.engine.setSerialSections(pool);
    }
}

