/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.fourier;

import ch.tachyon.sonics.effect.base.adaptive.SharpInfo;
import ch.tachyon.sonics.effect.base.fourier.FourierProcessingType;
import ch.tachyon.sonics.effect.base.fourier.IFourierLatency;
import ch.tachyon.sonics.effect.base.fourier.IPostFftProcessor;
import ch.tachyon.sonics.effect.base.fourier.IPostLockedProcessor;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.TreeSet;
import org.corebounce.common.audio.AudioMath;

public class FourierSpec
implements Cloneable,
Serializable {
    private final float sampleRate;
    private FourierProcessingType processingType = FourierProcessingType.SIMPLE;
    private int baseResolution = 4096;
    private float overlap = 8.0f;
    private Integer outputHopSize;
    private float[] analysisWindow;
    private float[] modifiedWindow;
    private float[] synthesisWindow;
    private int nbLayers = 3;
    private float division = 2.0f;
    private float synthesisShrink = 1.0f;
    private boolean energyCorrection = true;
    private boolean multihop = true;
    private Integer preferredHopSize;
    private boolean antiLeakage = false;
    private boolean requiresSource = false;
    private int nbLockedLayers = -1;
    private Float maxSynthesisSize = null;
    private float analysisShrink = 1.0f;
    private int[] pyramidResolutions;
    private float[] splitFreqs;
    private int[][] adaptiveResolutions;
    private SharpInfo sharpInfo;
    private SharpInfo sharpInfoSplit;
    private boolean minimizeNumHops;
    private boolean noiseMode;
    private float[] noiseSplitFreqs;
    private int dishFftSize = 512;
    private boolean includeSynthesis = true;
    private IFourierLatency fourierLatency;
    private IPostFftProcessor postFftProcessor;
    private IPostLockedProcessor postLockedProcessor;
    private int[] scales;
    private float lockedMaxSynthesisSize = -1.0f;
    private int[] lockedScales;
    private int nbUnLockedScales = -1;
    private int[][] lockedResolutions;
    private int[] unlockedResolutions;
    private SharpInfo lockedSharpInfo;
    private SharpInfo lockedSharpInfoSplit;

    public FourierSpec() {
        this(44100.0f);
    }

    public FourierSpec(float sampleRate) {
        this.sampleRate = sampleRate;
    }

    public FourierSpec(int fftSize, int overlap) {
        this();
        this.setProcessingType(FourierProcessingType.SIMPLE);
        this.setBaseResolution(fftSize);
        this.setOverlap(overlap);
    }

    public FourierProcessingType getProcessingType() {
        return this.processingType;
    }

    public void setProcessingType(FourierProcessingType processingType) {
        this.processingType = processingType;
    }

    public int getBaseResolution() {
        return this.baseResolution;
    }

    public void setBaseResolution(int baseResolution) {
        this.baseResolution = baseResolution;
    }

    public int getFftResolution() {
        return AudioMath.getCeilingPowerOf2(this.baseResolution);
    }

    public float getOverlap() {
        return this.overlap;
    }

    public int getIntOverlap() {
        return (int)(this.overlap + 0.5f);
    }

    public void setOverlap(float overlap) {
        this.overlap = overlap;
    }

    public int getInputHopSize() {
        return (int)((float)this.getFftResolution() / this.getOverlap() + 0.5f);
    }

    public int getOutputHopSize() {
        if (this.outputHopSize == null) {
            this.outputHopSize = this.getInputHopSize();
        }
        return this.outputHopSize;
    }

    public void setOutputHopSize(int outputHopSize) {
        this.outputHopSize = outputHopSize;
    }

    public float getTimeScale() {
        return (float)this.getOutputHopSize() / (float)this.getInputHopSize();
    }

    public float[] getAnalysisWindow() {
        if (this.analysisWindow == null) {
            float padShrink = (float)this.getFftResolution() / (float)this.getBaseResolution();
            this.analysisWindow = WindowsFactory.getHannWindow(this.getFftResolution(), this.analysisShrink * padShrink, this.energyCorrection);
        }
        return this.analysisWindow;
    }

    public void setAnalysisWindow(float[] analysisWindow) {
        this.analysisWindow = analysisWindow;
    }

    public float[] getModifiedWindow() {
        if (this.modifiedWindow == null) {
            this.modifiedWindow = this.analysisWindow;
        }
        return this.modifiedWindow;
    }

    public void setModifiedWindow(float[] modifiedWindow) {
        this.modifiedWindow = modifiedWindow;
    }

    public float[] getSynthesisWindow() {
        if (this.synthesisWindow == null) {
            float padShrink = (float)this.getFftResolution() / (float)this.getBaseResolution();
            if (this.overlap * padShrink < 1.4f) {
                this.synthesisWindow = new float[this.baseResolution];
                Arrays.fill(this.synthesisWindow, 1.0f);
            } else {
                this.synthesisWindow = WindowsFactory.getHannWindow(this.getFftResolution(), this.synthesisShrink * padShrink);
            }
        }
        return this.synthesisWindow;
    }

    public void setSynthesisWindow(float[] synthesisWindow) {
        this.synthesisWindow = synthesisWindow;
    }

    public int getNbLayers() {
        return this.nbLayers;
    }

    public void setNbLayers(int nbLayers) {
        this.nbLayers = nbLayers;
        if (this.nbLockedLayers < 0) {
            this.nbLockedLayers = nbLayers;
        }
    }

    public int getNbLockedLayers() {
        if (this.nbLockedLayers < 0) {
            this.nbLockedLayers = this.getNbLayers();
        }
        return this.nbLockedLayers;
    }

    public void setNbLockedLayers(int nbLockedLayers) {
        this.nbLockedLayers = nbLockedLayers;
    }

    public float getDivision() {
        return this.division;
    }

    public void setDivision(float division) {
        this.division = division;
    }

    public float getSynthesisShrink() {
        return this.synthesisShrink;
    }

    public void setSynthesisShrink(float synthesisShrink) {
        this.synthesisShrink = synthesisShrink;
    }

    public boolean getEnergyCorrection() {
        return this.energyCorrection;
    }

    public void setEnergyCorrection(boolean energyCorrection) {
        this.energyCorrection = energyCorrection;
    }

    public boolean getMultihop() {
        return this.multihop;
    }

    public void setMultihop(boolean multihop) {
        this.multihop = multihop;
    }

    public Integer getPreferredHopSize() {
        return this.preferredHopSize;
    }

    public void setPreferredHopSize(Integer preferredHopSize) {
        this.preferredHopSize = preferredHopSize;
    }

    public boolean getAntiLeakage() {
        return this.antiLeakage;
    }

    public void setAntiLeakage(boolean antiLeakage) {
        this.antiLeakage = antiLeakage;
    }

    public boolean getRequiresSource() {
        return this.requiresSource;
    }

    public void setRequiresSource(boolean requiresSource) {
        this.requiresSource = requiresSource;
    }

    public float getMaxSynthesisSize() {
        if (this.maxSynthesisSize == null) {
            this.maxSynthesisSize = Float.valueOf(this.getBaseResolution());
        }
        return this.maxSynthesisSize.floatValue();
    }

    public void setMaxSynthesisSize(float maxSynthesisSize) {
        this.maxSynthesisSize = Float.valueOf(maxSynthesisSize);
    }

    public float getAnalysisShrink() {
        return this.analysisShrink;
    }

    public void setAnalysisShrink(float zeroShrink) {
        this.analysisShrink = zeroShrink;
    }

    public int[] getPyramidResolutions() {
        if (this.pyramidResolutions == null) {
            this.pyramidResolutions = new int[this.nbLayers];
            float res = this.baseResolution;
            int i = 0;
            while (i < this.nbLayers) {
                this.pyramidResolutions[i] = (int)(res + 0.5f);
                res /= this.division;
                ++i;
            }
        }
        return this.pyramidResolutions;
    }

    public void setPyramidResolutions(int[] pyramidResolutions) {
        this.pyramidResolutions = pyramidResolutions;
        this.setBaseResolution(pyramidResolutions[0]);
    }

    public int[] getMultiScaleResolutions() {
        return this.getPyramidResolutions();
    }

    public int[] getOrgResolutions() {
        int[] resolutions = this.getMultiScaleResolutions();
        if (this.getRequiresSource()) {
            return resolutions;
        }
        int[] result = new int[resolutions.length - 1];
        System.arraycopy(resolutions, 0, result, 0, result.length);
        return result;
    }

    public float[] getSplitFreqs() {
        if (this.splitFreqs == null) {
            if (this.getNbPyramidResolutions() == 5) {
                this.splitFreqs = new float[]{1250.0f, 3700.0f, 6400.0f, 10000.0f};
            } else if (this.getNbPyramidResolutions() == 4) {
                this.splitFreqs = new float[]{3700.0f, 6400.0f, 10000.0f};
            }
        }
        return this.splitFreqs;
    }

    public void setSplitFreqs(float[] splitFreqs) {
        this.splitFreqs = splitFreqs;
    }

    public int[][] getAdaptiveResolutions() {
        if (this.adaptiveResolutions == null) {
            this.adaptiveResolutions = new int[][]{{512, 512, 256, 256, 256}, {2048, 2048, 1024, 1024, 1024}, {16384, 8192, 4096, 2048, 1024}};
        }
        return this.adaptiveResolutions;
    }

    public void setAdaptiveResolutions(int[][] adaptiveResolutions) {
        this.adaptiveResolutions = adaptiveResolutions;
        this.nbLayers = adaptiveResolutions.length;
        this.setBaseResolution(adaptiveResolutions[adaptiveResolutions.length - 1][0]);
    }

    public int getNbPyramidResolutions() {
        if (this.adaptiveResolutions != null) {
            return this.adaptiveResolutions[0].length;
        }
        return this.getPyramidResolutions().length;
    }

    public int[] getScales() {
        if (this.scales == null) {
            TreeSet scaleTree = new TreeSet(Collections.reverseOrder());
            this.getAdaptiveResolutions();
            int i = 0;
            while (i < this.adaptiveResolutions.length) {
                int j = 0;
                while (j < this.adaptiveResolutions[i].length) {
                    scaleTree.add(this.adaptiveResolutions[i][j]);
                    ++j;
                }
                ++i;
            }
            ArrayList scaleList = new ArrayList(scaleTree);
            this.scales = new int[scaleList.size()];
            int i2 = 0;
            while (i2 < this.scales.length) {
                this.scales[i2] = (Integer)scaleList.get(i2);
                ++i2;
            }
        }
        return this.scales;
    }

    public int getNbScales() {
        return this.getScales().length;
    }

    public SharpInfo getSharpInfo() {
        if (this.sharpInfo == null) {
            if (this.adaptiveResolutions != null) {
                int[] scales = FourierSpec.reverse(this.getScales());
                this.sharpInfo = new SharpInfo(scales, this.getMaxSynthesisSize(), this.overlap, this.energyCorrection, this.analysisShrink, this.sampleRate);
            } else {
                this.sharpInfo = new SharpInfo(this.baseResolution, this.baseResolution, this.nbLayers, this.division, this.getMaxSynthesisSize(), this.overlap, this.energyCorrection, this.analysisShrink, this.sampleRate);
            }
        }
        return this.sharpInfo;
    }

    private static int[] reverse(int[] array) {
        int[] result = new int[array.length];
        int i = 0;
        while (i < array.length) {
            result[array.length - 1 - i] = array[i];
            ++i;
        }
        return result;
    }

    public void setSharpInfo(SharpInfo sharpInfo) {
        this.sharpInfo = sharpInfo;
    }

    public SharpInfo getSharpInfoOut() {
        return this.getSharpInfo().scaleCopy(this.getTimeScale(), this.getSynthesisShrink());
    }

    public SharpInfo getSharpInfoSplit() {
        if (this.sharpInfoSplit == null) {
            if (this.nbLayers != this.getAdaptiveResolutions().length) {
                throw new IllegalStateException();
            }
            int minRes = this.adaptiveResolutions[0][this.adaptiveResolutions[0].length - 1];
            int maxRes = this.adaptiveResolutions[this.adaptiveResolutions.length - 1][0];
            float divider = (float)Math.pow((double)maxRes / (double)minRes, 1.0 / (double)(this.nbLayers - 1));
            this.sharpInfoSplit = new SharpInfo(maxRes, minRes, this.nbLayers, divider, this.getMaxSynthesisSize(), this.overlap, this.energyCorrection, this.analysisShrink, this.sampleRate);
        }
        return this.sharpInfoSplit;
    }

    public void setSharpInfoSplit(SharpInfo sharpInfoSplit) {
        this.sharpInfoSplit = sharpInfoSplit;
    }

    public boolean getMinimizeNumHops() {
        return this.minimizeNumHops;
    }

    public void setMinimizeNumHops(boolean minimizeNumHops) {
        this.minimizeNumHops = minimizeNumHops;
    }

    public boolean getNoiseMode() {
        return this.noiseMode;
    }

    public void setNoiseMode(boolean noiseMode) {
        this.noiseMode = noiseMode;
    }

    public IFourierLatency getFourierLatency() {
        return this.fourierLatency;
    }

    public void setFourierLatency(IFourierLatency fourierLatency) {
        this.fourierLatency = fourierLatency;
    }

    public IPostFftProcessor getPostFftProcessor() {
        return this.postFftProcessor;
    }

    public void setPostFftProcessor(IPostFftProcessor postFftProcessor) {
        this.postFftProcessor = postFftProcessor;
    }

    public IPostLockedProcessor getPostLockedProcessor() {
        return this.postLockedProcessor;
    }

    public void setPostLockedProcessor(IPostLockedProcessor postOlaProcessor) {
        this.postLockedProcessor = postOlaProcessor;
    }

    public void setResolution(int baseResolution, float overlap, int nbLayers, float division, float synthesisShrink, boolean energyCorrection) {
        this.setBaseResolution(baseResolution);
        this.setOverlap(overlap);
        this.setNbLayers(nbLayers);
        this.setDivision(division);
        this.setSynthesisShrink(synthesisShrink);
        this.setEnergyCorrection(energyCorrection);
    }

    public int getLockedBaseResolution() {
        int[][] lr = this.getLockedResolutions();
        return lr[lr.length - 1][0];
    }

    public void setLockedMaxSynthesisSize(float value) {
        this.lockedMaxSynthesisSize = value;
    }

    public float getLockedMaxSynthesisSize() {
        if (this.lockedMaxSynthesisSize < 0.0f) {
            this.lockedMaxSynthesisSize = this.getLockedBaseResolution();
        }
        return this.lockedMaxSynthesisSize;
    }

    public int[] getLockedScales() {
        if (this.lockedScales == null) {
            TreeSet scaleTree = new TreeSet(Collections.reverseOrder());
            int i = 0;
            while (i < this.getNbLockedLayers()) {
                int j = 0;
                while (j < this.adaptiveResolutions[i].length) {
                    scaleTree.add(this.adaptiveResolutions[i][j]);
                    ++j;
                }
                ++i;
            }
            ArrayList scaleList = new ArrayList(scaleTree);
            this.lockedScales = new int[scaleList.size()];
            int i2 = 0;
            while (i2 < this.lockedScales.length) {
                this.lockedScales[i2] = (Integer)scaleList.get(i2);
                ++i2;
            }
        }
        return this.lockedScales;
    }

    public int getNbUnLockedScales() {
        if (this.nbUnLockedScales < 0) {
            int[][] ar = this.getAdaptiveResolutions();
            int[] scales = this.getScales();
            int maxLockedRes = ar[this.getNbLockedLayers() - 1][0];
            this.nbUnLockedScales = 0;
            while (this.nbUnLockedScales < scales.length && scales[this.nbUnLockedScales] > maxLockedRes) {
                ++this.nbUnLockedScales;
            }
        }
        return this.nbUnLockedScales;
    }

    public boolean isUnlockedMode() {
        return this.getNbUnLockedScales() > 0;
    }

    public int getNbLockedScales() {
        return this.getNbScales() - this.getNbUnLockedScales();
    }

    public int[][] getLockedResolutions() {
        if (this.lockedResolutions == null) {
            this.lockedResolutions = new int[this.getNbLockedLayers()][];
            System.arraycopy(this.getAdaptiveResolutions(), 0, this.lockedResolutions, 0, this.getNbLockedLayers());
        }
        return this.lockedResolutions;
    }

    public int[] getUnlockedResolutions() {
        if (this.unlockedResolutions == null) {
            int[] scales = this.getScales();
            this.unlockedResolutions = new int[this.getNbUnLockedScales()];
            System.arraycopy(scales, 0, this.unlockedResolutions, 0, this.unlockedResolutions.length);
        }
        return this.unlockedResolutions;
    }

    public SharpInfo getLockedSharpInfo() {
        if (this.lockedSharpInfo == null) {
            int[] scales = FourierSpec.reverse(this.getLockedScales());
            this.lockedSharpInfo = new SharpInfo(scales, this.getLockedMaxSynthesisSize(), this.overlap, this.energyCorrection, this.analysisShrink, this.sampleRate);
        }
        return this.lockedSharpInfo;
    }

    public SharpInfo getLockedSharpInfoSplit() {
        if (this.lockedSharpInfoSplit == null) {
            if (this.nbLayers != this.getAdaptiveResolutions().length) {
                throw new IllegalStateException();
            }
            int[][] lockedResolutions = this.getLockedResolutions();
            int minRes = lockedResolutions[0][lockedResolutions[0].length - 1];
            int maxRes = lockedResolutions[lockedResolutions.length - 1][0];
            float divider = (float)Math.pow((double)maxRes / (double)minRes, 1.0 / (double)(this.nbLayers - 1));
            this.lockedSharpInfoSplit = new SharpInfo(maxRes, minRes, this.nbLayers, divider, this.getLockedMaxSynthesisSize(), this.overlap, this.energyCorrection, this.analysisShrink, this.sampleRate);
        }
        return this.lockedSharpInfoSplit;
    }

    public SharpInfo getLockedSharpInfoOut() {
        return this.getLockedSharpInfo().scaleCopy(this.getTimeScale(), this.getSynthesisShrink());
    }

    public float[] getNoiseSplitFreqs() {
        if (this.noiseSplitFreqs != null) {
            return this.noiseSplitFreqs;
        }
        return this.getSplitFreqs();
    }

    public void setNoiseSplitFreqs(float[] noiseSplitFreqs) {
        this.noiseSplitFreqs = noiseSplitFreqs;
    }

    public int getDishFftSize() {
        return this.dishFftSize;
    }

    public void setDishFftSize(int dishFftSize) {
        this.dishFftSize = dishFftSize;
    }

    public boolean isIncludeSynthesis() {
        return this.includeSynthesis;
    }

    public void setIncludeSynthesis(boolean includeSynthesis) {
        this.includeSynthesis = includeSynthesis;
    }

    public FourierSpec clone() {
        try {
            return (FourierSpec)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }
}

