/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.fourier;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IFourierEngine;
import ch.tachyon.sonics.effect.base.fourier.ISpectrumProcessor;
import ch.tachyon.sonics.effect.utils.InOutResampler;
import ch.tachyon.sonics.effect.utils.buffer.Rebufferizer;
import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IPushEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.Arrays;
import org.corebounce.common.math.Cmplx;

public abstract class ResampledFourierEffectBase
extends EffectBase
implements IPushEffect,
IStartStop,
IBeginProcessing,
ILatency,
IHasSerialSections,
ISpectrumProcessor {
    private IFourierEngine engine;
    private FourierSpec specs;
    private double resampleRatio;
    private InOutResampler preResampler;
    private Rebufferizer rebufferizer;
    private InOutResampler postResampler;
    private int remainingSamples;

    protected ResampledFourierEffectBase() {
    }

    protected abstract FourierSpec getSpecs(IProcessingInfo var1);

    protected abstract double getResampleRatio(IProcessingInfo var1, FourierSpec var2);

    protected int getNbScales() {
        return this.engine != null ? this.engine.getNbScales() : this.specs.getNbLayers();
    }

    protected final int getNbResolutions() {
        return this.engine.getNbResolutions();
    }

    protected final int getNumHops(int scale) {
        return this.engine.getNumHops(scale);
    }

    public void startProcessing(IProcessingInfo info) {
        this.specs = this.getSpecs(info);
        this.specs.setMultihop(false);
        this.resampleRatio = this.getResampleRatio(info, this.specs);
        this.engine = this.specs.getProcessingType().createEngine();
        this.engine.setSpecs(this.specs);
        this.engine.startProcessing(info);
        this.preResampler = new InOutResampler(this.resampleRatio, 3, info.getMaxChunkLength(this.specs.getBaseResolution()));
        this.rebufferizer = new Rebufferizer(this.preResampler.getMaxOutputLength(), this.specs.getInputHopSize());
        this.postResampler = new InOutResampler(1.0 / this.resampleRatio, 3, this.preResampler.getMaxOutputLength());
        this.remainingSamples = 0;
    }

    public int getLatency(IoDirection ioDirection) {
        return (int)((double)(this.engine.getLatency() + this.rebufferizer.getLatency()) / this.resampleRatio + 0.5);
    }

    public boolean canWriteFasterThanRead() {
        return false;
    }

    public void beginProcessing(IProcessingInfo info) {
        this.engine.beginProcessing(info);
    }

    public void process(float[] input, int length, ISingleChanAudioSink target) {
        this.remainingSamples += length;
        float[] output = this.processImpl(input);
        target.writeSamples(output);
        this.remainingSamples -= output.length;
        if (length < input.length) {
            Arrays.fill(input, 0.0f);
            while (this.remainingSamples > 0) {
                output = this.processImpl(input);
                if (output.length > this.remainingSamples) {
                    float[] tail = new float[this.remainingSamples];
                    System.arraycopy(output, 0, tail, 0, this.remainingSamples);
                    output = tail;
                }
                target.writeSamples(output);
                this.remainingSamples -= output.length;
            }
        }
    }

    private float[] processImpl(float[] input) {
        float[] resampled = this.preResampler.resample(input, false);
        this.rebufferizer.submitVariable(resampled);
        float[] fixed = this.rebufferizer.retrieveFixed();
        while (fixed != null) {
            this.engine.process(fixed, this);
            this.rebufferizer.submitFixed(fixed);
            fixed = this.rebufferizer.retrieveFixed();
        }
        this.rebufferizer.retrieveVariable(resampled);
        return this.postResampler.resample(resampled, false);
    }

    public int getNumSteps() {
        return 1;
    }

    public abstract void process(int var1, int var2, Cmplx[] var3, Cmplx[] var4, int var5, long var6);

    protected final int getNbBins() {
        return this.engine.getNbBins();
    }

    protected final int getNbBins(int res) {
        return this.engine.getNbBins(res);
    }

    protected final int getInputHopSize() {
        return this.specs.getInputHopSize();
    }

    protected final int getDistanceBetweenFrames(int res) {
        return this.engine.getDistanceBetweenFrames(res);
    }

    public void stopProcessing() {
        this.engine.stopProcessing();
        this.preResampler.dispose();
        this.postResampler.dispose();
        this.engine = null;
        this.preResampler = null;
        this.rebufferizer = null;
        this.postResampler = null;
        this.specs = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.engine.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.engine.setSerialSections(pool);
    }
}

