/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.fourier.skip;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.skip.IFourierSkipEngine;
import ch.tachyon.sonics.effect.base.fourier.skip.ISpectrumSkipProcessor;
import ch.tachyon.sonics.effect.base.stft.skip.StftFourierSkipEngine;
import ch.tachyon.tunnel.common.IMultiChanAudioSink;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IMultiChanPushEffect;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.math.Cmplx;

public abstract class FourierSkipEffectBase
extends EffectBase
implements IMultiChanPushEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections,
ISpectrumSkipProcessor {
    private FourierSpec specs;
    private int skipFrames = 1;
    private IFourierSkipEngine engine;

    protected FourierSkipEffectBase() {
    }

    protected abstract FourierSpec getSpecs(IProcessingInfo var1);

    protected void setSkipFrames(int skipFrames) {
        this.skipFrames = skipFrames;
    }

    protected int getNbScales() {
        return this.engine != null ? this.engine.getNbScales() : this.specs.getNbLayers();
    }

    protected final int getNbResolutions() {
        return this.engine.getNbResolutions();
    }

    protected final int getNumHops(int scale) {
        return this.engine.getNumHops(scale);
    }

    protected final int getInputHopSize() {
        return this.engine.getInputHopSize();
    }

    public void startProcessing(IProcessingInfo info) {
        this.specs = this.getSpecs(info);
        this.engine = new StftFourierSkipEngine();
        this.engine.setSpecs(this.specs);
        ((StftFourierSkipEngine)this.engine).setSkipFrames(this.skipFrames);
        this.engine.startProcessing(info);
    }

    public final int getFixedChunkLength() {
        return this.engine.getFixedChunkLength();
    }

    public int getLatency(IoDirection ioDirection) {
        int result = this.engine.getLatency();
        if (ioDirection == IoDirection.INPUT) {
            result = (int)((float)result / this.specs.getTimeScale() + 0.5f);
        }
        return result;
    }

    public void beginProcessing(IProcessingInfo info) {
        this.engine.beginProcessing(info);
    }

    public boolean canWriteFasterThanRead() {
        return true;
    }

    public void process(float[][] input, int length, IMultiChanAudioSink target) {
        float[][] output = this.engine.process(input, this);
        if (length == input[0].length) {
            target.writeSamples(output);
        } else {
            float[][] lastOutput = new float[input.length][(int)((long)length * (long)output[0].length / (long)input[0].length)];
            int chan = 0;
            while (chan < input.length) {
                System.arraycopy(output[chan], 0, lastOutput[chan], 0, lastOutput[chan].length);
                ++chan;
            }
            target.writeSamples(lastOutput);
        }
    }

    public abstract Cmplx[][][] process(int var1, int var2, Cmplx[] var3, Cmplx[][] var4, int var5, long var6);

    public void stopProcessing() {
        this.engine.stopProcessing();
        this.engine = null;
        this.specs = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.engine.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.engine.setSerialSections(pool);
    }
}

