/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft;

import ch.tachyon.sonics.effect.base.stft.StftAnalyzer;
import ch.tachyon.sonics.effect.base.stft.StftBufferArr;
import ch.tachyon.sonics.effect.base.stft.StftSingleCoreBuffer;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import ch.tachyon.tunnel.utils.Debug;
import java.util.Arrays;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

public class StftSynthesizer
implements IHasSerialSections {
    private static final String SECTION_NAME = "ch.tachyon.sonics.stft.synthesizer";
    private final int blockSize;
    private final int hopSize;
    private final int numHops;
    private final int overlap;
    private boolean coherent = true;
    private final float[] analysisWindow;
    private final float[] synthesisWindow;
    private final float synthesisShrink;
    private final boolean energyCorrection;
    private float[] invWindow;
    private BooFFT fft;
    private int numSections;
    private StftBufferArr olaBuffers;
    private StftSingleCoreBuffer singleBuffers;
    private String name;
    protected ISerialSection ss = new DummySerialSection();
    private int skipFrames = 1;
    private int invWindowIndex = 0;

    public StftSynthesizer(int blockSize, int hopSize, int numHops, float[] analysisWindow, float[] synthesisWindow) {
        this(blockSize, hopSize, numHops, analysisWindow, synthesisWindow, 1.0f, false);
    }

    public StftSynthesizer(int blockSize0, int hopSize, int numHops, float[] analysisWindow, float[] synthesisWindow, float synthesisShrink, boolean energyCorrection) {
        int blockSize = AudioMath.getCeilingPowerOf2(blockSize0);
        float wShrink = (float)blockSize / (float)blockSize0;
        this.blockSize = blockSize;
        this.hopSize = hopSize;
        this.numHops = numHops;
        this.overlap = (blockSize + hopSize - 1) / hopSize;
        this.numSections = numHops + this.overlap;
        if (analysisWindow == null) {
            analysisWindow = WindowsFactory.getHannWindow(blockSize);
        }
        if (synthesisWindow == null) {
            synthesisWindow = analysisWindow;
        }
        this.analysisWindow = analysisWindow;
        this.synthesisWindow = synthesisWindow;
        this.synthesisShrink = synthesisShrink * wShrink;
        if (synthesisShrink >= (float)this.overlap) {
            throw new IllegalArgumentException("Cannot shrink more than overlap");
        }
        this.energyCorrection = energyCorrection;
    }

    public int getSkipFrames() {
        return this.skipFrames;
    }

    public void setSkipFrames(int skipFrames) {
        this.skipFrames = skipFrames;
    }

    public boolean isCoherent() {
        return this.coherent;
    }

    public void setCoherent(boolean coherent) {
        this.coherent = coherent;
    }

    public void init() {
        this.init(null);
    }

    public void init(StftAnalyzer analyzer) {
        this.fft = analyzer != null && analyzer.getBlockSize() == this.blockSize ? analyzer.getFFT() : new BooFFT(this.blockSize / 2);
        this.invWindow = new float[this.hopSize * this.skipFrames];
        boolean result = this.coherent ? Windows.fillInverseWindow(this.analysisWindow, this.synthesisWindow, this.invWindow, this.blockSize, this.hopSize * this.skipFrames) : Windows.fillInverseWindowNoise(this.analysisWindow, this.synthesisWindow, this.invWindow, this.blockSize, this.hopSize * this.skipFrames);
        if (!result) {
            Debug.warn("Cannot create inverse window", new Object[0]);
        }
        if (this.singleBuffers == null) {
            this.singleBuffers = new StftSingleCoreBuffer(this.blockSize, this.hopSize, this.numHops);
        }
    }

    public void synthesize(Cmplx[][] spectrums, float[] output) {
        if (output.length != this.hopSize * this.numHops) {
            throw new IllegalArgumentException("Invalid size. Must match hopSize * numHops " + this.hopSize * this.numHops);
        }
        if (this.olaBuffers != null) {
            long clock = this.ss.getClock();
            this.preSynthesize(spectrums, clock);
            this.ss.sync();
            this.renderResult(output, clock);
        } else {
            int hopIndex = 0;
            while (hopIndex < this.numHops) {
                this.preSynthesizeOneCore(this.singleBuffers, spectrums, hopIndex);
                this.renderResultOneCore(this.singleBuffers, output, hopIndex);
                ++hopIndex;
            }
        }
    }

    public void synthesize(Cmplx[][] spectrums, float[] output, StftSingleCoreBuffer buffer) {
        if (output.length != this.hopSize * this.numHops) {
            throw new IllegalArgumentException("Invalid size. Must match hopSize * numHops " + this.hopSize * this.numHops);
        }
        int hopIndex = 0;
        while (hopIndex < this.numHops) {
            this.preSynthesizeOneCore(buffer, spectrums, hopIndex);
            this.renderResultOneCore(buffer, output, hopIndex);
            ++hopIndex;
        }
    }

    public void synthesizeZero(float[] output, StftSingleCoreBuffer buffer) {
        if (output.length != this.hopSize * this.numHops) {
            throw new IllegalArgumentException("Invalid size. Must match hopSize * numHops " + this.hopSize * this.numHops);
        }
        int hopIndex = 0;
        while (hopIndex < this.numHops) {
            Arrays.fill(buffer.processBuffers[hopIndex], 0.0f);
            this.renderResultOneCore(buffer, output, hopIndex);
            ++hopIndex;
        }
    }

    public void preSynthesize(Cmplx[][] spectrums, long clock) {
        int outputIndex;
        int runIndex = outputIndex = (int)(clock * (long)this.numHops % (long)this.numSections);
        int hopIndex = 0;
        while (hopIndex < this.numHops) {
            if (this.olaBuffers == null) {
                this.preSynthesizeOneCore(this.singleBuffers, spectrums, hopIndex);
            } else {
                float[] outputBlock = this.olaBuffers.buffers[runIndex];
                this.backwardFFT(spectrums[hopIndex], outputBlock);
                this.applySynthesisWindow(outputBlock);
                runIndex = (runIndex + 1) % this.numSections;
            }
            ++hopIndex;
        }
    }

    public void renderResult(float[] output, long clock) {
        if (output.length != this.hopSize * this.numHops) {
            throw new IllegalArgumentException("Invalid size. Must match hopSize * numHops " + this.hopSize * this.numHops);
        }
        int outputIndex = (int)(clock * (long)this.numHops % (long)this.numSections);
        int hopIndex = 0;
        while (hopIndex < this.numHops) {
            if (this.olaBuffers == null) {
                this.renderResultOneCore(this.singleBuffers, output, hopIndex);
            } else {
                this.overlapAdd(output, outputIndex, hopIndex);
                outputIndex = (outputIndex + 1) % this.numSections;
            }
            ++hopIndex;
        }
    }

    private void preSynthesizeOneCore(StftSingleCoreBuffer singleBuffers, Cmplx[][] spectrums, int hopIndex) {
        this.backwardFFT(spectrums[hopIndex], singleBuffers.processBuffers[hopIndex]);
        this.applySynthesisWindow(singleBuffers.processBuffers[hopIndex]);
    }

    private void renderResultOneCore(StftSingleCoreBuffer singleBuffers, float[] output, int hopIndex) {
        int i;
        int offset = this.hopSize * hopIndex;
        int olaSize = this.blockSize - this.hopSize;
        int addNumHop = (olaSize - this.hopSize) / this.hopSize;
        int olaIndex = singleBuffers.olaIndex;
        int i2 = 0;
        while (i2 < this.hopSize) {
            output[i2 + offset] = (singleBuffers.olaBuffer[i2 + olaIndex] + singleBuffers.processBuffers[hopIndex][i2]) * this.invWindow[i2 + this.invWindowIndex];
            ++i2;
        }
        int curIndex = olaIndex = (olaIndex + this.hopSize) % olaSize;
        int j = 0;
        int k = 0;
        while (k < addNumHop) {
            i = 0;
            while (i < this.hopSize) {
                int n = i + curIndex;
                singleBuffers.olaBuffer[n] = singleBuffers.olaBuffer[n] + singleBuffers.processBuffers[hopIndex][j + this.hopSize];
                ++j;
                ++i;
            }
            curIndex = (curIndex + this.hopSize) % olaSize;
            ++k;
        }
        curIndex = (olaIndex + olaSize - this.hopSize) % olaSize;
        int base = olaSize - this.hopSize;
        i = 0;
        while (i < this.hopSize) {
            singleBuffers.olaBuffer[i + curIndex] = singleBuffers.processBuffers[hopIndex][i + base + this.hopSize];
            ++i;
        }
        singleBuffers.olaIndex = olaIndex;
        this.invWindowIndex = (this.invWindowIndex + this.hopSize) % this.invWindow.length;
    }

    void renderResultOneCore0(StftSingleCoreBuffer singleBuffers, float[] output, int hopIndex) {
        int offset = this.hopSize * hopIndex;
        int olaSize = this.blockSize - this.hopSize;
        int i = 0;
        while (i < this.hopSize) {
            output[i + offset] = (singleBuffers.olaBuffer[(i + singleBuffers.olaIndex) % olaSize] + singleBuffers.processBuffers[hopIndex][i]) * this.invWindow[i];
            ++i;
        }
        singleBuffers.olaIndex = (singleBuffers.olaIndex + this.hopSize) % olaSize;
        i = 0;
        while (i < olaSize - this.hopSize) {
            int n = (i + singleBuffers.olaIndex) % olaSize;
            singleBuffers.olaBuffer[n] = singleBuffers.olaBuffer[n] + singleBuffers.processBuffers[hopIndex][i + this.hopSize];
            ++i;
        }
        i = olaSize - this.hopSize;
        while (i < olaSize) {
            singleBuffers.olaBuffer[(i + singleBuffers.olaIndex) % olaSize] = singleBuffers.processBuffers[hopIndex][i + this.hopSize];
            ++i;
        }
    }

    protected void backwardFFT(Cmplx[] spectrum, float[] output) {
        this.fft.backC2R(spectrum, output);
    }

    protected void applySynthesisWindow(float[] output) {
        block6: {
            block5: {
                if (!this.energyCorrection || this.synthesisShrink == 1.0f) break block5;
                float energyCorrection = 1.0f;
                float maxCorrection = (float)Math.sqrt(this.synthesisShrink);
                int blockSize = output.length;
                int cellSize = (int)((float)blockSize / this.synthesisShrink + 0.5f);
                int cellStart = (blockSize - cellSize) / 2;
                int cellStop = cellStart + cellSize;
                float cellEnergy = 0.0f;
                float blockEnergy = 0.0f;
                int i = 0;
                while (i < blockSize) {
                    float p = output[i] * output[i];
                    blockEnergy += p;
                    if (i >= cellStart && i < cellStop) {
                        cellEnergy += p;
                    }
                    ++i;
                }
                if (cellEnergy > 0.0f && (energyCorrection = (float)Math.sqrt(blockEnergy / cellEnergy)) > maxCorrection) {
                    energyCorrection = maxCorrection;
                }
                i = 0;
                while (i < output.length) {
                    int n = i;
                    output[n] = output[n] * (this.synthesisWindow[i] * energyCorrection);
                    ++i;
                }
                break block6;
            }
            if (this.synthesisWindow == null) break block6;
            int i = 0;
            while (i < output.length) {
                int n = i;
                output[n] = output[n] * this.synthesisWindow[i];
                ++i;
            }
        }
    }

    private void overlapAdd(float[] output, int outputIndex, int hopIndex) {
        int outputOffset = this.hopSize * hopIndex;
        int shift = this.overlap - 1;
        int bufferIndex = (outputIndex + this.numSections - shift) % this.numSections;
        int bufferOffset = shift * this.hopSize;
        float[] block = this.olaBuffers.buffers[bufferIndex];
        int i = 0;
        while (i < this.hopSize) {
            output[outputOffset + i] = block[bufferOffset + i];
            ++i;
        }
        int k = 1;
        while (k < this.overlap) {
            int shift2 = this.overlap - k - 1;
            int bufferIndex2 = (outputIndex + this.numSections - shift2) % this.numSections;
            int bufferOffset2 = shift2 * this.hopSize;
            float[] block2 = this.olaBuffers.buffers[bufferIndex2];
            int i2 = 0;
            while (i2 < this.hopSize) {
                int n = outputOffset + i2;
                output[n] = output[n] + block2[bufferOffset2 + i2];
                ++i2;
            }
            ++k;
        }
        int i3 = 0;
        while (i3 < this.hopSize) {
            int n = outputOffset + i3;
            output[n] = output[n] * this.invWindow[i3];
            ++i3;
        }
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getHopSize() {
        return this.hopSize;
    }

    public int getNumHops() {
        return this.numHops;
    }

    public int getOutputSize() {
        return this.hopSize * this.numHops;
    }

    public int getLatency() {
        return this.blockSize - this.hopSize;
    }

    public int getSynthesisLatency() {
        return this.blockSize / 2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private String sectionName() {
        if (this.name == null) {
            return SECTION_NAME;
        }
        return "ch.tachyon.sonics.stft.synthesizer " + this.name;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        assert (this.olaBuffers == null);
        if (factory.getMtContext().isMultiCore()) {
            this.numSections = factory.getMtContext().getSerialRunningMaxSkew() * this.numHops + this.overlap;
            this.olaBuffers = new StftBufferArr(this.blockSize, this.numSections, true);
            this.ss = factory.createSerialSection(this.sectionName(), this.olaBuffers);
        } else {
            this.singleBuffers = new StftSingleCoreBuffer(this.blockSize, this.hopSize, this.numHops);
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.numSections = pool.getMtContext().getSerialRunningMaxSkew() * this.numHops + this.overlap;
        this.ss = pool.getSerialSection(this.sectionName());
        if (this.ss != null) {
            this.olaBuffers = (StftBufferArr)this.ss.getUserData();
        }
    }
}

