/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft.old;

import ch.tachyon.sonics.effect.base.stft.old.StftBuffer;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.math.Cmplx;

public class StftAnalyzerOld
implements IHasSerialSections {
    protected final int blockSize;
    protected final int hopSize;
    protected final int olaSize;
    protected StftBuffer inBuffer;
    protected final float[] analysisWindow;
    protected final BooFFT fft;
    protected final Cmplx[] spectrum;
    protected final float[] processBuffer;
    protected ISerialSection ss = new DummySerialSection();

    public StftAnalyzerOld(int blockSize, int hopSize, float[] analysisWindow) {
        this(blockSize, hopSize, analysisWindow, new BooFFT(blockSize / 2), new float[blockSize]);
    }

    protected StftAnalyzerOld(int blockSize, int hopSize, float[] analysisWindow, BooFFT fft, float[] processBuffer) {
        this.blockSize = blockSize;
        this.hopSize = hopSize;
        this.olaSize = blockSize - hopSize;
        int nbBins = blockSize / 2 + 1;
        this.analysisWindow = analysisWindow;
        this.inBuffer = new StftBuffer(blockSize);
        this.fft = fft;
        this.spectrum = Cmplx.newArray(nbBins);
        this.processBuffer = processBuffer;
    }

    public Cmplx[] analyze(float[] input) {
        if (input.length != this.hopSize) {
            throw new IllegalArgumentException("Invalid size. Must match hopSize " + this.hopSize);
        }
        this.split(input);
        this.applyAnalysisWindow();
        this.fft.forwR2C(this.processBuffer, this.spectrum);
        return this.spectrum;
    }

    protected void split(float[] input) {
        this.ss.enterSerialSection();
        try {
            System.arraycopy(input, 0, this.inBuffer.buffer, this.inBuffer.index, input.length);
            this.inBuffer.index = (this.inBuffer.index + this.hopSize) % this.blockSize;
            int i = 0;
            while (i < this.blockSize) {
                this.processBuffer[i] = this.inBuffer.buffer[(i + this.inBuffer.index) % this.blockSize];
                ++i;
            }
        }
        finally {
            this.ss.leaveSerialSection();
        }
    }

    protected void applyAnalysisWindow() {
        int i = 0;
        while (i < this.blockSize) {
            int n = i;
            this.processBuffer[n] = this.processBuffer[n] * this.analysisWindow[i];
            ++i;
        }
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getHopSize() {
        return this.hopSize;
    }

    public int getNbBins() {
        return this.spectrum.length;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.ss = factory.createSerialSection(this.toString(), this.inBuffer);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.ss = pool.getSerialSection(this.toString());
        this.inBuffer = (StftBuffer)this.ss.getUserData();
    }

    public String toString() {
        return this.getClass().getName();
    }
}

