/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft.old;

import ch.tachyon.sonics.effect.base.stft.old.StftAnalyzerOld;
import ch.tachyon.sonics.effect.base.stft.old.StftSynthesizerOld;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.math.Cmplx;

public class StftEngine
implements IHasSerialSections {
    protected final StftAnalyzerOld analyzer;
    protected final StftSynthesizerOld synthesizer;

    public StftEngine(int blockSize, int hopSize, float[] analysisWindow, float[] synthesisWindow) {
        this.analyzer = new StftAnalyzerOld(blockSize, hopSize, analysisWindow);
        this.synthesizer = new StftSynthesizerOld(blockSize, hopSize, analysisWindow, synthesisWindow);
    }

    public Cmplx[] analyze(float[] input) {
        return this.analyzer.analyze(input);
    }

    public void synthesize(Cmplx[] spectrum, float[] output) {
        this.synthesizer.synthesize(spectrum, output);
    }

    public int getBlockSize() {
        return this.analyzer.getBlockSize();
    }

    public int getHopSize() {
        return this.analyzer.getHopSize();
    }

    public int getNbBins() {
        return this.analyzer.getNbBins();
    }

    public int getLatency() {
        return this.synthesizer.getLatency();
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.analyzer.createSerialSections(factory);
        this.synthesizer.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool serialSectionPool) {
        this.analyzer.setSerialSections(serialSectionPool);
        this.synthesizer.setSerialSections(serialSectionPool);
    }
}

