/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft.old;

import ch.tachyon.sonics.effect.base.stft.old.StftBufferOld;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import ch.tachyon.tunnel.utils.Debug;
import java.util.Map;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StftSynthesizerRef
implements IHasSerialSections {
    private static final String SECTION1_NAME = "ch.tachyon.sonics.stft.synthesizer.1";
    private static final String SECTION2_NAME = "ch.tachyon.sonics.stft.synthesizer.2";
    protected final int blockSize;
    protected final int hopSize;
    protected final int olaSize;
    protected final int overlap;
    protected final float[] synthesisWindow;
    protected final float[] invWindow;
    protected final BooFFT fft;
    protected final int numSections;
    protected StftBufferOld olaBuffers;
    protected ISerialSection ss1 = new DummySerialSection();
    protected ISerialSection ss2 = new DummySerialSection();
    protected transient Cmplx[] spectrum;
    protected transient float[] output;
    protected transient int outputIndex;
    protected transient float[] outputBlock;

    public StftSynthesizerRef(IMtContext mtContext, int blockSize, int hopSize, float[] analysisWindow, float[] synthesisWindow) {
        this(mtContext, blockSize, hopSize, analysisWindow, synthesisWindow, new BooFFT(blockSize / 2));
    }

    protected StftSynthesizerRef(IMtContext mtContext, int blockSize, int hopSize, float[] analysisWindow, float[] synthesisWindow, BooFFT fft) {
        this.blockSize = blockSize;
        this.hopSize = hopSize;
        this.olaSize = blockSize - hopSize;
        this.overlap = (blockSize + hopSize - 1) / hopSize;
        this.numSections = this.overlap + mtContext.getSerialRunningMaxSkew();
        this.synthesisWindow = synthesisWindow;
        this.invWindow = new float[hopSize];
        boolean result = Windows.fillInverseWindow(analysisWindow, synthesisWindow, this.invWindow, blockSize, hopSize);
        if (!result) {
            Debug.warn("Cannot create inverse window", new Object[0]);
        }
        this.fft = fft;
        this.olaBuffers = new StftBufferOld(blockSize, this.numSections, true);
    }

    public void synthesize(Cmplx[] spectrum, float[] output) {
        if (output.length != this.hopSize) {
            throw new IllegalArgumentException("Invalid size. Must match hopSize " + this.hopSize);
        }
        this.spectrum = spectrum;
        this.output = output;
        this.ss1.enterSerialSection();
        try {
            this.setupOutputBuffer();
        }
        finally {
            this.ss1.leaveSerialSection();
        }
        this.backwardFFT();
        this.applySynthesisWindow();
        this.ss2.enterSerialSection();
        try {
            this.sync();
        }
        finally {
            this.ss2.leaveSerialSection();
        }
        this.overlapAdd();
    }

    public void setInOut(Cmplx[] spectrum, float[] output) {
        this.spectrum = spectrum;
        this.output = output;
    }

    public void setupOutputBuffer() {
        this.outputBlock = this.olaBuffers.buffers[this.olaBuffers.index];
        this.outputIndex = this.olaBuffers.index;
        this.olaBuffers.index = (this.olaBuffers.index + 1) % this.numSections;
    }

    public void backwardFFT() {
        this.fft.backC2R(this.spectrum, this.outputBlock);
    }

    public void applySynthesisWindow() {
        if (this.synthesisWindow != null) {
            int i = 0;
            while (i < this.outputBlock.length) {
                int n = i;
                this.outputBlock[n] = this.outputBlock[n] * this.synthesisWindow[i];
                ++i;
            }
        }
    }

    public void sync() {
    }

    public void overlapAdd() {
        int shift = this.overlap - 1;
        int bufferIndex = (this.outputIndex + this.numSections - shift) % this.numSections;
        int bufferOffset = shift * this.hopSize;
        float[] block = this.olaBuffers.buffers[bufferIndex];
        int i = 0;
        while (i < this.hopSize) {
            this.output[i] = block[bufferOffset + i];
            ++i;
        }
        int k = 1;
        while (k < this.overlap) {
            int shift2 = this.overlap - k - 1;
            int bufferIndex2 = (this.outputIndex + this.numSections - shift2) % this.numSections;
            int bufferOffset2 = shift2 * this.hopSize;
            float[] block2 = this.olaBuffers.buffers[bufferIndex2];
            int i2 = 0;
            while (i2 < this.hopSize) {
                int n = i2;
                this.output[n] = this.output[n] + block2[bufferOffset2 + i2];
                ++i2;
            }
            ++k;
        }
        int i3 = 0;
        while (i3 < this.hopSize) {
            int n = i3;
            this.output[n] = this.output[n] * this.invWindow[i3];
            ++i3;
        }
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getHopSize() {
        return this.hopSize;
    }

    public int getLatency() {
        return this.blockSize - this.hopSize;
    }

    @Override
    public void createSerialSections(ISerialSectionFactory factory) {
        this.ss1 = factory.createSerialSection(SECTION1_NAME, this.olaBuffers);
        this.ss2 = factory.createSerialSection(SECTION2_NAME, null);
    }

    @Override
    public void setSerialSections(ISerialSectionPool pool) {
        this.ss1 = pool.getSerialSection(SECTION1_NAME);
        this.olaBuffers = (StftBufferOld)this.ss1.getUserData();
        this.ss2 = pool.getSerialSection(SECTION2_NAME);
    }

    public void setupCommonData(Map<String, Object> data) {
        if (data.containsKey(SECTION1_NAME)) {
            this.olaBuffers = (StftBufferOld)data.get(SECTION1_NAME);
        } else {
            data.put(SECTION1_NAME, this.olaBuffers);
        }
    }
}

