/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft.skip;

import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IPostFftProcessor;
import ch.tachyon.sonics.effect.base.fourier.skip.IFourierSkipEngine;
import ch.tachyon.sonics.effect.base.fourier.skip.ISpectrumSkipProcessor;
import ch.tachyon.sonics.effect.base.stft.StftAnalyzer;
import ch.tachyon.sonics.effect.base.stft.StftSynthesizer;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.LinkedList;
import java.util.Queue;
import org.corebounce.common.math.Cmplx;

public class StftFourierSkipEngine
implements IFourierSkipEngine {
    private FourierSpec specs;
    private int nbChans;
    private int skipFrames = 1;
    private StftAnalyzer[] analyzers;
    private Cmplx[][][] chanSpectrums;
    private Cmplx[][][] hopSpectrums;
    private Cmplx[][] sources;
    private Queue<Cmplx[][]> outputSpectrums;
    private StftSynthesizer[] synthesizers;

    public void setSpecs(FourierSpec specs) {
        this.specs = specs;
    }

    public int getSkipFrames() {
        return this.skipFrames;
    }

    public void setSkipFrames(int skipFrames) {
        this.skipFrames = skipFrames;
    }

    public void startProcessing(IProcessingInfo info) {
        int hopSize = this.specs.getInputHopSize();
        int numHops = 1;
        if (this.specs.getMultihop()) {
            int ioSize;
            int chunkLength;
            if (this.specs.getPreferredHopSize() != null) {
                int negotiatedSize;
                chunkLength = this.specs.getPreferredHopSize();
                numHops = chunkLength / hopSize;
                if (numHops < 1) {
                    numHops = 1;
                }
                if ((negotiatedSize = info.negociateFixedChunkLength(ioSize = hopSize * numHops)) % hopSize == 0) {
                    numHops = negotiatedSize / hopSize;
                }
            } else {
                chunkLength = info.getHostPreferredChunkLength();
                if (chunkLength > 0 && (numHops = chunkLength / hopSize) < 1) {
                    numHops = 1;
                }
                ioSize = hopSize * numHops;
                info.negociateFixedChunkLength(ioSize);
            }
        }
        this.nbChans = info.getNumberOfChannels();
        final IPostFftProcessor postFftProcessor = this.specs.getPostFftProcessor();
        this.analyzers = new StftAnalyzer[this.nbChans];
        this.synthesizers = new StftSynthesizer[this.nbChans];
        int chan = 0;
        while (chan < this.nbChans) {
            this.analyzers[chan] = new StftAnalyzer(this.specs.getBaseResolution(), hopSize, numHops, this.specs.getAnalysisWindow(), true);
            this.synthesizers[chan] = new StftSynthesizer(this.specs.getBaseResolution(), this.specs.getOutputHopSize(), numHops, this.specs.getModifiedWindow(), this.specs.getSynthesisWindow(), this.specs.getSynthesisShrink(), true){

                protected void backwardFFT(Cmplx[] spectrum, float[] output) {
                    super.backwardFFT(spectrum, output);
                    if (postFftProcessor != null) {
                        postFftProcessor.postProcess(output);
                    }
                }
            };
            this.synthesizers[chan].setSkipFrames(this.skipFrames);
            ++chan;
        }
        this.chanSpectrums = new Cmplx[this.nbChans][numHops][];
        this.hopSpectrums = new Cmplx[numHops][this.nbChans][];
        this.sources = Cmplx.newArray(numHops, this.getNbBins());
        this.outputSpectrums = new LinkedList<Cmplx[][]>();
    }

    public int getFixedChunkLength() {
        return this.analyzers[0].getInputSize();
    }

    public int getLatency() {
        int result = this.synthesizers[0].getLatency();
        if (this.specs.getFourierLatency() != null) {
            result += this.specs.getFourierLatency().getFourierLatency(this.synthesizers[0].getHopSize(), 0, 0);
        }
        return result += (int)((float)this.synthesizers[0].getBlockSize() / 2.0f * (this.specs.getTimeScale() - 1.0f) + 0.5f);
    }

    public int getNbScales() {
        return 1;
    }

    public int getNbResolutions() {
        return 1;
    }

    public int getNbBins(int layer) {
        return this.getNbBins();
    }

    public int getNbBins() {
        return this.specs.getBaseResolution() / 2 + 1;
    }

    public int getEffectiveResolution(int layer) {
        return this.specs.getBaseResolution();
    }

    public int getNumHops(int scale) {
        return this.analyzers[0].getNumHops();
    }

    public int getInputHopSize() {
        return this.analyzers[0].getInputSize();
    }

    public int getDistanceBetweenFrames(int res) {
        return this.analyzers[0].getHopSize();
    }

    public void beginProcessing(IProcessingInfo info) {
        int chan = 0;
        while (chan < this.analyzers.length) {
            this.analyzers[chan].init();
            this.synthesizers[chan].init(this.analyzers[chan]);
            ++chan;
        }
    }

    public float[][] process(float[][] data, ISpectrumSkipProcessor processor) {
        long clock = this.analyzers[0].getClock();
        int numHops = this.analyzers[0].getNumHops();
        int nbBins = this.getNbBins();
        int chan = 0;
        while (chan < this.nbChans) {
            Cmplx[][] spectrums = this.analyzers[chan].analyze(data[chan]);
            assert (spectrums.length == numHops);
            int k = 0;
            while (k < numHops) {
                this.chanSpectrums[chan][k] = spectrums[k];
                ++k;
            }
            ++chan;
        }
        int k = 0;
        while (k < numHops) {
            int i = 0;
            while (i < nbBins) {
                this.sources[k][i].set(0.0f, 0.0f);
                ++i;
            }
            ++k;
        }
        chan = 0;
        while (chan < this.nbChans) {
            int k2 = 0;
            while (k2 < numHops) {
                int i = 0;
                while (i < nbBins) {
                    this.sources[k2][i].add(this.chanSpectrums[chan][k2][i]);
                    ++i;
                }
                ++k2;
            }
            ++chan;
        }
        k = 0;
        while (k < numHops) {
            int chan2 = 0;
            while (chan2 < this.nbChans) {
                this.hopSpectrums[k][chan2] = this.chanSpectrums[chan2][k];
                ++chan2;
            }
            ++k;
        }
        k = 0;
        while (k < numHops) {
            Cmplx[][][] outputs = processor.process(0, 0, this.sources[k], this.hopSpectrums[k], k, clock * (long)numHops + (long)k);
            int n = 0;
            while (n < outputs.length) {
                this.outputSpectrums.add(outputs[n]);
                ++n;
            }
            ++k;
        }
        int numOutputSteps = this.outputSpectrums.size() / numHops;
        float[][] output = new float[this.nbChans][this.getFixedChunkLength() * numOutputSteps];
        int outputOffset = 0;
        while (this.outputSpectrums.size() >= numHops) {
            int n = 0;
            while (n < numHops) {
                Cmplx[][] outputSpectrum = this.outputSpectrums.remove();
                int chan3 = 0;
                while (chan3 < this.nbChans) {
                    this.hopSpectrums[n][chan3] = outputSpectrum[chan3];
                    ++chan3;
                }
                ++n;
            }
            int chan4 = 0;
            while (chan4 < this.nbChans) {
                int k3 = 0;
                while (k3 < numHops) {
                    this.chanSpectrums[chan4][k3] = this.hopSpectrums[k3][chan4];
                    ++k3;
                }
                ++chan4;
            }
            chan4 = 0;
            while (chan4 < this.nbChans) {
                this.synthesizers[chan4].synthesize(this.chanSpectrums[chan4], data[chan4]);
                System.arraycopy(data[chan4], 0, output[chan4], outputOffset, data[chan4].length);
                ++chan4;
            }
            outputOffset += data[0].length;
        }
        return output;
    }

    public void stopProcessing() {
        this.analyzers = null;
        this.synthesizers = null;
        this.specs = null;
        this.chanSpectrums = null;
        this.hopSpectrums = null;
        this.sources = null;
        this.outputSpectrums = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        int chan = 0;
        while (chan < this.nbChans) {
            this.analyzers[chan].createSerialSections(factory);
            this.synthesizers[chan].createSerialSections(factory);
            ++chan;
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        int chan = 0;
        while (chan < this.nbChans) {
            this.analyzers[chan].setSerialSections(pool);
            this.synthesizers[chan].setSerialSections(pool);
            ++chan;
        }
    }
}

