/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft.stretch;

import ch.tachyon.sonics.effect.base.adaptive.Fork;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.stretch.IFourierStretchEngine;
import ch.tachyon.sonics.effect.base.fourier.stretch.ISpectrumStretchProcessor;
import ch.tachyon.sonics.effect.base.fourier.stretch.StretchOptions;
import ch.tachyon.sonics.effect.base.stft.StftSynthesizer;
import ch.tachyon.sonics.effect.base.stft.stretch.AmDemodEngine;
import ch.tachyon.sonics.effect.base.stft.stretch.StftStretchAnalyzer;
import ch.tachyon.sonics.effect.utils.buffer.DelayArrayBuffer;
import ch.tachyon.sonics.effect.utils.buffer.SmearArrayBuffer;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.BitSet;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.utils.MultiChanAudioSourceFork;

public class StftFourierStretchEngine
implements IFourierStretchEngine {
    private final double stretchRatio;
    private final StretchOptions options;
    private final Fork fork;
    private FourierSpec specs;
    private int nbChans;
    private StftStretchAnalyzer analyzer;
    private Cmplx[][] fullSpectrums;
    private Cmplx[][] tonalSpectrums;
    private Cmplx[][] noiseSpectrums;
    private Cmplx[] source;
    private BitSet incoherentBins;
    private BitSet noSkipBins;
    private StftSynthesizer[] fullSynthesizers;
    private StftSynthesizer[] tonalSynthesizers;
    private StftSynthesizer[] noiseSynthesizers;
    private float[] specialOutput;
    private int skipCounter;
    private int startBin;
    private int stopBin;
    private MultiChanAudioSourceFork sourceFork;
    private AmDemodEngine amDemodEngine;
    private AmDemodEngine ceDemodEngine;
    private SmearArrayBuffer[][] edgeSmearers;
    private DelayArrayBuffer[][] edgeBuffers;

    public StftFourierStretchEngine(double stretchRatio, StretchOptions options, Fork fork) {
        this.stretchRatio = stretchRatio;
        this.options = options;
        this.fork = fork;
    }

    public void setSpecs(FourierSpec specs) {
        this.specs = specs;
    }

    public void startProcessing(IProcessingInfo info) {
        boolean timbreCorrection;
        this.nbChans = info.getNumberOfChannels();
        int nbBins = this.specs.getBaseResolution() / 2 + 1;
        this.startBin = 0;
        this.stopBin = nbBins;
        int blockSize = this.specs.getBaseResolution();
        int outputHopSize = this.specs.getOutputHopSize();
        double inputHopSize = (double)outputHopSize / this.stretchRatio;
        this.analyzer = new StftStretchAnalyzer(this.nbChans, blockSize, inputHopSize, this.specs.getAnalysisWindow());
        this.incoherentBins = new BitSet(nbBins);
        this.noSkipBins = new BitSet(nbBins);
        this.fullSynthesizers = new StftSynthesizer[this.nbChans];
        this.tonalSynthesizers = new StftSynthesizer[this.nbChans];
        this.noiseSynthesizers = new StftSynthesizer[this.nbChans];
        int chan = 0;
        while (chan < this.nbChans) {
            this.fullSynthesizers[chan] = new StftSynthesizer(blockSize, outputHopSize, 1, this.specs.getAnalysisWindow(), this.specs.getSynthesisWindow());
            this.fullSynthesizers[chan].setCoherent(true);
            this.fullSynthesizers[chan].setName("full" + chan);
            this.tonalSynthesizers[chan] = new StftSynthesizer(blockSize, outputHopSize, 1, this.specs.getAnalysisWindow(), this.specs.getSynthesisWindow());
            this.tonalSynthesizers[chan].setSkipFrames(this.options.skipFrames);
            this.tonalSynthesizers[chan].setCoherent(true);
            this.tonalSynthesizers[chan].setName("tonal" + chan);
            this.noiseSynthesizers[chan] = new StftSynthesizer(blockSize, outputHopSize, 1, this.specs.getAnalysisWindow(), this.specs.getSynthesisWindow());
            this.noiseSynthesizers[chan].setSkipFrames(this.options.skipFrames);
            this.noiseSynthesizers[chan].setCoherent(false);
            this.noiseSynthesizers[chan].setName("noise" + chan);
            ++chan;
        }
        this.noiseSpectrums = Cmplx.newArray(this.nbChans, nbBins);
        this.tonalSpectrums = Cmplx.newArray(this.nbChans, nbBins);
        this.source = Cmplx.newArray(this.getNbBins());
        this.specialOutput = new float[outputHopSize];
        int innerLatency = this.fullSynthesizers[0].getLatency();
        innerLatency -= blockSize / 2 - outputHopSize;
        innerLatency += (int)((double)(blockSize / 2 - outputHopSize) * this.stretchRatio + 0.5);
        int ceBlockSize = 4096;
        boolean bl = timbreCorrection = this.options.timbreCorrection > 0.0f && blockSize < 4096;
        if (timbreCorrection) {
            int ceOverlap = this.specs.getIntOverlap();
            this.ceDemodEngine = new AmDemodEngine(this.nbChans, 4096, ceOverlap, outputHopSize, inputHopSize, innerLatency, 4096.0 / (double)blockSize, this.stretchRatio, true, this.options.timbreCorrection);
            innerLatency += this.ceDemodEngine.getLatency();
        }
        if (this.options.demodulate > 0.0f) {
            int shrink = this.options.nbLayers > 1 ? 8 : 1;
            int cstBlockSize = blockSize / shrink;
            int cstOverlap = this.specs.getIntOverlap();
            this.amDemodEngine = new AmDemodEngine(this.nbChans, cstBlockSize, cstOverlap, outputHopSize, inputHopSize, innerLatency, (double)cstBlockSize / (double)blockSize, this.stretchRatio, this.options.fullCorrection || timbreCorrection, this.options.demodulate);
            if (this.options.nbLayers > 1) {
                int nbKnife = this.fork.getNbKnifes();
                this.edgeSmearers = new SmearArrayBuffer[nbKnife][this.nbChans];
                this.edgeBuffers = new DelayArrayBuffer[nbKnife][this.nbChans];
                int k = 0;
                while (k < nbKnife) {
                    int chan2 = 0;
                    while (chan2 < this.nbChans) {
                        int Smear = 38;
                        this.edgeSmearers[k][chan2] = new SmearArrayBuffer(38, this.fork.getNbBins(k));
                        this.edgeBuffers[k][chan2] = new DelayArrayBuffer(4, this.fork.getNbBins(k));
                        ++chan2;
                    }
                    ++k;
                }
            }
        }
    }

    public int getFixedChunkLength() {
        return this.specs.getOutputHopSize();
    }

    public int getNbScales() {
        return 1;
    }

    public int getNbResolutions() {
        return 1;
    }

    public int getNbBins() {
        return this.specs.getBaseResolution() / 2 + 1;
    }

    public int getNbBins(int res) {
        return this.getNbBins();
    }

    public int getNumHops(int scale) {
        return 1;
    }

    public int getAmDemodHopSize(int resolution) {
        if (this.amDemodEngine == null) {
            return 1;
        }
        return this.amDemodEngine.getHopSize();
    }

    private int getLatencyWithoutDemods() {
        int result = this.fullSynthesizers[0].getLatency();
        if (this.specs.getFourierLatency() != null) {
            result += this.specs.getFourierLatency().getFourierLatency(this.fullSynthesizers[0].getHopSize(), 0, 0);
        }
        return result += (int)((double)((float)this.fullSynthesizers[0].getBlockSize() / 2.0f) * (this.stretchRatio - 1.0) + 0.5);
    }

    public int getLatency() {
        int result = this.getLatencyWithoutDemods();
        if (this.ceDemodEngine != null) {
            result += this.ceDemodEngine.getLatency();
        }
        if (this.amDemodEngine != null) {
            result += this.amDemodEngine.getLatency();
        }
        return result;
    }

    public void beginProcessing(IProcessingInfo info) {
        int chan = 0;
        while (chan < this.nbChans) {
            this.fullSynthesizers[chan].init();
            this.tonalSynthesizers[chan].init();
            this.noiseSynthesizers[chan].init();
            ++chan;
        }
        if (this.ceDemodEngine != null) {
            this.ceDemodEngine.init(info);
        }
        if (this.amDemodEngine != null) {
            this.amDemodEngine.init(info);
        }
    }

    public void setProcessingRange(int startBin, int stopBin) {
        this.startBin = startBin;
        this.stopBin = stopBin;
    }

    public int process(IMultiChanAudioSource mcSource, float[][][][] edgeRatios, ISpectrumStretchProcessor processor, float[][] output) {
        int curHopSize;
        int nbInputSamples;
        int nbBins = this.getNbBins();
        if (this.sourceFork == null) {
            int nbSources = 1;
            if (this.ceDemodEngine != null) {
                ++nbSources;
            }
            if (this.amDemodEngine != null) {
                ++nbSources;
            }
            this.sourceFork = new MultiChanAudioSourceFork(mcSource, nbSources, this.nbChans);
        }
        int sourceNum = 0;
        this.fullSpectrums = this.analyzer.analyze(this.sourceFork.getSource(sourceNum++));
        if (this.ceDemodEngine != null) {
            this.ceDemodEngine.analyse(this.sourceFork.getSource(sourceNum++), null);
        }
        if (this.amDemodEngine != null) {
            this.amDemodEngine.analyse(this.sourceFork.getSource(sourceNum++), null);
        }
        int i = 0;
        while (i < nbBins) {
            this.source[i].set(this.fullSpectrums[0][i]);
            ++i;
        }
        int chan = 1;
        while (chan < this.nbChans) {
            int i2 = 0;
            while (i2 < nbBins) {
                this.source[i2].add(this.fullSpectrums[chan][i2]);
                ++i2;
            }
            ++chan;
        }
        processor.process(0, this.source, this.fullSpectrums, this.incoherentBins, this.noSkipBins);
        chan = 0;
        while (chan < this.nbChans) {
            Cmplx[] fullSpectrum = this.fullSpectrums[chan];
            Cmplx[] tonalSpectrum = this.tonalSpectrums[chan];
            Cmplx[] noiseSpectrum = this.noiseSpectrums[chan];
            int i3 = 0;
            while (i3 < nbBins) {
                if (this.noSkipBins.get(i3)) {
                    tonalSpectrum[i3].set(0.0f, 0.0f);
                    noiseSpectrum[i3].set(0.0f, 0.0f);
                    if (this.incoherentBins.get(i3)) {
                        fullSpectrum[i3].mul(this.options.noiseBoost);
                    }
                } else if (this.incoherentBins.get(i3)) {
                    noiseSpectrum[i3].set(fullSpectrum[i3]);
                    tonalSpectrum[i3].set(0.0f, 0.0f);
                    fullSpectrum[i3].set(0.0f, 0.0f);
                } else {
                    tonalSpectrum[i3].set(fullSpectrum[i3]);
                    noiseSpectrum[i3].set(0.0f, 0.0f);
                    fullSpectrum[i3].set(0.0f, 0.0f);
                }
                ++i3;
            }
            if (this.skipCounter != 0) {
                i3 = 0;
                while (i3 < nbBins) {
                    tonalSpectrum[i3].set(0.0f, 0.0f);
                    noiseSpectrum[i3].set(0.0f, 0.0f);
                    ++i3;
                }
            }
            ++chan;
        }
        chan = 0;
        while (chan < this.nbChans) {
            this.fullSynthesizers[chan].synthesize(new Cmplx[][]{this.fullSpectrums[chan]}, output[chan]);
            this.tonalSynthesizers[chan].synthesize(new Cmplx[][]{this.tonalSpectrums[chan]}, this.specialOutput);
            int i4 = 0;
            while (i4 < this.specialOutput.length) {
                float[] fArray = output[chan];
                int n = i4;
                fArray[n] = fArray[n] + this.specialOutput[i4];
                ++i4;
            }
            this.noiseSynthesizers[chan].synthesize(new Cmplx[][]{this.noiseSpectrums[chan]}, this.specialOutput);
            i4 = 0;
            while (i4 < this.specialOutput.length) {
                float[] fArray = output[chan];
                int n = i4;
                fArray[n] = fArray[n] + this.specialOutput[i4];
                ++i4;
            }
            ++chan;
        }
        this.skipCounter = (this.skipCounter + 1) % this.options.skipFrames;
        if (this.ceDemodEngine != null) {
            this.ceDemodEngine.demodulate(output, this.startBin, this.stopBin, this.noSkipBins, null);
        }
        if (this.amDemodEngine != null) {
            if (edgeRatios != null) {
                int knifeIndex = 0;
                while (knifeIndex < edgeRatios.length) {
                    float[][][] knife0Ratios = edgeRatios[knifeIndex];
                    int chan2 = 0;
                    while (chan2 < this.nbChans) {
                        int numHops = knife0Ratios[chan2].length;
                        int k = 0;
                        while (k < numHops) {
                            this.edgeSmearers[knifeIndex][chan2].push(knife0Ratios[chan2][k]);
                            this.edgeBuffers[knifeIndex][chan2].push(knife0Ratios[chan2][k]);
                            ++k;
                        }
                        ++chan2;
                    }
                    ++knifeIndex;
                }
            }
            this.amDemodEngine.demodulate(output, this.startBin, this.stopBin, this.noSkipBins, edgeRatios != null ? edgeRatios[1] : null);
        }
        if ((nbInputSamples = this.analyzer.getCurSamplesRead()) == (curHopSize = this.analyzer.getCurrentHopSize())) {
            return output[0].length;
        }
        return Math.min(output[0].length, (int)((double)nbInputSamples * this.stretchRatio + 0.5));
    }

    public int getCurrentInputHopSize() {
        return this.analyzer.getCurrentHopSize();
    }

    public void stopProcessing() {
        this.analyzer = null;
        this.fullSynthesizers = null;
        this.tonalSynthesizers = null;
        this.noiseSynthesizers = null;
        this.ceDemodEngine = null;
        this.amDemodEngine = null;
        this.specs = null;
        this.fullSpectrums = null;
        this.tonalSpectrums = null;
        this.noiseSpectrums = null;
        this.source = null;
        this.specialOutput = null;
        this.incoherentBins = null;
        this.noSkipBins = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        int chan = 0;
        while (chan < this.nbChans) {
            this.fullSynthesizers[chan].createSerialSections(factory);
            this.tonalSynthesizers[chan].createSerialSections(factory);
            this.noiseSynthesizers[chan].createSerialSections(factory);
            ++chan;
        }
        if (this.ceDemodEngine != null) {
            this.ceDemodEngine.createSerialSections(factory);
        }
        if (this.amDemodEngine != null) {
            this.amDemodEngine.createSerialSections(factory);
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        int chan = 0;
        while (chan < this.nbChans) {
            this.fullSynthesizers[chan].setSerialSections(pool);
            this.tonalSynthesizers[chan].setSerialSections(pool);
            this.noiseSynthesizers[chan].setSerialSections(pool);
            ++chan;
        }
        if (this.ceDemodEngine != null) {
            this.ceDemodEngine.setSerialSections(pool);
        }
        if (this.amDemodEngine != null) {
            this.amDemodEngine.setSerialSections(pool);
        }
    }
}

