/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft.stretch;

import ch.tachyon.sonics.effect.base.stft.old.StftBuffer;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.math.Cmplx;

public class StftStretchAnalyzer {
    private final int nbChans;
    private final int blockSize;
    private final double hopSize;
    private final StftBuffer[] inBuffers;
    private final float[] analysisWindow;
    private final BooFFT fft;
    private final Cmplx[][] spectrums;
    private final float[] processBuffer;
    private double curSkew = 0.5;
    private int curHopSize;
    private int curSamplesRead;

    public StftStretchAnalyzer(int nbChans, int blockSize, double hopSize, float[] analysisWindow) {
        this.nbChans = nbChans;
        this.blockSize = blockSize;
        this.hopSize = hopSize;
        int nbBins = blockSize / 2 + 1;
        this.analysisWindow = analysisWindow;
        this.inBuffers = new StftBuffer[nbChans];
        int chan = 0;
        while (chan < nbChans) {
            this.inBuffers[chan] = new StftBuffer(blockSize);
            ++chan;
        }
        this.fft = new BooFFT(blockSize / 2);
        this.spectrums = Cmplx.newArray(nbChans, nbBins);
        this.processBuffer = new float[blockSize];
    }

    public Cmplx[][] analyze(IMultiChanAudioSource source) {
        StftBuffer inBuffer;
        this.curHopSize = (int)(this.hopSize + this.curSkew);
        this.curSkew += this.hopSize - (double)this.curHopSize;
        float[][] hopBuffers = new float[this.nbChans][this.curHopSize];
        this.curSamplesRead = source.readSamples(hopBuffers);
        int chan = 0;
        while (chan < this.nbChans) {
            inBuffer = this.inBuffers[chan];
            float[] hopBuffer = hopBuffers[chan];
            int i = 0;
            while (i < this.curHopSize) {
                inBuffer.buffer[(i + inBuffer.index) % this.blockSize] = hopBuffer[i];
                ++i;
            }
            inBuffer.index = (inBuffer.index + this.curHopSize) % this.blockSize;
            ++chan;
        }
        chan = 0;
        while (chan < this.nbChans) {
            inBuffer = this.inBuffers[chan];
            int i = 0;
            while (i < this.blockSize) {
                this.processBuffer[i] = inBuffer.buffer[(i + inBuffer.index) % this.blockSize] * this.analysisWindow[i];
                ++i;
            }
            this.fft.forwR2C(this.processBuffer, this.spectrums[chan]);
            ++chan;
        }
        return this.spectrums;
    }

    public int getNbChans() {
        return this.nbChans;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public double getHopSize() {
        return this.hopSize;
    }

    public int getCurrentHopSize() {
        return this.curHopSize;
    }

    public int getCurSamplesRead() {
        return this.curSamplesRead;
    }

    public int getNbBins() {
        return this.spectrums[0].length;
    }

    public int getSrcOutputAnalysisLatency(int outputHopSize) {
        return this.blockSize / 2 - outputHopSize;
    }

    public static int getSrcOutputAnalysisLatency(int blockSize, int outputHopSize) {
        return blockSize / 2 - outputHopSize;
    }

    public static int getLatencySkew(int overlap1, int hopSize1, int overlap2, int hopSize2, float stretchRatio) {
        return (int)((float)(hopSize1 - hopSize2) * (stretchRatio - 1.0f) + 0.5f);
    }
}

