/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.pitchtime.bv;

import ch.tachyon.sonics.effect.base.adaptive.Fork;
import ch.tachyon.sonics.effect.utils.buffer.DelayBuffer;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import javax.sound.sampled.AudioFormat;

public class ForkSourceSplitter {
    private final Fork fork;
    private final DelayBuffer[] delayers;
    private final IMultiChanAudioSource source;
    private final int nbReaders;
    private final int nbChans;
    private final IMultiChanAudioSource[] forkedSources;
    private final float[][] input;
    private float[][][] buffers;
    private int capacity;
    private int size;
    private int[] indexes;

    public ForkSourceSplitter(Fork fork, IMultiChanAudioSource source, int nbChans) {
        this.fork = fork;
        this.delayers = new DelayBuffer[nbChans];
        int chan = 0;
        while (chan < nbChans) {
            this.delayers[chan] = new DelayBuffer(fork.getLatency());
            ++chan;
        }
        this.source = source;
        this.nbReaders = fork.getNbLayers() + 1;
        this.nbChans = nbChans;
        this.forkedSources = new ForkedSource[this.nbReaders];
        int reader = 0;
        while (reader < this.nbReaders) {
            this.forkedSources[reader] = new ForkedSource(reader);
            ++reader;
        }
        this.input = new float[nbChans][fork.getInputSize()];
        this.buffers = new float[this.nbReaders][nbChans][0];
        this.capacity = 0;
        this.size = 0;
        this.indexes = new int[this.nbReaders];
    }

    public IMultiChanAudioSource getOriginalSource() {
        return this.forkedSources[0];
    }

    public IMultiChanAudioSource getForkedSource(int res) {
        return this.forkedSources[res + 1];
    }

    int readSamples(int readerNum, float[][] output) {
        float[][][] toAdd;
        int read;
        int amount = output[0].length;
        if (this.indexes[readerNum] + amount > this.size) {
            int minIndex = this.capacity;
            int i = 0;
            while (i < this.nbReaders) {
                if (this.indexes[i] < minIndex) {
                    minIndex = this.indexes[i];
                }
                ++i;
            }
            if (minIndex > 0) {
                int reader = 0;
                while (reader < this.nbReaders) {
                    if (minIndex < this.size) {
                        int chan = 0;
                        while (chan < this.nbChans) {
                            System.arraycopy(this.buffers[reader][chan], minIndex, this.buffers[reader][chan], 0, this.size - minIndex);
                            ++chan;
                        }
                    }
                    int n = reader++;
                    this.indexes[n] = this.indexes[n] - minIndex;
                }
                this.size -= minIndex;
            }
        }
        int hopSize = this.fork.getInputSize();
        int toRead = 0;
        if (this.indexes[readerNum] + amount > this.size) {
            toRead = this.indexes[readerNum] + amount - this.size;
            toRead = (toRead + hopSize - 1) / hopSize * hopSize;
        }
        if (this.size + toRead > this.capacity) {
            float[][][] toAdd2 = new float[this.nbReaders][this.nbChans][toRead];
            read = this.readAndProcessFromSource(toRead, toAdd2);
            if (read > 0) {
                float[][][] newBuffers = new float[this.nbReaders][this.nbChans][this.size + read];
                int reader = 0;
                while (reader < this.nbReaders) {
                    int chan = 0;
                    while (chan < this.nbChans) {
                        System.arraycopy(this.buffers[reader][chan], 0, newBuffers[reader][chan], 0, this.size);
                        System.arraycopy(toAdd2[reader][chan], 0, newBuffers[reader][chan], this.size, read);
                        ++chan;
                    }
                    ++reader;
                }
                this.buffers = newBuffers;
                this.capacity = newBuffers[0][0].length;
                this.size += read;
            }
        } else if (this.indexes[readerNum] + amount > this.size && (read = this.readAndProcessFromSource(toRead, toAdd = new float[this.nbReaders][this.nbChans][toRead])) > 0) {
            int reader = 0;
            while (reader < this.nbReaders) {
                int chan = 0;
                while (chan < this.nbChans) {
                    System.arraycopy(toAdd[reader][chan], 0, this.buffers[reader][chan], this.size, read);
                    ++chan;
                }
                ++reader;
            }
            this.size += read;
        }
        if (this.indexes[readerNum] + amount > this.size) {
            amount = this.size - this.indexes[readerNum];
        }
        int chan = 0;
        while (chan < this.nbChans) {
            System.arraycopy(this.buffers[readerNum][chan], this.indexes[readerNum], output[chan], 0, amount);
            ++chan;
        }
        int n = readerNum;
        this.indexes[n] = this.indexes[n] + amount;
        return amount;
    }

    private int readAndProcessFromSource(int toRead, float[][][] target) {
        int read = 0;
        int hopSize = this.fork.getInputSize();
        assert (toRead % hopSize == 0);
        assert (toRead == target[0][0].length);
        int k = 0;
        while (k < toRead) {
            read += this.source.readSamples(this.input);
            this.fork.process(this.input);
            int chan = 0;
            while (chan < this.nbChans) {
                this.delayers[chan].pushArray(this.input[chan]);
                ++chan;
            }
            int reader = 0;
            while (reader < this.nbReaders - 1) {
                int chan2 = 0;
                while (chan2 < this.nbChans) {
                    float[] forked = this.fork.getOutput(reader, chan2);
                    System.arraycopy(forked, 0, target[reader + 1][chan2], k, hopSize);
                    ++chan2;
                }
                ++reader;
            }
            chan = 0;
            while (chan < this.nbChans) {
                System.arraycopy(this.input[chan], 0, target[0][chan], k, hopSize);
                ++chan;
            }
            k += hopSize;
        }
        return read;
    }

    class ForkedSource
    implements IMultiChanAudioSource {
        private final int readerNum;

        public ForkedSource(int readerNum) {
            this.readerNum = readerNum;
        }

        public AudioFormat getAudioFormat() {
            return ForkSourceSplitter.this.source.getAudioFormat();
        }

        public int readSamples(float[][] target) {
            return ForkSourceSplitter.this.readSamples(this.readerNum, target);
        }
    }
}

