/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.pitchtime.bv;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.adaptive.Fork;
import ch.tachyon.sonics.effect.base.adaptive.SharpInfo;
import ch.tachyon.sonics.effect.base.fourier.FourierProcessingType;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.stretch.StretchOptions;
import ch.tachyon.sonics.effect.pitchtime.bv.ForkSourceSplitter;
import ch.tachyon.sonics.effect.pitchtime.bv.IFourierEngine;
import ch.tachyon.sonics.effect.pitchtime.bv.ISpectrumProcessor;
import ch.tachyon.sonics.effect.pitchtime.bv.PyramidEngine;
import ch.tachyon.sonics.effect.pitchtime.bv.SingleResEngine;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IMultiChanPullEffect;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.BitSet;
import org.corebounce.common.math.Cmplx;

public abstract class FourierEffectBase
extends EffectBase
implements IMultiChanPullEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections,
ISpectrumProcessor {
    private FourierSpec specs;
    private StretchOptions options;
    private int nbChans;
    private double stretchRatio;
    private Fork fork;
    private ForkSourceSplitter forkSourceSplitter;
    private IFourierEngine engine;

    protected abstract FourierSpec getSpecs(IProcessingInfo var1);

    protected abstract double getStretchRatio(IProcessingInfo var1);

    protected StretchOptions getOptions() {
        return this.options;
    }

    protected void setOptions(StretchOptions options) {
        this.options = options;
    }

    protected int getNbScales() {
        return this.engine != null ? this.engine.getNbScales() : this.specs.getNbScales();
    }

    protected final int getNbResolutions() {
        return this.engine.getNbResolutions();
    }

    protected int getNbChans() {
        return this.nbChans;
    }

    protected final int getCurrentInputHopSize() {
        return this.engine.getCurrentInputHopSize();
    }

    public void startProcessing(IProcessingInfo info) {
        this.specs = this.getSpecs(info);
        this.stretchRatio = this.getStretchRatio(info);
        this.nbChans = info.getNumberOfChannels();
        int blockSize = this.specs.getBaseResolution();
        int overlap = this.specs.getIntOverlap();
        SharpInfo sharpInfo = new SharpInfo(blockSize, 3, 4.0f, blockSize, (float)overlap, info.getSampleRate());
        this.fork = new Fork(this.nbChans, sharpInfo);
        if (this.specs.getProcessingType() == FourierProcessingType.SIMPLE) {
            this.engine = new SingleResEngine(this.stretchRatio, this.options, -1);
        } else if (this.specs.getProcessingType() == FourierProcessingType.PYRAMIDAL) {
            this.engine = new PyramidEngine(this.stretchRatio, this.options);
        }
        this.engine.setSpecs(this.specs);
        this.engine.startProcessing(info);
    }

    public final int getFixedChunkLength() {
        return this.engine.getFixedChunkLength();
    }

    public int getLatency(IoDirection ioDirection) {
        int result = this.engine.getLatency();
        if (this.fork != null) {
            result += this.fork.getLatency();
        }
        if (ioDirection == IoDirection.INPUT) {
            result = (int)((double)result / this.stretchRatio + 0.5);
        }
        return result;
    }

    public void beginProcessing(IProcessingInfo info) {
        this.engine.beginProcessing(info);
        if (this.fork != null) {
            this.fork.init();
        }
    }

    public boolean canWriteFasterThanRead() {
        return this.stretchRatio > 1.0;
    }

    public int process(IMultiChanAudioSource source, float[][] output) {
        if (this.forkSourceSplitter == null) {
            this.forkSourceSplitter = new ForkSourceSplitter(this.fork, source, this.nbChans);
        }
        IMultiChanAudioSource[] forkedSources = new IMultiChanAudioSource[this.fork.getNbLayers()];
        int res = 0;
        while (res < this.fork.getNbLayers()) {
            forkedSources[res] = this.forkSourceSplitter.getForkedSource(res);
            ++res;
        }
        IMultiChanAudioSource originalSource = this.forkSourceSplitter.getOriginalSource();
        return this.engine.process(originalSource, forkedSources, this, output);
    }

    public abstract void process(int var1, Cmplx[] var2, Cmplx[][] var3, BitSet var4, BitSet var5);

    public void stopProcessing() {
        this.engine.stopProcessing();
        this.engine = null;
        this.forkSourceSplitter = null;
        this.fork = null;
        this.specs = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.engine.createSerialSections(factory);
        if (this.fork != null) {
            this.fork.createSerialSections(factory);
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.engine.setSerialSections(pool);
        if (this.fork != null) {
            this.fork.setSerialSections(pool);
        }
    }
}

