/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.pitchtime.bv;

import ch.tachyon.sonics.effect.utils.buffer.DelayBuffer;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import javax.sound.sampled.AudioFormat;

public class MultiChanDelayedSource
implements IMultiChanAudioSource {
    private final IMultiChanAudioSource target;
    private final DelayBuffer[] buffers;

    public MultiChanDelayedSource(IMultiChanAudioSource target, int nbChans, int delay) {
        this.target = target;
        this.buffers = new DelayBuffer[nbChans];
        int chan = 0;
        while (chan < nbChans) {
            this.buffers[chan] = new DelayBuffer(delay);
            ++chan;
        }
    }

    public AudioFormat getAudioFormat() {
        return this.target.getAudioFormat();
    }

    public int readSamples(float[][] output) {
        int result = this.target.readSamples(output);
        int chan = 0;
        while (chan < output.length) {
            this.buffers[chan].pushArray(output[chan]);
            ++chan;
        }
        return result;
    }
}

