/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.pitchtime.bv;

import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.stretch.StretchOptions;
import ch.tachyon.sonics.effect.pitchtime.bv.IFourierEngine;
import ch.tachyon.sonics.effect.pitchtime.bv.ISpectrumProcessor;
import ch.tachyon.sonics.effect.pitchtime.bv.SingleResEngine;
import ch.tachyon.sonics.effect.utils.buffer.DelayBuffer;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.Arrays;
import java.util.BitSet;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.utils.MultiChanAudioSourceFork;

public class PyramidEngine
implements IFourierEngine,
ISpectrumProcessor {
    private final double stretchRatio;
    private final StretchOptions options;
    private FourierSpec specs;
    private int nbChans;
    private int nbResolutions;
    private float sampleRate;
    private float[] splitFreqs;
    private int[] startBins;
    private int[] stopBins;
    private MultiChanAudioSourceFork sourceFork;
    private MultiChanAudioSourceFork[] targetForks;
    private SingleResEngine[] engines;
    private float[][][] resOutputs;
    private DelayBuffer[][] delayers;
    transient ISpectrumProcessor currentProcessor;
    transient int currentRes;

    public PyramidEngine(double stretchRatio, StretchOptions options) {
        this.stretchRatio = stretchRatio;
        this.options = options;
    }

    public void setSpecs(FourierSpec specs) {
        this.specs = specs;
    }

    public void startProcessing(IProcessingInfo info) {
        this.nbChans = info.getNumberOfChannels();
        int[] resolutions = this.specs.getPyramidResolutions();
        this.nbResolutions = resolutions.length;
        this.sampleRate = info.getSampleRate();
        this.splitFreqs = this.specs.getSplitFreqs();
        this.startBins = new int[this.nbResolutions];
        this.stopBins = new int[this.nbResolutions];
        int res = 0;
        while (res < this.nbResolutions) {
            int fftSize = resolutions[res];
            int startBin = 0;
            int stopBin = fftSize / 2 + 1;
            if (res > 0) {
                startBin = AudioMath.freq2bin(fftSize, this.splitFreqs[res - 1], this.sampleRate, 0);
            }
            if (res < this.nbResolutions - 1) {
                stopBin = AudioMath.freq2bin(fftSize, this.splitFreqs[res], this.sampleRate, 0);
            }
            this.startBins[res] = startBin;
            this.stopBins[res] = stopBin;
            ++res;
        }
        this.engines = new SingleResEngine[this.nbResolutions];
        res = 0;
        while (res < this.nbResolutions) {
            this.engines[res] = new SingleResEngine(this.stretchRatio, this.options, res);
            FourierSpec resSpecs = new FourierSpec(resolutions[res], (int)this.specs.getOverlap());
            this.engines[res].setSpecs(resSpecs);
            this.engines[res].startProcessing(info);
            ++res;
        }
        this.resOutputs = new float[this.nbResolutions][][];
        res = 0;
        while (res < this.nbResolutions) {
            int blockSize = this.engines[res].getFixedChunkLength();
            this.resOutputs[res] = new float[this.nbChans][blockSize];
            ++res;
        }
        int maxLatency = 0;
        int res2 = 0;
        while (res2 < this.nbResolutions) {
            if (this.engines[res2].getLatency() > maxLatency) {
                maxLatency = this.engines[res2].getLatency();
            }
            ++res2;
        }
        this.delayers = new DelayBuffer[this.nbResolutions][];
        res2 = 0;
        while (res2 < this.nbResolutions) {
            int latency = this.engines[res2].getLatency();
            if (latency < maxLatency) {
                this.delayers[res2] = new DelayBuffer[this.nbChans];
                int delay = maxLatency - latency;
                int chan = 0;
                while (chan < this.nbChans) {
                    this.delayers[res2][chan] = new DelayBuffer(delay);
                    ++chan;
                }
            }
            ++res2;
        }
    }

    public int getFixedChunkLength() {
        return this.engines[0].getFixedChunkLength();
    }

    public int getLatency() {
        int result = this.engines[0].getLatency();
        if (this.delayers[0] != null) {
            result += this.delayers[0][0].getSize();
        }
        return result;
    }

    public int getNbScales() {
        return this.nbResolutions;
    }

    public int getNbResolutions() {
        return this.nbResolutions;
    }

    public int getNbBins() {
        return -1;
    }

    public int getNbBins(int res) {
        return this.engines[res].getNbBins();
    }

    public int getNumHops(int scale) {
        return 1;
    }

    public int getAmDemodHopSize(int resolution) {
        return this.engines[resolution].getAmDemodHopSize(0);
    }

    public void beginProcessing(IProcessingInfo info) {
        SingleResEngine[] singleResEngineArray = this.engines;
        int n = this.engines.length;
        int n2 = 0;
        while (n2 < n) {
            SingleResEngine engine = singleResEngineArray[n2];
            engine.beginProcessing(info);
            ++n2;
        }
    }

    public int process(IMultiChanAudioSource source, IMultiChanAudioSource[] targets, ISpectrumProcessor processor, float[][] output) {
        if (this.sourceFork == null) {
            this.sourceFork = new MultiChanAudioSourceFork(source, this.nbResolutions, this.nbChans);
        }
        int nbTargets = targets.length;
        if (this.targetForks == null) {
            this.targetForks = new MultiChanAudioSourceFork[nbTargets];
            int i = 0;
            while (i < nbTargets) {
                this.targetForks[i] = new MultiChanAudioSourceFork(targets[i], this.nbResolutions, this.nbChans);
                ++i;
            }
        }
        int chan = 0;
        while (chan < this.nbChans) {
            Arrays.fill(output[chan], 0.0f);
            ++chan;
        }
        int result = 0;
        int res = 0;
        while (res < this.nbResolutions) {
            this.currentProcessor = processor;
            this.currentRes = res;
            int blockSize = this.resOutputs[res][0].length;
            assert (output[0].length % blockSize == 0);
            int numHops = output[0].length / blockSize;
            int offset = 0;
            int resResult = 0;
            IMultiChanAudioSource[] resTargets = new IMultiChanAudioSource[nbTargets];
            int i = 0;
            while (i < nbTargets) {
                resTargets[i] = this.targetForks[i].getSource(res);
                ++i;
            }
            int k = 0;
            while (k < numHops) {
                int chan2;
                this.engines[res].setProcessingRange(this.startBins[res], this.stopBins[res]);
                resResult += this.engines[res].process(this.sourceFork.getSource(res), resTargets, this, this.resOutputs[res]);
                if (this.delayers[res] != null) {
                    chan2 = 0;
                    while (chan2 < this.nbChans) {
                        this.delayers[res][chan2].pushArray(this.resOutputs[res][chan2]);
                        ++chan2;
                    }
                }
                chan2 = 0;
                while (chan2 < this.nbChans) {
                    int i2 = 0;
                    while (i2 < blockSize) {
                        float[] fArray = output[chan2];
                        int n = i2 + offset;
                        fArray[n] = fArray[n] + this.resOutputs[res][chan2][i2];
                        ++i2;
                    }
                    ++chan2;
                }
                offset += blockSize;
                ++k;
            }
            result = Math.max(result, resResult);
            ++res;
        }
        return result;
    }

    public void process(int scale, Cmplx[] source, Cmplx[][] spectrums, BitSet incoherent, BitSet noSkipFrames) {
        assert (scale == 0);
        scale = this.currentRes;
        this.currentProcessor.process(this.currentRes, source, spectrums, incoherent, noSkipFrames);
        int nbBins = source.length;
        int nbTracks = spectrums.length;
        int track = 0;
        while (track < nbTracks) {
            int i = 0;
            while (i < this.startBins[this.currentRes]) {
                spectrums[track][i].clear();
                ++i;
            }
            i = this.stopBins[this.currentRes];
            while (i < nbBins) {
                spectrums[track][i].clear();
                ++i;
            }
            ++track;
        }
    }

    public void stopProcessing() {
        this.sourceFork = null;
        this.engines = null;
        this.resOutputs = null;
        this.delayers = null;
    }

    public int getCurrentInputHopSize() {
        return this.engines[this.currentRes].getCurrentInputHopSize();
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        SingleResEngine[] singleResEngineArray = this.engines;
        int n = this.engines.length;
        int n2 = 0;
        while (n2 < n) {
            SingleResEngine engine = singleResEngineArray[n2];
            engine.createSerialSections(factory);
            ++n2;
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        SingleResEngine[] singleResEngineArray = this.engines;
        int n = this.engines.length;
        int n2 = 0;
        while (n2 < n) {
            SingleResEngine engine = singleResEngineArray[n2];
            engine.setSerialSections(pool);
            ++n2;
        }
    }
}

