/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.pitchtime.bv;

import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.stretch.StretchOptions;
import ch.tachyon.sonics.effect.base.stft.StftSynthesizer;
import ch.tachyon.sonics.effect.base.stft.stretch.AmDemodEngine;
import ch.tachyon.sonics.effect.base.stft.stretch.StftStretchAnalyzer;
import ch.tachyon.sonics.effect.pitchtime.bv.IFourierEngine;
import ch.tachyon.sonics.effect.pitchtime.bv.ISpectrumProcessor;
import ch.tachyon.sonics.effect.pitchtime.bv.TimeStretchEngine;
import ch.tachyon.sonics.effect.utils.buffer.DelayBuffer;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.Arrays;
import java.util.BitSet;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.utils.MultiChanAudioSourceFork;

public class SingleResEngine
implements IFourierEngine {
    public static boolean ANTI_LEAKAGE = true;
    private final double stretchRatio;
    private final StretchOptions options;
    private final int pyramidRes;
    private FourierSpec specs;
    private int nbChans;
    private int nbTracks;
    private int nbRes;
    private StftStretchAnalyzer analyzer;
    private StftStretchAnalyzer[] forkAnalysers;
    private Cmplx[][] fullSpectrums;
    private Cmplx[][][] forkedSpectrums;
    private Cmplx[][] allSpectrums;
    private Cmplx[][] tonalSpectrums;
    private Cmplx[][] noiseSpectrums;
    private Cmplx[] source;
    private BitSet incoherentBins;
    private BitSet noSkipBins;
    private StftSynthesizer[] fullSynthesizers;
    private StftSynthesizer[] tonalSynthesizers;
    private StftSynthesizer[] noiseSynthesizers;
    private float[][] trackOutputs;
    private float[] specialOutput;
    private int skipCounter;
    private int startBin;
    private int stopBin;
    private AmDemodEngine[] amDemodEngines;
    private DelayBuffer[][] delayers;
    private AmDemodEngine ceDemodEngine;
    private MultiChanAudioSourceFork[] resSplitters;
    private MultiChanAudioSourceFork origSplitter;

    public SingleResEngine(double stretchRatio, StretchOptions options, int pyramidRes) {
        this.stretchRatio = stretchRatio;
        this.options = options;
        this.pyramidRes = pyramidRes;
    }

    public void setSpecs(FourierSpec specs) {
        this.specs = specs;
    }

    public void startProcessing(IProcessingInfo info) {
        boolean timbreCorrection;
        this.nbChans = info.getNumberOfChannels();
        int nbBins = this.specs.getBaseResolution() / 2 + 1;
        this.startBin = 0;
        this.stopBin = nbBins;
        int blockSize = this.specs.getBaseResolution();
        int outputHopSize = this.specs.getOutputHopSize();
        double inputHopSize = (double)outputHopSize / this.stretchRatio;
        this.analyzer = new StftStretchAnalyzer(this.nbChans, blockSize, inputHopSize, this.specs.getAnalysisWindow());
        this.nbRes = this.options.nbLayers;
        this.forkAnalysers = new StftStretchAnalyzer[this.nbRes];
        this.forkedSpectrums = new Cmplx[this.nbRes][][];
        this.nbTracks = this.nbRes * this.nbChans;
        this.allSpectrums = new Cmplx[this.nbTracks][];
        int i = 0;
        while (i < this.forkAnalysers.length) {
            this.forkAnalysers[i] = new StftStretchAnalyzer(this.nbChans, blockSize, inputHopSize, this.specs.getAnalysisWindow());
            ++i;
        }
        this.incoherentBins = new BitSet(nbBins);
        this.noSkipBins = new BitSet(nbBins);
        this.fullSynthesizers = new StftSynthesizer[this.nbTracks];
        if (!TimeStretchEngine.PURE_VOCODER) {
            this.tonalSynthesizers = new StftSynthesizer[this.nbTracks];
            this.noiseSynthesizers = new StftSynthesizer[this.nbTracks];
        }
        int track = 0;
        while (track < this.nbTracks) {
            this.fullSynthesizers[track] = new StftSynthesizer(blockSize, outputHopSize, 1, this.specs.getAnalysisWindow(), this.specs.getSynthesisWindow());
            this.fullSynthesizers[track].setCoherent(true);
            this.fullSynthesizers[track].setName("full" + track);
            if (!TimeStretchEngine.PURE_VOCODER) {
                this.tonalSynthesizers[track] = new StftSynthesizer(blockSize, outputHopSize, 1, this.specs.getAnalysisWindow(), this.specs.getSynthesisWindow());
                this.tonalSynthesizers[track].setSkipFrames(this.options.skipFrames);
                this.tonalSynthesizers[track].setCoherent(true);
                this.tonalSynthesizers[track].setName("tonal" + track);
                this.noiseSynthesizers[track] = new StftSynthesizer(blockSize, outputHopSize, 1, this.specs.getAnalysisWindow(), this.specs.getSynthesisWindow());
                this.noiseSynthesizers[track].setSkipFrames(this.options.skipFrames);
                this.noiseSynthesizers[track].setCoherent(false);
                this.noiseSynthesizers[track].setName("noise" + track);
            }
            ++track;
        }
        if (!TimeStretchEngine.PURE_VOCODER) {
            this.noiseSpectrums = Cmplx.newArray(this.nbTracks, nbBins);
            this.tonalSpectrums = Cmplx.newArray(this.nbTracks, nbBins);
        }
        this.source = Cmplx.newArray(this.getNbBins());
        this.trackOutputs = new float[this.nbTracks][outputHopSize];
        this.specialOutput = new float[outputHopSize];
        int innerLatency = this.fullSynthesizers[0].getLatency();
        innerLatency -= blockSize / 2 - outputHopSize;
        int ceBlockSize = 4096;
        int innerLatency2 = innerLatency += (int)((double)(blockSize / 2 - outputHopSize) * this.stretchRatio + 0.5);
        boolean bl = timbreCorrection = this.options.timbreCorrection > 0.0f && blockSize < 4096;
        if (timbreCorrection) {
            int ceOverlap = this.specs.getIntOverlap();
            this.ceDemodEngine = new AmDemodEngine(this.nbChans, 4096, ceOverlap, outputHopSize, inputHopSize, innerLatency, 4096.0 / (double)blockSize, this.stretchRatio, true, this.options.timbreCorrection);
            innerLatency2 = innerLatency + this.ceDemodEngine.getLatency();
        }
        this.amDemodEngines = new AmDemodEngine[this.nbRes];
        int maxLatency = 0;
        int res = 0;
        while (res < this.nbRes) {
            int shrink = this.pyramidRes < 0 ? (new int[]{32, 8, 1})[res] : (this.pyramidRes == 0 ? (new int[]{16, 4, 1})[res] : (this.pyramidRes == 1 ? (new int[]{16, 4, 1})[res] : (new int[]{8, 4, 1})[res]));
            int cstBlockSize = blockSize / shrink;
            int cstOverlap = this.specs.getIntOverlap();
            boolean isSteadySoundRes = res == this.nbRes - 1;
            int theInnerLatency = isSteadySoundRes ? innerLatency2 : innerLatency;
            this.amDemodEngines[res] = new AmDemodEngine(this.nbChans, cstBlockSize, cstOverlap, outputHopSize, inputHopSize, theInnerLatency, (double)cstBlockSize / (double)blockSize, this.stretchRatio, true, isSteadySoundRes ? this.options.demodulate : 1.0f, isSteadySoundRes && ANTI_LEAKAGE);
            int myLatency = this.amDemodEngines[res].getLatency();
            if (this.ceDemodEngine != null && res == this.nbRes - 1) {
                myLatency += this.ceDemodEngine.getLatency();
            }
            if (myLatency > maxLatency) {
                maxLatency = myLatency;
            }
            ++res;
        }
        this.delayers = new DelayBuffer[this.nbRes][];
        res = 0;
        while (res < this.nbRes) {
            int myLatency = this.amDemodEngines[res].getLatency();
            if (this.ceDemodEngine != null && res == this.nbRes - 1) {
                myLatency += this.ceDemodEngine.getLatency();
            }
            if (myLatency < maxLatency) {
                this.delayers[res] = new DelayBuffer[this.nbChans];
                int chan = 0;
                while (chan < this.nbChans) {
                    this.delayers[res][chan] = new DelayBuffer(maxLatency - myLatency);
                    ++chan;
                }
            }
            ++res;
        }
    }

    public int getFixedChunkLength() {
        return this.specs.getOutputHopSize();
    }

    public int getNbScales() {
        return 1;
    }

    public int getNbResolutions() {
        return 1;
    }

    public int getNbBins() {
        return this.specs.getBaseResolution() / 2 + 1;
    }

    public int getNbBins(int res) {
        return this.getNbBins();
    }

    public int getNumHops(int scale) {
        return 1;
    }

    public int getAmDemodHopSize(int resolution) {
        return this.amDemodEngines[resolution].getHopSize();
    }

    private int getLatencyWithoutDemods() {
        int result = this.fullSynthesizers[0].getLatency();
        if (this.specs.getFourierLatency() != null) {
            result += this.specs.getFourierLatency().getFourierLatency(this.fullSynthesizers[0].getHopSize(), 0, 0);
        }
        return result += (int)((double)((float)this.fullSynthesizers[0].getBlockSize() / 2.0f) * (this.stretchRatio - 1.0) + 0.5);
    }

    public int getLatency() {
        int result = this.getLatencyWithoutDemods();
        if (this.amDemodEngines != null) {
            result += this.amDemodEngines[0].getLatency();
            if (this.delayers[0] != null) {
                result += this.delayers[0][0].getSize();
            }
        }
        return result;
    }

    public void beginProcessing(IProcessingInfo info) {
        int track = 0;
        while (track < this.nbTracks) {
            this.fullSynthesizers[track].init();
            if (!TimeStretchEngine.PURE_VOCODER) {
                this.tonalSynthesizers[track].init();
                this.noiseSynthesizers[track].init();
            }
            ++track;
        }
        if (this.ceDemodEngine != null) {
            this.ceDemodEngine.init(info);
        }
        if (this.amDemodEngines != null) {
            AmDemodEngine[] amDemodEngineArray = this.amDemodEngines;
            int n = this.amDemodEngines.length;
            int n2 = 0;
            while (n2 < n) {
                AmDemodEngine amDemodEngine = amDemodEngineArray[n2];
                amDemodEngine.init(info);
                ++n2;
            }
        }
    }

    public void setProcessingRange(int startBin, int stopBin) {
        this.startBin = startBin;
        this.stopBin = stopBin;
    }

    public int process(IMultiChanAudioSource mcSource, IMultiChanAudioSource[] mcTargets, ISpectrumProcessor processor, float[][] output) {
        int curHopSize;
        int track;
        int nbBins = this.getNbBins();
        if (this.resSplitters == null) {
            this.resSplitters = new MultiChanAudioSourceFork[this.nbRes];
            int res = 0;
            while (res < this.nbRes) {
                int nbSources = res == this.nbRes - 1 && this.ceDemodEngine != null ? 3 : 2;
                this.resSplitters[res] = new MultiChanAudioSourceFork(mcTargets[res], nbSources, this.nbChans);
                ++res;
            }
        }
        if (this.origSplitter == null) {
            this.origSplitter = new MultiChanAudioSourceFork(mcSource, ANTI_LEAKAGE ? 2 : 1, this.nbChans);
        }
        int nbRes = this.forkAnalysers.length;
        this.fullSpectrums = this.analyzer.analyze(this.origSplitter.getSource(0));
        int res = 0;
        while (res < nbRes) {
            this.forkedSpectrums[res] = this.forkAnalysers[res].analyze(this.resSplitters[res].getSource(0));
            ++res;
        }
        assert (this.allSpectrums.length == this.nbTracks);
        res = 0;
        while (res < nbRes) {
            int chan = 0;
            while (chan < this.nbChans) {
                this.allSpectrums[res * this.nbChans + chan] = this.forkedSpectrums[res][chan];
                ++chan;
            }
            ++res;
        }
        if (this.ceDemodEngine != null) {
            this.ceDemodEngine.analyse(this.resSplitters[nbRes - 1].getSource(2), null);
        }
        res = 0;
        while (res < nbRes) {
            if (res == nbRes - 1 && ANTI_LEAKAGE) {
                this.amDemodEngines[res].analyse(this.resSplitters[res].getSource(1), this.origSplitter.getSource(1));
            } else {
                this.amDemodEngines[res].analyse(this.resSplitters[res].getSource(1), null);
            }
            ++res;
        }
        int i = 0;
        while (i < nbBins) {
            this.source[i].set(this.fullSpectrums[0][i]);
            ++i;
        }
        int chan = 1;
        while (chan < this.nbChans) {
            int i2 = 0;
            while (i2 < nbBins) {
                this.source[i2].add(this.fullSpectrums[chan][i2]);
                ++i2;
            }
            ++chan;
        }
        processor.process(0, this.source, this.allSpectrums, this.incoherentBins, this.noSkipBins);
        if (!TimeStretchEngine.PURE_VOCODER) {
            track = 0;
            while (track < this.nbTracks) {
                Cmplx[] fullSpectrum = this.allSpectrums[track];
                Cmplx[] tonalSpectrum = this.tonalSpectrums[track];
                Cmplx[] noiseSpectrum = this.noiseSpectrums[track];
                int i3 = 0;
                while (i3 < nbBins) {
                    if (this.noSkipBins.get(i3)) {
                        tonalSpectrum[i3].set(0.0f, 0.0f);
                        noiseSpectrum[i3].set(0.0f, 0.0f);
                        if (this.incoherentBins.get(i3)) {
                            fullSpectrum[i3].mul(this.options.noiseBoost);
                        }
                    } else if (this.incoherentBins.get(i3)) {
                        noiseSpectrum[i3].set(fullSpectrum[i3]);
                        tonalSpectrum[i3].set(0.0f, 0.0f);
                        fullSpectrum[i3].set(0.0f, 0.0f);
                    } else {
                        tonalSpectrum[i3].set(fullSpectrum[i3]);
                        noiseSpectrum[i3].set(0.0f, 0.0f);
                        fullSpectrum[i3].set(0.0f, 0.0f);
                    }
                    ++i3;
                }
                if (this.skipCounter != 0) {
                    i3 = 0;
                    while (i3 < nbBins) {
                        tonalSpectrum[i3].set(0.0f, 0.0f);
                        noiseSpectrum[i3].set(0.0f, 0.0f);
                        ++i3;
                    }
                }
                ++track;
            }
        }
        track = 0;
        while (track < this.nbTracks) {
            this.fullSynthesizers[track].synthesize(new Cmplx[][]{this.allSpectrums[track]}, this.trackOutputs[track]);
            if (!TimeStretchEngine.PURE_VOCODER) {
                this.tonalSynthesizers[track].synthesize(new Cmplx[][]{this.tonalSpectrums[track]}, this.specialOutput);
                int i4 = 0;
                while (i4 < this.specialOutput.length) {
                    float[] fArray = this.trackOutputs[track];
                    int n = i4;
                    fArray[n] = fArray[n] + this.specialOutput[i4];
                    ++i4;
                }
                this.noiseSynthesizers[track].synthesize(new Cmplx[][]{this.noiseSpectrums[track]}, this.specialOutput);
                i4 = 0;
                while (i4 < this.specialOutput.length) {
                    float[] fArray = this.trackOutputs[track];
                    int n = i4;
                    fArray[n] = fArray[n] + this.specialOutput[i4];
                    ++i4;
                }
            }
            ++track;
        }
        if (this.ceDemodEngine != null) {
            float[][] higherRes = new float[this.nbChans][];
            int chan2 = 0;
            while (chan2 < this.nbChans) {
                higherRes[chan2] = this.trackOutputs[(nbRes - 1) * this.nbChans + chan2];
                ++chan2;
            }
            this.ceDemodEngine.demodulate(higherRes, this.startBin, this.stopBin, this.noSkipBins, null);
        }
        res = 0;
        while (res < nbRes) {
            float[][] resTracks = new float[this.nbChans][];
            int chan3 = 0;
            while (chan3 < this.nbChans) {
                resTracks[chan3] = this.trackOutputs[res * this.nbChans + chan3];
                ++chan3;
            }
            this.amDemodEngines[res].demodulate(resTracks, this.startBin, this.stopBin, this.noSkipBins, null);
            if (this.delayers[res] != null) {
                chan3 = 0;
                while (chan3 < this.nbChans) {
                    this.delayers[res][chan3].pushArray(resTracks[chan3]);
                    ++chan3;
                }
            }
            ++res;
        }
        chan = 0;
        while (chan < this.nbChans) {
            Arrays.fill(output[chan], 0.0f);
            ++chan;
        }
        res = 0;
        while (res < nbRes) {
            int chan4 = 0;
            while (chan4 < this.nbChans) {
                int i5 = 0;
                while (i5 < output[chan4].length) {
                    float[] fArray = output[chan4];
                    int n = i5;
                    fArray[n] = fArray[n] + this.trackOutputs[res * this.nbChans + chan4][i5];
                    ++i5;
                }
                ++chan4;
            }
            ++res;
        }
        this.skipCounter = (this.skipCounter + 1) % this.options.skipFrames;
        int nbInputSamples = this.analyzer.getCurSamplesRead();
        if (nbInputSamples == (curHopSize = this.analyzer.getCurrentHopSize())) {
            return output[0].length;
        }
        return Math.min(output[0].length, (int)((double)nbInputSamples * this.stretchRatio + 0.5));
    }

    public int getCurrentInputHopSize() {
        return this.analyzer.getCurrentHopSize();
    }

    public void stopProcessing() {
        this.analyzer = null;
        this.forkAnalysers = null;
        this.fullSynthesizers = null;
        this.tonalSynthesizers = null;
        this.noiseSynthesizers = null;
        this.specs = null;
        this.fullSpectrums = null;
        this.tonalSpectrums = null;
        this.noiseSpectrums = null;
        this.source = null;
        this.specialOutput = null;
        this.incoherentBins = null;
        this.noSkipBins = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        int track = 0;
        while (track < this.nbTracks) {
            this.fullSynthesizers[track].createSerialSections(factory);
            if (!TimeStretchEngine.PURE_VOCODER) {
                this.tonalSynthesizers[track].createSerialSections(factory);
                this.noiseSynthesizers[track].createSerialSections(factory);
            }
            ++track;
        }
        if (this.ceDemodEngine != null) {
            this.ceDemodEngine.createSerialSections(factory);
        }
        if (this.amDemodEngines != null) {
            AmDemodEngine[] amDemodEngineArray = this.amDemodEngines;
            int n = this.amDemodEngines.length;
            int n2 = 0;
            while (n2 < n) {
                AmDemodEngine ade = amDemodEngineArray[n2];
                ade.createSerialSections(factory);
                ++n2;
            }
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        int track = 0;
        while (track < this.nbTracks) {
            this.fullSynthesizers[track].setSerialSections(pool);
            if (!TimeStretchEngine.PURE_VOCODER) {
                this.tonalSynthesizers[track].setSerialSections(pool);
                this.noiseSynthesizers[track].setSerialSections(pool);
            }
            ++track;
        }
        if (this.ceDemodEngine != null) {
            this.ceDemodEngine.setSerialSections(pool);
        }
        if (this.amDemodEngines != null) {
            AmDemodEngine[] amDemodEngineArray = this.amDemodEngines;
            int n = this.amDemodEngines.length;
            int n2 = 0;
            while (n2 < n) {
                AmDemodEngine ade = amDemodEngineArray[n2];
                ade.setSerialSections(pool);
                ++n2;
            }
        }
    }
}

