/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.pitchtime.bv;

import ch.tachyon.sonics.effect.base.fourier.FourierProcessingType;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.stretch.StretchOptions;
import ch.tachyon.sonics.effect.pitchtime.bv.FourierEffectBase;
import ch.tachyon.sonics.effect.pitchtime.bv.SingleResEngine;
import ch.tachyon.sonics.effect.pitchtime.bv.TimeStretchEngine;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.PowerOfTwoTransform;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import ch.tachyon.tunnel.plugin.param.Transform;
import java.util.BitSet;
import org.corebounce.common.math.Cmplx;

@Category(value="Tempo")
@Name(value="Time Stretch Band Vocoder")
@Description(value="Change the speed without affecting the pitch")
public class TimeStretchBandVocoder
extends FourierEffectBase {
    private double ratio;
    private int logBlockSize;
    private int logOverlap;
    private float crispSmooth;
    private boolean multiresolution = true;
    private boolean pureVocoder = false;
    private TimeStretchEngine[] engines;

    @Order(value=1)
    @Scale(value=ScaleType.LOGARITHMIC)
    @Range(minValue=0.25, maxValue=4.0, defaultValue=1.0)
    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    @Order(value=2)
    @Range(minValue=0.0, maxValue=1.0, defaultValue=0.5)
    @Name(value="Crisp/Smooth")
    public float getCrispSmooth() {
        return this.crispSmooth;
    }

    public void setCrispSmooth(float crispSmooth) {
        this.crispSmooth = crispSmooth;
    }

    @Order(value=4)
    @Transform(value=PowerOfTwoTransform.class)
    @Range(minValue=8.0, maxValue=17.0, defaultValue=12.0)
    @Name(value="Block Size")
    public int getLogBlockSize() {
        return this.logBlockSize;
    }

    public void setLogBlockSize(int logBlockSize) {
        this.logBlockSize = logBlockSize;
    }

    @Order(value=5)
    @Transform(value=PowerOfTwoTransform.class)
    @Range(minValue=1.0, maxValue=5.0, defaultValue=2.0)
    @Name(value="Overlap")
    public int getLogOverlap() {
        return this.logOverlap;
    }

    public void setLogOverlap(int logOverlap) {
        this.logOverlap = logOverlap;
    }

    @Order(value=6)
    public boolean isMultiresolution() {
        return this.multiresolution;
    }

    public void setMultiresolution(boolean multiresolution) {
        this.multiresolution = multiresolution;
    }

    @Order(value=7)
    public boolean isPureVocoder() {
        return this.pureVocoder;
    }

    public void setPureVocoder(boolean pureVocoder) {
        this.pureVocoder = pureVocoder;
    }

    protected double getStretchRatio(IProcessingInfo info) {
        return this.ratio;
    }

    public void startProcessing(IProcessingInfo info) {
        int res;
        int nbRes;
        int blockSize = 1 << this.logBlockSize;
        int overlap = 1 << this.logOverlap;
        float sampleRate = info.getSampleRate();
        FourierSpec specs = this.getSpecs(info);
        TimeStretchEngine.PURE_VOCODER = this.pureVocoder;
        if (this.pureVocoder) {
            SingleResEngine.ANTI_LEAKAGE = false;
        }
        if (this.multiresolution) {
            int[] resolutions = specs.getPyramidResolutions();
            nbRes = resolutions.length;
            this.engines = new TimeStretchEngine[nbRes];
            res = 0;
            while (res < nbRes) {
                this.engines[res] = new TimeStretchEngine(this.ratio, resolutions[res], overlap, this.crispSmooth, sampleRate, false, true, true);
                ++res;
            }
        } else {
            this.engines = new TimeStretchEngine[1];
            this.engines[0] = new TimeStretchEngine(this.ratio, blockSize, overlap, this.crispSmooth, sampleRate, false, true, false);
        }
        TimeStretchEngine[] timeStretchEngineArray = this.engines;
        res = this.engines.length;
        nbRes = 0;
        while (nbRes < res) {
            TimeStretchEngine engine = timeStretchEngineArray[nbRes];
            engine.startProcessing();
            ++nbRes;
        }
        float noiseBoost = (float)Math.sqrt(this.ratio > 1.0 ? this.ratio : 1.0 / this.ratio);
        if (noiseBoost > 1.414f) {
            noiseBoost = 1.414f;
        }
        int nbSkipFrames = overlap / 2;
        float demodulateStrength = 0.0f;
        demodulateStrength = this.crispSmooth > 0.1f ? 1.0f : this.crispSmooth * 10.0f;
        float timbreStrength = 0.0f;
        if (this.crispSmooth > 0.2f) {
            timbreStrength = 1.0f;
        } else if (this.crispSmooth > 0.1f) {
            timbreStrength = (this.crispSmooth - 0.1f) * 10.0f;
        }
        StretchOptions options = new StretchOptions(nbSkipFrames, noiseBoost, 3, true, demodulateStrength, timbreStrength, false);
        super.setOptions(options);
        super.startProcessing(info);
    }

    protected FourierSpec getSpecs(IProcessingInfo info) {
        FourierSpec specs;
        int blockSize = 1 << this.logBlockSize;
        int overlap = 1 << this.logOverlap;
        if (this.multiresolution) {
            specs = new FourierSpec(info.getSampleRate());
            specs.setProcessingType(FourierProcessingType.PYRAMIDAL);
            int[] resolutions = new int[]{blockSize, blockSize / 2, blockSize / 4};
            specs.setPyramidResolutions(resolutions);
            this.setupSplitFreqs(specs);
            specs.setOverlap(overlap);
        } else {
            specs = new FourierSpec(blockSize, overlap);
        }
        return specs;
    }

    private void setupSplitFreqs(FourierSpec specs) {
        float spFreq1 = 800.0f;
        float spFreq2 = 2050.0f;
        if ((double)this.crispSmooth < 0.4) {
            float upwards1 = (0.4f - this.crispSmooth) / 0.4f;
            float upwards2 = this.ratio < 1.0 ? (float)Math.max(0.0, (this.ratio - 0.5) / 0.25) : (float)Math.max(0.0, (2.0 - this.ratio) / 1.0);
            if (upwards2 > 1.0f) {
                upwards2 = 1.0f;
            }
            float upwards = upwards1 * upwards2;
            spFreq1 = 800.0f * (1.0f - upwards) + 6000.0f * upwards;
            spFreq2 = 2050.0f * (1.0f - upwards) + 10000.0f * upwards;
        }
        specs.setSplitFreqs(new float[]{spFreq1, spFreq2});
    }

    public void process(int scale, Cmplx[] source, Cmplx[][] spectrums, BitSet incoherent, BitSet noSkipFrames) {
        int inHop = super.getCurrentInputHopSize();
        this.engines[scale].process(inHop, source, spectrums, incoherent, noSkipFrames);
    }

    public void stopProcessing() {
        super.stopProcessing();
        this.engines = null;
    }
}

