/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.pitchtime.bv;

import ch.tachyon.sonics.effect.separation.NoiseExtractor;
import ch.tachyon.sonics.effect.utils.MultiresolutionPeakPicker;
import ch.tachyon.sonics.effect.utils.PeakPicker;
import ch.tachyon.tunnel.utils.Debug;
import java.util.BitSet;
import java.util.Random;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.math.FastMath;

public class TimeStretchEngine {
    public static boolean PURE_VOCODER = false;
    private final double ratio;
    private final int blockSize;
    private final int overlap;
    private final int nbBins;
    private final float crispSmooth;
    private final float sampleRate;
    private final boolean hardLock;
    private final boolean handleNoise;
    private final boolean multires;
    private int nbBands;
    private float cutFreq;
    private PeakPicker peakPicker;
    private float[] powerMags;
    private double[] peakFrequencies;
    private double[] peakLevels;
    private int[] prevPeakBins;
    private NoiseExtractor noiseExtractor1;
    private NoiseExtractor noiseExtractor2;
    private Random rnd = new Random(0L);
    private float noiseStrength;
    private int[] bounds;
    private int[] lockPeaks;
    private float inHop;
    private float outHop;
    private double beta;
    private float[] phaseShifts;
    private float[] sourcePhases;
    private float[] prevSourcePhases;
    private Cmplx[] prevOutSource;
    private double[] frequencies;
    private double[] updatedPhases;
    private double[] unwrappedPhases;
    private Cmplx[] rotators;
    private double[] baseDelays;
    private int skipCounter;

    public TimeStretchEngine(double ratio, int blockSize, int overlap, float crispSmooth, float sampleRate, boolean hardLock, boolean handleNoise, boolean multires) {
        this.ratio = ratio;
        this.blockSize = blockSize;
        this.overlap = overlap;
        this.crispSmooth = crispSmooth;
        this.nbBins = blockSize / 2 + 1;
        this.sampleRate = sampleRate;
        this.hardLock = hardLock;
        this.handleNoise = handleNoise && !PURE_VOCODER;
        this.multires = multires;
    }

    public void startProcessing() {
        double smoothness;
        double middlePoint = 0.5;
        if ((double)this.crispSmooth < 0.5) {
            float crisp = this.crispSmooth;
            if (this.multires) {
                crisp = Math.max(0.0f, (this.crispSmooth - 0.2f) / 0.6f);
            }
            smoothness = middlePoint * (double)crisp * 2.0;
        } else {
            smoothness = middlePoint + (1.0 - middlePoint) * ((double)this.crispSmooth - 0.5) * 2.0;
        }
        this.nbBands = (int)(TimeStretchEngine.pickLogBetween(2.0, 400.0, smoothness) + 0.5);
        this.cutFreq = (float)TimeStretchEngine.pickLogBetween(500.0, 4000.0, smoothness);
        if (PURE_VOCODER) {
            this.cutFreq = 22050.0f;
            this.nbBands = 500;
        }
        this.peakPicker = this.blockSize >= 4096 && !PURE_VOCODER ? new MultiresolutionPeakPicker(this.nbBins) : new PeakPicker(this.nbBins);
        this.powerMags = new float[this.nbBins];
        this.peakFrequencies = new double[this.peakPicker.getMaxNbPeaks()];
        this.peakLevels = new double[this.peakPicker.getMaxNbPeaks()];
        this.prevPeakBins = new int[this.nbBins];
        int i = 0;
        while (i < this.nbBins) {
            this.prevPeakBins[i] = i;
            ++i;
        }
        if (!PURE_VOCODER) {
            this.noiseExtractor1 = new NoiseExtractor(this.nbBins, (float)AudioMath.dbToPowerLevel(20.0), 0.5f, this.sampleRate, 20.0f);
        }
        if (this.handleNoise) {
            this.noiseExtractor2 = new NoiseExtractor(this.nbBins, (float)AudioMath.dbToPowerLevel(10.0), 0.5f, this.sampleRate, 100.0f);
        }
        this.phaseShifts = new float[this.nbBins];
        this.sourcePhases = new float[this.nbBins];
        this.prevSourcePhases = new float[this.nbBins];
        this.prevOutSource = Cmplx.newArray(this.nbBins);
        this.frequencies = new double[this.nbBins];
        this.updatedPhases = new double[this.nbBins];
        this.unwrappedPhases = new double[this.nbBins];
        this.rotators = Cmplx.newArray(this.nbBins);
        i = 0;
        while (i < this.nbBins) {
            this.rotators[i].set(1.0f, 0.0f);
            ++i;
        }
        this.bounds = new int[this.nbBands + 1];
        this.bounds[0] = 0;
        this.bounds[this.nbBands] = this.nbBins;
        double minInc = 4.0 * (double)this.nbBands / (double)this.nbBins;
        double logMin = Math.log(minInc);
        double logMax = Math.log(this.nbBands);
        double prevValue = 0.0;
        int band = 1;
        while (band < this.nbBands) {
            int binNum;
            double logValue = logMin + (logMax - logMin) / (double)(this.nbBands + 1 - band);
            double value = Math.exp(logValue);
            if (prevValue + minInc > value) {
                value = prevValue + minInc;
            }
            this.bounds[band] = binNum = (int)(value * (double)this.nbBins / (double)this.nbBands + 0.5);
            if (this.bounds[band] >= this.nbBins) {
                this.bounds[band] = this.nbBins;
                this.nbBands = band;
                Debug.warn("Using only {0} bands", this.nbBands);
                break;
            }
            logMin = Math.log(value);
            prevValue = value;
            ++band;
        }
        this.lockPeaks = new int[this.nbBands];
        if (this.overlap <= 2) {
            this.beta = 1.0;
        } else if (this.ratio < 1.0) {
            this.beta = 0.6666666666666666 + 0.3333333333333333 * this.ratio;
        } else if (this.ratio < 2.0) {
            double beta0 = 0.6666666666666666 + 0.3333333333333333 * this.ratio;
            this.beta = beta0 * (2.0 - this.ratio) + this.ratio * (this.ratio - 1.0);
        } else {
            this.beta = this.ratio;
        }
        this.baseDelays = new double[this.nbBins];
        this.skipCounter = 0;
        this.noiseStrength = this.ratio < 1.1 ? 0.0f : (this.ratio < 2.0 ? (float)((this.ratio - 1.1) / 0.9) : 1.0f);
        if ((double)this.crispSmooth < 0.3) {
            this.noiseStrength = 0.0f;
        } else {
            float correction = (this.crispSmooth - 0.3f) / 0.7f;
            if (correction > 1.0f) {
                correction = 1.0f;
            }
            correction = (float)Math.sqrt(correction);
            this.noiseStrength *= correction;
        }
    }

    private static double pickLogBetween(double min, double max, double value) {
        double logResult = Math.log(min) + (Math.log(max) - Math.log(min)) * value;
        double result = Math.exp(logResult);
        if (result < min) {
            result = min;
        } else if (result > max) {
            result = max;
        }
        return result;
    }

    public void process(int inHop, Cmplx[] source, Cmplx[][] spectrums, BitSet incoherent, BitSet noSkipFrames) {
        this.normalize(source, spectrums);
        this.inHop = inHop;
        this.outHop = (float)this.blockSize / (float)this.overlap;
        if (this.skipCounter == 0) {
            PeakPicker.fillPowerMags(source, this.powerMags);
            this.peakPicker.pickPeaks(this.powerMags);
            this.peakPicker.fillPeakFrequencies(this.peakFrequencies);
            this.peakPicker.fillPeakPowerLevels(this.peakFrequencies, this.peakLevels);
        }
        int nbPeaks = this.peakPicker.getNbPeaks();
        int i = 0;
        while (i < this.nbBins) {
            this.sourcePhases[i] = source[i].phiApprox();
            ++i;
        }
        this.computePhaseShiftsAllPeaks(source);
        this.peakPicker.fillReverseArray();
        BitSet noise1 = this.noiseExtractor1 != null ? this.noiseExtractor1.analyze(source) : new BitSet();
        BitSet noise2 = null;
        if (this.noiseExtractor2 != null) {
            noise2 = this.noiseExtractor2.analyze(source);
        }
        int i2 = 0;
        while (i2 < this.nbBins) {
            incoherent.set(i2, noise1.get(i2));
            ++i2;
        }
        if (PURE_VOCODER) {
            incoherent.clear();
        }
        this.fillBandDominantPeaks();
        if (this.skipCounter != 0) {
            i2 = 0;
            while (i2 < this.nbBins) {
                this.calculateFrequency(i2);
                ++i2;
            }
        }
        int peakNum = 0;
        while (peakNum < nbPeaks) {
            int curBinNum = this.peakPicker.getPeakBinIndex(peakNum);
            int prevBinNum = this.prevPeakBins[curBinNum];
            this.calculateUpdatedPhases(curBinNum, prevBinNum);
            ++peakNum;
        }
        int middleBin = (int)((double)this.cutFreq * (double)this.blockSize / (double)this.sampleRate + 0.5);
        noSkipFrames.set(0, middleBin, true);
        noSkipFrames.set(middleBin, this.nbBins, false);
        int band = 0;
        while (band < this.nbBands) {
            int peakNum0 = this.lockPeaks[band];
            int binNum0 = this.peakPicker.getPeakBinIndex(peakNum0);
            double frequency0 = this.frequencies[binNum0];
            double period0 = frequency0 > 0.0 ? Math.PI * 2 / frequency0 : 1.0;
            double phaseShift0 = FastMath.wrap(this.updatedPhases[binNum0] - (double)this.sourcePhases[binNum0]);
            if (phaseShift0 < 0.0) {
                phaseShift0 += Math.PI * 2;
            }
            double baseDelay0 = phaseShift0 * period0 / (Math.PI * 2);
            int i3 = this.bounds[band];
            while (i3 < this.bounds[band + 1]) {
                boolean isPeak;
                int peakNum2 = this.peakPicker.findNearestPeakNum(i3);
                int peakBin = this.peakPicker.getPeakBinIndex(peakNum2);
                boolean bl = isPeak = i3 == peakBin;
                if (this.hardLock || isPeak || i3 > middleBin && this.skipCounter != 0) {
                    if (i3 > middleBin) {
                        double baseDelay;
                        if (this.skipCounter == 0) {
                            baseDelay = baseDelay0;
                            this.baseDelays[i3] = baseDelay0;
                        } else {
                            baseDelay = this.baseDelays[i3];
                            this.baseDelays[i3] = baseDelay += (double)(this.outHop - (float)inHop);
                        }
                        double frequency = this.hardLock ? Math.PI * 2 * (double)i3 / (double)this.blockSize : this.frequencies[i3];
                        double period = frequency > 0.0 ? Math.PI * 2 / frequency : 1.0;
                        double phaseDelay = baseDelay % period;
                        double phaseShift = phaseDelay * (Math.PI * 2) / period;
                        double prevUpdatedPhase = this.updatedPhases[i3];
                        this.updatedPhases[i3] = (double)this.sourcePhases[i3] + phaseShift;
                        if (isPeak) {
                            double phaseSkew = this.updatedPhases[i3] - prevUpdatedPhase;
                            if (phaseSkew > Math.PI) {
                                phaseSkew -= Math.PI * 2;
                            } else if (phaseSkew < -Math.PI) {
                                phaseSkew += Math.PI * 2;
                            }
                            if (Math.abs(phaseSkew) > 0.7853981633974483) {
                                int startBin = this.peakPicker.getPeakLowerBin(peakNum2);
                                int stopBin = this.peakPicker.getPeakUpperBin(peakNum2);
                                if (stopBin > startBin) {
                                    incoherent.set(startBin, stopBin, true);
                                }
                            }
                        }
                        this.rotators[i3].set(1.0f, (float)phaseShift);
                        this.rotators[i3].toCartesianApprox();
                    } else if (isPeak) {
                        double phaseRotation = this.updatedPhases[i3] - (double)this.sourcePhases[i3];
                        this.rotators[i3].set(1.0f, (float)phaseRotation);
                        this.rotators[i3].toCartesianApprox();
                    }
                }
                ++i3;
            }
            ++band;
        }
        int peakNum3 = 0;
        while (peakNum3 < nbPeaks) {
            int peakBin = this.peakPicker.getPeakBinIndex(peakNum3);
            int startBin = this.peakPicker.getPeakLowerBin(peakNum3);
            int stopBin = this.peakPicker.getPeakUpperBin(peakNum3);
            if (peakBin < middleBin) {
                double unwrappedPhase;
                this.unwrappedPhases[startBin] = unwrappedPhase = (double)this.sourcePhases[startBin];
                double previousPhase = unwrappedPhase;
                int i4 = startBin + 1;
                while (i4 < stopBin) {
                    double currentPhase = this.sourcePhases[i4];
                    double phaseDiff = currentPhase - previousPhase;
                    if (phaseDiff > Math.PI) {
                        phaseDiff -= Math.PI * 2;
                    } else if (phaseDiff < -Math.PI) {
                        phaseDiff += Math.PI * 2;
                    }
                    this.unwrappedPhases[i4] = unwrappedPhase += phaseDiff;
                    previousPhase = currentPhase;
                    ++i4;
                }
                assert (peakBin >= startBin && peakBin <= stopBin);
                i4 = startBin;
                while (i4 < stopBin) {
                    double updatedPhase = this.updatedPhases[peakBin] + this.beta * (this.unwrappedPhases[i4] - this.unwrappedPhases[peakBin]);
                    double phaseRotation = updatedPhase - this.unwrappedPhases[i4];
                    this.rotators[i4].set(1.0f, (float)phaseRotation);
                    this.rotators[i4].toCartesianApprox();
                    this.prevPeakBins[i4] = peakBin;
                    this.baseDelays[i4] = this.baseDelays[peakBin];
                    ++i4;
                }
            } else if (this.skipCounter == 0) {
                int i5 = startBin;
                while (i5 < stopBin) {
                    if (!this.hardLock) {
                        this.rotators[i5].set(this.rotators[peakBin]);
                        this.prevPeakBins[i5] = peakBin;
                        this.baseDelays[i5] = this.baseDelays[peakBin];
                    }
                    ++i5;
                }
            }
            ++peakNum3;
        }
        this.applyPhasePropagation(source, spectrums);
        if (this.handleNoise && this.noiseStrength > 0.0f) {
            band = 0;
            while (band < this.nbBands) {
                float noiseEnergy = 0.0f;
                float totalEnergy = 0.0f;
                int i6 = this.bounds[band];
                while (i6 < this.bounds[band + 1]) {
                    noiseEnergy += this.powerMags[i6] * this.noiseExtractor2.getNoiseness(i6);
                    totalEnergy += this.powerMags[i6];
                    ++i6;
                }
                float noiseness = 0.0f;
                if (totalEnergy > Float.MIN_NORMAL) {
                    noiseness = (float)Math.sqrt(noiseEnergy / totalEnergy);
                }
                float knee = 1.0f - this.noiseStrength / 2.0f;
                float mult = Math.min(4.0f, 1.0f / knee);
                noiseness = noiseness < knee ? 0.0f : (noiseness - knee) * mult;
                int nbChans = spectrums.length;
                if (noiseness > 0.0f) {
                    int base = this.bounds[band];
                    float rndDelay = this.rnd.nextFloat() / (float)(base + 1);
                    int i7 = this.bounds[band];
                    while (i7 < this.bounds[band + 1]) {
                        if (noise2.get(i7)) {
                            float phaseShift = rndDelay * ((float)Math.PI * 2) * (float)i7;
                            Cmplx rotate = new Cmplx();
                            rotate.set(1.0f, phaseShift);
                            rotate.toCartesianApprox();
                            int chan = 0;
                            while (chan < nbChans) {
                                spectrums[chan][i7].mul(rotate);
                                ++chan;
                            }
                        }
                        ++i7;
                    }
                }
                ++band;
            }
        }
        int i8 = 0;
        while (i8 < this.nbBins) {
            this.prevSourcePhases[i8] = this.sourcePhases[i8];
            ++i8;
        }
        this.skipCounter = (this.skipCounter + 1) % (this.overlap / 2);
        this.normalize(source, spectrums);
    }

    private void normalize(Cmplx[] source, Cmplx[][] spectrums) {
        int i;
        int i2 = 0;
        while (i2 < this.nbBins) {
            source[i2].im *= -1.0f;
            ++i2;
        }
        int chan = 0;
        while (chan < spectrums.length) {
            i = 0;
            while (i < this.nbBins) {
                spectrums[chan][i].im *= -1.0f;
                ++i;
            }
            ++chan;
        }
        i2 = 0;
        while (i2 < this.nbBins) {
            source[i2].mul(-1.0f);
            i2 += 2;
        }
        chan = 0;
        while (chan < spectrums.length) {
            i = 0;
            while (i < this.nbBins) {
                spectrums[chan][i].mul(-1.0f);
                i += 2;
            }
            ++chan;
        }
    }

    private void computePhaseShiftsAllPeaks(Cmplx[] source) {
        int nbPeaks = this.peakPicker.getNbPeaks();
        int peakIndex = 0;
        while (peakIndex < nbPeaks) {
            int curBinIndex = this.peakPicker.getPeakBinIndex(peakIndex);
            int prevBinIndex = this.prevPeakBins[curBinIndex];
            this.computePhaseShift(source, curBinIndex, prevBinIndex);
            ++peakIndex;
        }
    }

    private void computePhaseShift(Cmplx[] source, int curBinNum, int prevBinNum) {
        float phase = this.sourcePhases[curBinNum];
        float prevPhase = this.prevSourcePhases[prevBinNum];
        float phaseShift = phase - prevPhase;
        if ((double)phaseShift > Math.PI) {
            phaseShift = (float)((double)phaseShift - Math.PI * 2);
        } else if ((double)phaseShift < -Math.PI) {
            phaseShift = (float)((double)phaseShift + Math.PI * 2);
        }
        this.phaseShifts[curBinNum] = phaseShift;
    }

    private void calculateUpdatedPhases(int curBinNum, int prevBinNum) {
        double frequency = this.calculateFrequency(curBinNum);
        this.updatedPhases[curBinNum] = (double)this.prevOutSource[prevBinNum].phiApprox() + frequency * (double)this.outHop;
    }

    private double calculateFrequency(int binNum) {
        double binFreq = Math.PI * 2 * (double)binNum / (double)this.blockSize;
        double inPhaseShift = this.phaseShifts[binNum];
        double expectedShift = (double)this.inHop * binFreq;
        double phi = FastMath.wrap(inPhaseShift - expectedShift);
        double frequency = binFreq + phi / (double)this.inHop;
        this.frequencies[binNum] = frequency > 0.0 ? frequency : binFreq;
        return frequency;
    }

    private void applyPhasePropagation(Cmplx[] source, Cmplx[][] spectrums) {
        int nbChans = spectrums.length;
        int chan = 0;
        while (chan < nbChans) {
            Cmplx[] spectrum = spectrums[chan];
            int i = 0;
            while (i < this.nbBins) {
                spectrum[i].mul(this.rotators[i]);
                ++i;
            }
            ++chan;
        }
        int i = 0;
        while (i < this.nbBins) {
            this.prevOutSource[i].set(source[i]);
            this.prevOutSource[i].mul(this.rotators[i]);
            ++i;
        }
    }

    private void fillBandDominantPeaks() {
        this.peakPicker.fillReverseArray();
        int band = 0;
        while (band < this.nbBands) {
            int peakNum = 0;
            double level = -1.0;
            int binNum = this.bounds[band];
            while (binNum < this.bounds[band + 1]) {
                int p = this.peakPicker.findNearestPeakNum(binNum);
                if (this.peakLevels[p] > level) {
                    peakNum = p;
                    level = this.peakLevels[p];
                }
                ++binNum;
            }
            this.lockPeaks[band] = peakNum;
            ++band;
        }
    }

    public void stopProcessing() {
        this.phaseShifts = null;
        this.sourcePhases = null;
        this.prevSourcePhases = null;
        this.prevOutSource = null;
        this.frequencies = null;
        this.updatedPhases = null;
        this.rotators = null;
        this.powerMags = null;
        this.peakPicker = null;
        this.peakFrequencies = null;
        this.peakLevels = null;
        this.prevPeakBins = null;
        this.noiseExtractor1 = null;
        this.noiseExtractor2 = null;
    }
}

