/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.utils;

import ch.tachyon.sonics.effect.utils.buffer.FloatQueue;
import ch.tachyon.tunnel.utils.Debug;
import org.corebounce.common.dsp.resample.IAudioSource;
import org.corebounce.common.dsp.resample.IResampler;
import org.corebounce.common.dsp.resample.ResamplerFactory;
import org.corebounce.common.utils.IDisposable;

public class InOutResampler
implements IDisposable {
    private final IResampler resampler;
    private final int maxInputSize;
    private final FloatQueue inputQueue;
    private final float[] buffer;
    private final FloatQueue outputQueue;
    private Thread loopThread;
    private volatile boolean endOfStreamIn = false;
    private volatile boolean endOfStreamOut = false;
    private volatile boolean active = true;

    public InOutResampler(double ratio, int quality, int maxInputSize) {
        this.resampler = ResamplerFactory.getResampler(new AudioSource(), ratio, quality, false, maxInputSize);
        this.maxInputSize = maxInputSize;
        this.inputQueue = new FloatQueue(maxInputSize * 2);
        int maxOutputSize = (int)((double)this.inputQueue.getCapacity() * ratio) + 1;
        this.buffer = new float[maxInputSize];
        this.outputQueue = new FloatQueue(maxOutputSize + maxInputSize);
        this.loopThread = new Thread((Runnable)new MainLoop(), InOutResampler.class.getSimpleName());
        this.loopThread.setDaemon(true);
        this.loopThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float[] resample(float[] input, boolean isLast) {
        if (input.length > this.maxInputSize) {
            throw new IllegalArgumentException("The size of the input array (" + input.length + ") is greater than maxInputSize (" + this.maxInputSize + ")");
        }
        FloatQueue floatQueue = this.inputQueue;
        synchronized (floatQueue) {
            while (true) {
                if (this.inputQueue.getCapacity() - this.inputQueue.getSize() >= input.length) {
                    this.inputQueue.pushArray(input);
                    if (isLast) {
                        this.endOfStreamIn = true;
                    }
                    this.inputQueue.notify();
                    break;
                }
                try {
                    this.inputQueue.wait();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
        floatQueue = this.outputQueue;
        synchronized (floatQueue) {
            float[] result = new float[this.outputQueue.getSize()];
            if (result.length > 0) {
                this.outputQueue.popArray(result);
            }
            this.outputQueue.notify();
            if (isLast) {
                while (!this.endOfStreamOut) {
                    try {
                        this.outputQueue.wait();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    float[] tail = new float[this.outputQueue.getSize()];
                    this.outputQueue.popArray(tail);
                    this.outputQueue.notify();
                    float[] head = result;
                    result = new float[head.length + tail.length];
                    System.arraycopy(head, 0, result, 0, head.length);
                    System.arraycopy(tail, 0, result, head.length, tail.length);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxOutputLength() {
        FloatQueue floatQueue = this.outputQueue;
        synchronized (floatQueue) {
            return this.outputQueue.getCapacity();
        }
    }

    public void dispose() {
        this.active = false;
        if (this.loopThread != null) {
            this.loopThread.interrupt();
            try {
                this.loopThread.join(1000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            this.loopThread = null;
        }
    }

    public void finalize() {
        if (this.loopThread != null) {
            Debug.warn("dispose() was not invoked", new Object[0]);
            this.dispose();
        }
    }

    class AudioSource
    implements IAudioSource {
        AudioSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int getSamples(float[] target, int offset, int count) {
            FloatQueue floatQueue = InOutResampler.this.inputQueue;
            synchronized (floatQueue) {
                while (true) {
                    if (!InOutResampler.this.active || InOutResampler.this.endOfStreamIn || InOutResampler.this.inputQueue.getSize() >= count) {
                        if (InOutResampler.this.active) break;
                        return 0;
                    }
                    try {
                        InOutResampler.this.inputQueue.wait();
                    }
                    catch (InterruptedException ex) {
                        return 0;
                    }
                }
                if (InOutResampler.this.endOfStreamIn) {
                    count = Math.min(count, InOutResampler.this.inputQueue.getSize());
                }
                InOutResampler.this.inputQueue.popArray(target, offset, count);
                InOutResampler.this.inputQueue.notify();
                return count;
            }
        }
    }

    class MainLoop
    implements Runnable {
        MainLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (InOutResampler.this.active) {
                int amount = InOutResampler.this.resampler.resample(InOutResampler.this.buffer);
                if (amount < 0) {
                    amount = 0;
                }
                FloatQueue floatQueue = InOutResampler.this.outputQueue;
                synchronized (floatQueue) {
                    while (InOutResampler.this.active && InOutResampler.this.outputQueue.getCapacity() - InOutResampler.this.outputQueue.getSize() < amount) {
                        try {
                            InOutResampler.this.outputQueue.wait();
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                    }
                    if (InOutResampler.this.active) {
                        InOutResampler.this.outputQueue.pushArray(InOutResampler.this.buffer, amount);
                    }
                    if (InOutResampler.this.endOfStreamIn) {
                        if (amount < InOutResampler.this.buffer.length) {
                            InOutResampler.this.endOfStreamOut = true;
                        }
                        InOutResampler.this.outputQueue.notify();
                    }
                }
            }
        }
    }
}

