/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.utils;

import org.corebounce.common.dsp.AverageBuffer;

public class MultiAvgBuffer {
    private final AverageBuffer[] buffers;
    private final int size;

    public MultiAvgBuffer(int count, int size) {
        if (count < 1 || size < 1) {
            throw new IllegalArgumentException();
        }
        this.size = size;
        this.buffers = new AverageBuffer[count];
        int i = 0;
        while (i < count) {
            this.buffers[i] = new AverageBuffer(size);
            ++i;
        }
    }

    public float push(float value) {
        int i = 0;
        while (i < this.buffers.length) {
            this.buffers[i].push(value);
            value = this.buffers[i].getAverage();
            ++i;
        }
        return value;
    }

    public float getValue() {
        return this.buffers[this.buffers.length - 1].getAverage();
    }

    public int getSize() {
        return this.size;
    }

    public int getCount() {
        return this.buffers.length;
    }

    public float getLatency() {
        float oneLatency = ((float)this.size - 1.0f) / 2.0f;
        return oneLatency * (float)this.buffers.length;
    }

    public static void main(String[] args) {
        float[] values = new float[128];
        values[8] = 6400.0f;
        MultiAvgBuffer buffer = new MultiAvgBuffer(4, 33);
        int i = 0;
        while (i < values.length) {
            values[i] = buffer.push(values[i]);
            int k = (int)(values[i] + 0.5f);
            int j = 0;
            while (j < k) {
                System.out.print(" ");
                ++j;
            }
            System.out.println("0");
            ++i;
        }
    }
}

