/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.utils;

import ch.tachyon.sonics.effect.utils.PeakPicker;

public class MultiresolutionPeakPicker
extends PeakPicker {
    private final int[] distances;

    public MultiresolutionPeakPicker(int nbBins) {
        super(nbBins);
        this.distances = new int[nbBins];
        double step = nbBins / 128;
        if (step < 2.0) {
            step = 2.0;
        }
        int curDistance = 1;
        int i = 0;
        while (i < nbBins) {
            if ((double)i >= step) {
                step *= 2.0;
            }
            this.distances[i] = ++curDistance;
            ++i;
        }
    }

    protected boolean isPeak(int i) {
        float pm = this.getPowerMag(i);
        int dist = this.distances[i];
        int k = 1;
        while (k <= dist) {
            if (pm < this.getPowerMag(i - k) || pm <= this.getPowerMag(i + k)) {
                return false;
            }
            ++k;
        }
        return true;
    }
}

