/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.utils.median;

import java.util.Arrays;
import java.util.NoSuchElementException;

public abstract class IndexBinaryHeap {
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    private int[] queue;
    private int size = 0;

    public IndexBinaryHeap() {
        this(11);
    }

    public IndexBinaryHeap(int initialCapacity) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException();
        }
        this.queue = new int[initialCapacity];
    }

    protected abstract int compare(int var1, int var2);

    protected abstract void setLocation(int var1, int var2);

    private void grow(int minCapacity) {
        int newCapacity;
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        int oldCapacity = this.queue.length;
        int n = newCapacity = oldCapacity < 64 ? (oldCapacity + 1) * 2 : oldCapacity / 2 * 3;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        }
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this.queue = Arrays.copyOf(this.queue, newCapacity);
    }

    public boolean add(int e) {
        int i = this.size;
        if (i >= this.queue.length) {
            this.grow(i + 1);
        }
        this.size = i + 1;
        if (i == 0) {
            this.queue[0] = e;
            this.setLocation(e, 0);
        } else {
            this.siftUp(i, e);
        }
        return true;
    }

    public int peek() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.queue[0];
    }

    public int getSize() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public int poll() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int s = --this.size;
        int result = this.queue[0];
        int x = this.queue[s];
        if (s != 0) {
            this.siftDown(0, x);
        }
        return result;
    }

    public int getAt(int i) {
        assert (i >= 0 && i < this.size);
        return this.queue[i];
    }

    public void removeAt(int i) {
        int s;
        assert (i >= 0 && i < this.size);
        if ((s = --this.size) != i) {
            int moved = this.queue[s];
            this.siftDown(i, moved);
            if (this.queue[i] == moved) {
                this.siftUp(i, moved);
            }
        }
    }

    private void siftUp(int k, int x) {
        while (k > 0) {
            int parent = k - 1 >>> 1;
            int e = this.queue[parent];
            if (this.compare(x, e) >= 0) break;
            this.queue[k] = e;
            this.setLocation(e, k);
            k = parent;
        }
        this.queue[k] = x;
        this.setLocation(x, k);
    }

    private void siftDown(int k, int x) {
        int half = this.size >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            int c = this.queue[child];
            int right = child + 1;
            if (right < this.size && this.compare(c, this.queue[right]) > 0) {
                child = right;
                c = this.queue[child];
            }
            if (this.compare(x, c) <= 0) break;
            this.queue[k] = c;
            this.setLocation(c, k);
            k = child;
        }
        this.queue[k] = x;
        this.setLocation(x, k);
    }

    public String toString() {
        return Arrays.toString(Arrays.copyOf(this.queue, this.size));
    }
}

