/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.utils.median;

import ch.tachyon.sonics.effect.utils.median.IndexBinaryHeap;
import java.util.Arrays;
import java.util.Random;
import org.corebounce.common.dsp.IMovingFilter;

public class MovingMedianFilter
implements IMovingFilter {
    private final int size;
    private final float[] buffer;
    private int index;
    private final int[] locations;
    private final IndexBinaryHeap loHeap;
    private final IndexBinaryHeap hiHeap;

    public MovingMedianFilter(int size) {
        if (size < 2) {
            throw new IllegalArgumentException();
        }
        this.size = size;
        this.buffer = new float[size];
        this.locations = new int[size];
        this.loHeap = new IndexBinaryHeap(size / 2 + 2){

            protected void setLocation(int e, int loc) {
                ((MovingMedianFilter)MovingMedianFilter.this).locations[e] = -loc - 1;
            }

            protected int compare(int i1, int i2) {
                return -Float.compare(MovingMedianFilter.this.buffer[i1], MovingMedianFilter.this.buffer[i2]);
            }
        };
        this.hiHeap = new IndexBinaryHeap(size / 2 + 2){

            protected void setLocation(int e, int loc) {
                ((MovingMedianFilter)MovingMedianFilter.this).locations[e] = loc;
            }

            protected int compare(int i1, int i2) {
                return Float.compare(MovingMedianFilter.this.buffer[i1], MovingMedianFilter.this.buffer[i2]);
            }
        };
        int i = 0;
        while (i < size) {
            if (i < size / 2) {
                this.loHeap.add(i);
            } else {
                this.hiHeap.add(i);
            }
            ++i;
        }
    }

    public void push(float value) {
        int lastLoc = this.locations[this.index];
        if (lastLoc < 0) {
            this.loHeap.removeAt(-lastLoc - 1);
        } else {
            this.hiHeap.removeAt(lastLoc);
        }
        this.buffer[this.index] = value;
        float median = this.getMedian();
        if (value < median) {
            this.loHeap.add(this.index);
        } else {
            this.hiHeap.add(this.index);
        }
        this.index = (this.index + 1) % this.size;
        int loSize = this.loHeap.getSize();
        int hiSize = this.hiHeap.getSize();
        if (loSize > hiSize + 1) {
            int indexToMove = this.loHeap.poll();
            this.hiHeap.add(indexToMove);
        } else if (hiSize > loSize + 1) {
            int indexToMove = this.hiHeap.poll();
            this.loHeap.add(indexToMove);
        }
    }

    public float getMedian() {
        int hiSize;
        int loSize = this.loHeap.getSize();
        if (loSize > (hiSize = this.hiHeap.getSize())) {
            int index = this.loHeap.peek();
            return this.buffer[index];
        }
        if (loSize < hiSize) {
            int index = this.hiHeap.peek();
            return this.buffer[index];
        }
        int loIndex = this.loHeap.peek();
        int hiIndex = this.hiHeap.peek();
        return (this.buffer[loIndex] + this.buffer[hiIndex]) / 2.0f;
    }

    public float getFiltered() {
        return this.getMedian();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("heaps ");
        result.append(this.loHeap.toString());
        result.append(" ");
        result.append(this.hiHeap.toString());
        result.append("\npartition [");
        int i = 0;
        while (i < this.loHeap.getSize()) {
            if (i > 0) {
                result.append(",");
            }
            result.append(this.buffer[this.loHeap.getAt(i)]);
            ++i;
        }
        result.append("] [");
        i = 0;
        while (i < this.hiHeap.getSize()) {
            if (i > 0) {
                result.append(",");
            }
            result.append(this.buffer[this.hiHeap.getAt(i)]);
            ++i;
        }
        result.append("]");
        result.append("\nlocations ");
        result.append(Arrays.toString(this.locations));
        result.append("\nbuffer ");
        result.append(Arrays.toString(this.buffer));
        return result.toString();
    }

    public static void main(String[] args) {
        MovingMedianFilter filter = new MovingMedianFilter(21);
        Random rnd = new Random(0L);
        float prevValue = 0.0f;
        int i = 0;
        while (i < 1000) {
            float value;
            float newValue = rnd.nextFloat();
            prevValue = value = prevValue * 0.9f + newValue * 0.1f;
            filter.push(value);
            float median = filter.getMedian();
            int pv = (int)(value * 120.0f);
            int pm = (int)(median * 120.0f);
            int k = 0;
            while (k <= 120) {
                if (k == pv && k == pm) {
                    System.out.print("\u253c");
                } else if (k == pm) {
                    System.out.print("|");
                } else if (k == pv) {
                    System.out.print("-");
                } else {
                    System.out.print(" ");
                }
                ++k;
            }
            System.out.println();
            ++i;
        }
    }
}

