/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.audio.file;

import ch.tachyon.tunnel.utils.IProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomFileInputStream
extends InputStream {
    private final RandomAccessFile raFile;
    private final IProgressMonitor progress;
    private long markPos = -1L;
    private boolean closed = false;

    public RandomFileInputStream(File file) throws IOException {
        this(file, null);
    }

    public RandomFileInputStream(File file, IProgressMonitor progress) throws IOException {
        this.raFile = new RandomAccessFile(file, "r");
        this.progress = progress;
    }

    public int read() throws IOException {
        this.updateProgress();
        return this.raFile.read();
    }

    public int available() throws IOException {
        return (int)(this.raFile.length() - this.raFile.getFilePointer());
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.updateProgress();
        this.raFile.close();
    }

    public synchronized void mark(int readlimit) {
        try {
            this.markPos = this.raFile.getFilePointer();
        }
        catch (IOException ex) {
            this.markPos = -2L;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.updateProgress();
        return this.raFile.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        this.updateProgress();
        return this.raFile.read(b);
    }

    public synchronized void reset() throws IOException {
        if (this.markPos == -2L) {
            throw new IOException("mark() failed to get file pointer");
        }
        if (this.markPos == -1L) {
            throw new IOException("No mark()");
        }
        this.raFile.seek(this.markPos);
        this.updateProgress();
    }

    public long skip(long n) throws IOException {
        this.updateProgress();
        return this.raFile.skipBytes((int)n);
    }

    private void updateProgress() throws IOException {
        if (this.progress == null) {
            return;
        }
        double pos = (double)this.raFile.getFilePointer() / (double)this.raFile.length();
        this.progress.setProgress(pos, 1.0);
    }
}

