/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine;

import ch.tachyon.tunnel.engine.IdentityTransform;
import ch.tachyon.tunnel.engine.ProcessingInfoBridge;
import ch.tachyon.tunnel.engine.utils.DoubleConverter;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.effect.IParameter;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.param.IParameterTransform;
import ch.tachyon.tunnel.plugin.param.ParameterInfo;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import ch.tachyon.tunnel.plugin.param.Transform;
import ch.tachyon.tunnel.plugin.param.Unit;
import java.lang.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterInfoParameter<P extends IPlugin>
implements IParameter {
    private final P plugin;
    private final ParameterInfo<P> target;

    public ParameterInfoParameter(P plugin, ParameterInfo<P> target) {
        this.plugin = plugin;
        this.target = target;
    }

    @Override
    public String getName() {
        return this.target.getJavaName();
    }

    @Override
    public String getDisplayName() {
        return this.target.getDisplayName();
    }

    @Override
    public String getDescription() {
        Description description = this.target.getAnnotation(Description.class);
        if (description == null) {
            return null;
        }
        return description.value();
    }

    @Override
    public String getUnit() {
        Unit unit = this.target.getAnnotation(Unit.class);
        if (unit == null) {
            return null;
        }
        return unit.value();
    }

    @Override
    public IParameterTransform getTransform() {
        Transform transformAnno = this.target.getAnnotation(Transform.class);
        if (transformAnno != null) {
            try {
                return transformAnno.value().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Cannot instanciate " + transformAnno.value() + " specified by the @Transform annotation on parameter \"" + this.getDisplayName() + "\" of the plugin \"" + this.plugin.getClass().getName() + "\"", ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Cannot instanciate " + transformAnno.value() + " specified by the @Transform annotation on parameter \"" + this.getDisplayName() + "\" of the plugin \"" + this.plugin.getClass().getName() + "\"", ex);
            }
        }
        return IdentityTransform.getInstance();
    }

    @Override
    public Range getRange() {
        return this.target.getAnnotation(Range.class);
    }

    @Override
    public ScaleType getScaleType() {
        Scale scale = this.target.getAnnotation(Scale.class);
        if (scale != null) {
            return scale.value();
        }
        return ScaleType.LINEAR;
    }

    @Override
    public <E extends Annotation> E getAnnotation(Class<E> type) {
        return this.target.getAnnotation(type);
    }

    @Override
    public Class<?> getType() {
        return this.target.getType();
    }

    @Override
    public Object getValue(IProcessingInfo info) {
        Object value = this.getInternalValue();
        if (value instanceof Number) {
            value = this.getTransform().transform((Number)value, new ProcessingInfoBridge(info));
        }
        return value;
    }

    @Override
    public void setValue(Object value, IProcessingInfo info) {
        if (value instanceof Number) {
            value = this.getTransform().untransform((Number)value, new ProcessingInfoBridge(info));
        }
        this.setInternalValue(value);
    }

    @Override
    public Object getInternalValue() {
        return this.target.getValue(this.plugin);
    }

    @Override
    public void setInternalValue(Object value) {
        Class<?> type;
        double doubleValue;
        Range range = this.getRange();
        if (range != null && ((doubleValue = DoubleConverter.toDouble(value, type = this.getType())) < range.minValue() || doubleValue > range.maxValue())) {
            throw new IllegalArgumentException("Value out of range: " + value + "; " + "range: [" + DoubleConverter.fromDouble(range.minValue(), type) + " - " + DoubleConverter.fromDouble(range.maxValue(), type) + "]");
        }
        this.target.setValue(this.plugin, value);
    }
}

