/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges;

import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.engine.PluginToHostWrapper;
import ch.tachyon.tunnel.engine.utils.Rebufferizer;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.effect.ISingleChanEffect;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.ISimpleEffect;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScEffectFromScEffect
extends PluginToHostWrapper<ISimpleEffect>
implements ISingleChanEffect {
    private Rebufferizer rebufferizer = null;

    @Override
    public void init(IPlugin baseTarget, IPlugin processingTarget, IMtContext mtContext, Properties properties) {
        super.init(baseTarget, (ISimpleEffect)processingTarget, ISingleChanEffect.class, mtContext, properties);
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.rebufferizer = super.needsRebuffering(false) ? new Rebufferizer(this.getActualMaxChunkLength(info), this.getActualChunkLength()) : null;
    }

    @Override
    public int getLatency() {
        if (this.rebufferizer == null) {
            return super.getLatency(IoDirection.OUTPUT);
        }
        return super.getLatency(IoDirection.OUTPUT) + this.rebufferizer.getLatency();
    }

    @Override
    public void process(float[] samples0) {
        assert (super.isSane(samples0, true));
        this.beginIfWorth();
        float[] samples = this.wrapInput(samples0);
        if (this.rebufferizer == null) {
            ((ISimpleEffect)this.processingTarget).process(samples);
        } else {
            this.rebufferizer.submitVariable(samples);
            float[] fixed = this.rebufferizer.retrieveFixed();
            while (fixed != null) {
                ((ISimpleEffect)this.processingTarget).process(fixed);
                this.rebufferizer.submitFixed(fixed);
                fixed = this.rebufferizer.retrieveFixed();
            }
            this.rebufferizer.retrieveVariable(samples);
        }
        assert (super.isSane(samples, false));
        super.unwrapInput(samples, samples0);
        super.processed(samples0.length);
    }

    @Override
    public void stopProcessing() {
        super.stopProcessing();
        this.rebufferizer = null;
    }
}

