/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges;

import ch.tachyon.tunnel.common.ISingleChanAudioSource;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.engine.PluginToHostWrapper;
import ch.tachyon.tunnel.engine.utils.Rebufferizer;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.ProcessingInfo;
import ch.tachyon.tunnel.host.effect.ISingleChanPullEffect;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.ISimpleEffect;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import java.util.Arrays;
import java.util.Properties;
import javax.sound.sampled.AudioFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScPullFromScEffect
extends PluginToHostWrapper<ISimpleEffect>
implements ISingleChanPullEffect,
ISingleChanAudioSource {
    private Rebufferizer rebufferizer = null;
    private ISingleChanAudioSource curSource;
    private int maxChunkSize;
    private int headOutToSkip;
    private int tailInToPad;

    @Override
    public void init(IPlugin baseTarget, IPlugin processingTarget, IMtContext mtContext, Properties properties) {
        super.init(baseTarget, (ISimpleEffect)processingTarget, ISingleChanPullEffect.class, mtContext, properties);
    }

    @Override
    public boolean canWriteFasterThanRead() {
        return false;
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.maxChunkSize = this.getActualMaxChunkLength(info);
        this.rebufferizer = this.needsRebuffering() ? new Rebufferizer(this.maxChunkSize, this.getActualChunkLength()) : null;
        this.headOutToSkip = this.getFullLatency(IoDirection.OUTPUT);
        this.tailInToPad = this.getFullLatency(IoDirection.INPUT);
    }

    @Override
    protected boolean needsRebuffering() {
        if (super.needsRebuffering()) {
            return true;
        }
        return super.getLatency(IoDirection.INPUT) > 0 || super.getLatency(IoDirection.OUTPUT) > 0;
    }

    private int getFullLatency(IoDirection ioDirection) {
        if (this.rebufferizer == null) {
            return super.getLatency(ioDirection);
        }
        return super.getLatency(ioDirection) + this.rebufferizer.getLatency();
    }

    @Override
    public int process(ISingleChanAudioSource source, float[] output) {
        this.beginIfWorth();
        if (output.length > this.maxChunkSize) {
            throw new IllegalArgumentException("Host error: the given array length is greater than the maximum length specified by the IProcessingInfo object passed to startProcessing()");
        }
        this.curSource = source;
        while (this.headOutToSkip > 0) {
            int amount = Math.min(this.headOutToSkip, this.maxChunkSize);
            float[] temp = new float[amount];
            this.readSamples(temp);
            this.process0(temp);
            this.headOutToSkip -= amount;
        }
        int count = this.readSamples(output);
        this.process0(output);
        assert (this.isSane(output, false));
        super.processed(count);
        return count;
    }

    protected void process0(float[] output) {
        if (this.rebufferizer == null) {
            ((ISimpleEffect)this.processingTarget).process(output);
        } else {
            this.rebufferizer.submitVariable(output);
            float[] fixed = this.rebufferizer.retrieveFixed();
            while (fixed != null) {
                ((ISimpleEffect)this.processingTarget).process(fixed);
                this.rebufferizer.submitFixed(fixed);
                fixed = this.rebufferizer.retrieveFixed();
            }
            this.rebufferizer.retrieveVariable(output);
        }
    }

    @Override
    public int readSamples(float[] target) {
        int result = this.curSource.readSamples(target);
        if (result < target.length && this.tailInToPad > 0) {
            int amount = Math.min(target.length - result, this.tailInToPad);
            Arrays.fill(target, result, result + amount, 0.0f);
            this.tailInToPad -= amount;
            result += amount;
        }
        assert (this.isSane(target, true));
        return result;
    }

    @Override
    public AudioFormat getAudioFormat() {
        return ProcessingInfo.toAudioFormat(super.getHostInfo());
    }
}

