/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges;

import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.common.ISingleChanAudioSource;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.engine.PluginToHostWrapper;
import ch.tachyon.tunnel.engine.utils.FloatQueue;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.ProcessingInfo;
import ch.tachyon.tunnel.host.effect.ISingleChanPushEffect;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.IPullEffect;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.utils.Monitor;
import java.util.Properties;
import javax.sound.sampled.AudioFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScPushFromScPull
extends PluginToHostWrapper<IPullEffect>
implements ISingleChanPushEffect,
Runnable {
    private final ISingleChanAudioSource source = new AudioSource();
    private final Object lock = new Monitor("ScPushFromScPull");
    private int maxInputLength;
    private int outputLength;
    private int queueCapacity;
    private int headOutToSkip;
    private int tailInToPad;
    private FloatQueue queue;
    private ISingleChanAudioSink sink;
    private Thread pusher;
    private long nbPushed;
    private long nbPolled;

    @Override
    public void init(IPlugin baseTarget, IPlugin processingTarget, IMtContext mtContext, Properties properties) {
        super.init(baseTarget, (IPullEffect)processingTarget, ISingleChanPushEffect.class, mtContext, properties);
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.queue = null;
        this.sink = null;
        this.nbPushed = 0L;
        this.nbPolled = 0L;
        this.outputLength = this.getPreferredChunkLength();
        this.maxInputLength = info.getMaxChunkLength(this.outputLength);
        if (this.outputLength < 0) {
            this.outputLength = info.negociateFixedChunkLength(this.outputLength);
        }
        if (this.outputLength < 0) {
            this.outputLength = 8192;
        }
        this.queueCapacity = this.maxInputLength + this.outputLength;
        this.headOutToSkip = super.getLatency(IoDirection.OUTPUT);
        this.tailInToPad = super.getLatency(IoDirection.INPUT);
        this.pusher = new Thread(this);
        this.pusher.setName(String.valueOf(this.getName()) + "-Pusher");
        this.pusher.start();
    }

    @Override
    public boolean canWriteFasterThanRead() {
        return ((IPullEffect)this.processingTarget).canWriteFasterThanRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(float[] samples, int length, ISingleChanAudioSink sink) {
        this.beginIfWorth();
        if (length > this.maxInputLength) {
            throw new IllegalArgumentException("Host error: the given length is greater than the maximum length specified by the IProcessingInfo object passed to startProcessing()");
        }
        assert (super.isSane(samples, true));
        Object object = this.lock;
        synchronized (object) {
            if (this.queue == null) {
                this.queue = new FloatQueue(this.queueCapacity);
            }
            while (this.queue.getSize() + length > this.queueCapacity) {
                this.waitLock();
            }
            this.queue.pushArray(samples, length);
            this.sink = sink;
            this.nbPushed += (long)length;
            this.lock.notify();
        }
        if (length < samples.length) {
            this.finishProcessing(sink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void finishProcessing(ISingleChanAudioSink sink) {
        float[] zero = new float[Math.min(this.maxInputLength, this.outputLength)];
        Object object = this.lock;
        synchronized (object) {
            block3: while (true) {
                if (this.pusher == null) {
                    return;
                }
                do {
                    if (this.queue.getSize() + zero.length <= this.queueCapacity) {
                        this.queue.pushArray(zero);
                        if (this.tailInToPad > 0) {
                            int padAmount = Math.min(zero.length, this.tailInToPad);
                            this.nbPushed += (long)padAmount;
                            this.tailInToPad -= padAmount;
                        }
                        this.lock.notify();
                        continue block3;
                    }
                    this.waitLock();
                } while (this.pusher != null);
                break;
            }
            return;
        }
    }

    @Override
    public void stopProcessing() {
        this.finishProcessing(new ISingleChanAudioSink(){

            public void writeSamples(float[] samples) {
            }
        });
        super.stopProcessing();
        this.queue = null;
        this.sink = null;
        this.pusher = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int count;
        Object object = this.lock;
        synchronized (object) {
            while (this.nbPushed == 0L) {
                this.waitLock();
            }
        }
        float[] buffer = new float[this.outputLength];
        do {
            if ((count = ((IPullEffect)this.processingTarget).process(this.source, buffer)) == buffer.length) {
                this.writeSamples(this.sink, buffer);
                continue;
            }
            if (count <= 0) continue;
            float[] temp = new float[count];
            System.arraycopy(buffer, 0, temp, 0, count);
            this.writeSamples(this.sink, temp);
        } while (count >= buffer.length);
        Object object2 = this.lock;
        synchronized (object2) {
            this.pusher = null;
            this.lock.notify();
        }
    }

    public void writeSamples(ISingleChanAudioSink sink, float[] samples) {
        assert (super.isSane(samples, false));
        int amount = samples.length;
        if (this.headOutToSkip >= amount) {
            this.headOutToSkip -= amount;
        } else if (this.headOutToSkip > 0) {
            float[] head = new float[amount - this.headOutToSkip];
            System.arraycopy(samples, this.headOutToSkip, head, 0, head.length);
            sink.writeSamples(head);
            this.headOutToSkip = 0;
        } else {
            sink.writeSamples(samples);
        }
    }

    void waitLock() {
        try {
            this.lock.wait();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    class AudioSource
    implements ISingleChanAudioSource {
        AudioSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int readSamples(float[] target) {
            Object object = ScPushFromScPull.this.lock;
            synchronized (object) {
                int offset = 0;
                int remaining = target.length;
                while (remaining > 0) {
                    int amount = Math.min(ScPushFromScPull.this.maxInputLength, remaining);
                    while (ScPushFromScPull.this.queue.getSize() < amount) {
                        ScPushFromScPull.this.waitLock();
                    }
                    ScPushFromScPull.this.queue.popArray(target, offset, amount);
                    ScPushFromScPull scPushFromScPull = ScPushFromScPull.this;
                    scPushFromScPull.nbPolled = scPushFromScPull.nbPolled + (long)amount;
                    ScPushFromScPull.this.lock.notify();
                    remaining -= amount;
                    offset += amount;
                }
                int result = target.length;
                if (ScPushFromScPull.this.nbPolled > ScPushFromScPull.this.nbPushed) {
                    result = Math.max(0, result - (int)(ScPushFromScPull.this.nbPolled - ScPushFromScPull.this.nbPushed));
                }
                ScPushFromScPull.super.processed(result);
                return result;
            }
        }

        public AudioFormat getAudioFormat() {
            return ProcessingInfo.toAudioFormat(ScPushFromScPull.super.getHostInfo());
        }
    }
}

