/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.chan;

import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.common.ISingleChanAudioSource;
import ch.tachyon.tunnel.engine.bridges.chan.McFromScBase;
import ch.tachyon.tunnel.engine.utils.concurrent.Task;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.effect.IEffect;
import ch.tachyon.tunnel.host.effect.IPullEffect;
import ch.tachyon.tunnel.host.effect.ISingleChanPullEffect;
import ch.tachyon.tunnel.utils.Monitor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import javax.sound.sampled.AudioFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class McPullFromScPull
extends McFromScBase<IPullEffect, ISingleChanPullEffect>
implements IPullEffect {
    private List<Queue<float[]>> inputs;
    private int[] offsets;
    private ProcessOneChanTask[][] tasks;
    private CollectingSource[] sources;
    private volatile IMultiChanAudioSource mcSource;
    private final Object processLock = new Monitor("McPullFromScPull#process");
    private Queue<float[]> freePool;
    private transient float[][] block;
    private transient float[][][] work;
    private transient int curBuffer = 0;
    private transient CountDownLatch latch;

    @Override
    public Class<? extends IEffect> getInterface() {
        return IPullEffect.class;
    }

    @Override
    public boolean canWriteFasterThanRead() {
        return ((ISingleChanPullEffect)this.descTarget).canWriteFasterThanRead();
    }

    void fetchNextInputBlock(int suggestedLength) {
        int chan = 0;
        while (chan < this.nbChans) {
            float[] chanBlock = this.freePool.poll();
            if (chanBlock == null || chanBlock.length != suggestedLength) {
                chanBlock = new float[suggestedLength];
            }
            this.block[chan] = chanBlock;
            ++chan;
        }
        int read = this.mcSource.readSamples(this.block);
        if (read == 0) {
            return;
        }
        if (read < suggestedLength) {
            float[][] tail = new float[this.nbChans][read];
            int chan2 = 0;
            while (chan2 < this.nbChans) {
                System.arraycopy(this.block[chan2], 0, tail[chan2], 0, read);
                ++chan2;
            }
            this.block = tail;
        }
        super.preProcessMidSide(this.block);
        int chan3 = 0;
        while (chan3 < this.nbChans) {
            this.inputs.get(chan3).add(this.block[chan3]);
            ++chan3;
        }
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.sources = new CollectingSource[this.nbChans];
        this.tasks = new ProcessOneChanTask[2][this.nbChans];
        this.inputs = new ArrayList<Queue<float[]>>(this.nbChans);
        this.offsets = new int[this.nbChans];
        AudioFormat format = new AudioFormat(info.getSampleRate(), info.getQuantization(), this.nbChans, true, false);
        int chan = 0;
        while (chan < this.nbChans) {
            this.sources[chan] = new CollectingSource(format, chan);
            this.tasks[0][chan] = new ProcessOneChanTask(chan);
            this.tasks[1][chan] = new ProcessOneChanTask(chan);
            this.inputs.add(new LinkedList());
            ++chan;
        }
        if (this.pool != null) {
            this.work = new float[2][][];
        }
        this.freePool = new ConcurrentLinkedQueue<float[]>();
        this.block = new float[this.nbChans][];
    }

    @Override
    public int process(IMultiChanAudioSource source, float[][] output) {
        if (output.length != this.nbChans) {
            throw new IllegalArgumentException("Wrong number of channels. Found output.length = " + output.length + ", expected: " + this.nbChans);
        }
        assert (this.targets.size() == this.nbChans);
        this.mcSource = source;
        int result = 0;
        if (this.pool != null) {
            int nbBuffers = this.latch == null ? 2 : 1;
            int k = 0;
            while (k < nbBuffers) {
                if (this.work[this.curBuffer] == null || this.work[this.curBuffer].length != output.length || this.work[this.curBuffer][0].length != output[0].length) {
                    this.work[this.curBuffer] = new float[output.length][output[0].length];
                }
                int chan = 0;
                while (chan < this.nbChans) {
                    this.tasks[this.curBuffer][chan].setup(this.work[this.curBuffer][chan]);
                    ++chan;
                }
                if (this.latch != null) {
                    McPullFromScPull.await(this.latch);
                }
                this.latch = this.pool.submit(this.tasks[this.curBuffer]);
                this.curBuffer = 1 - this.curBuffer;
                ++k;
            }
            int chan = 0;
            while (chan < this.nbChans) {
                int r = this.tasks[this.curBuffer][chan].getResult();
                if (chan == 0) {
                    result = r;
                } else if (result != r) {
                    throw new IllegalStateException("Plugin " + ((ISingleChanPullEffect)this.descTarget).getClassName() + " returned an inconsistent number of samples accross channels." + " Channel 0 returned " + result + " samples and channel " + chan + " returned " + r + " samples");
                }
                ++chan;
            }
            if (result > 0) {
                chan = 0;
                while (chan < this.nbChans) {
                    System.arraycopy(this.work[this.curBuffer][chan], 0, output[chan], 0, result);
                    ++chan;
                }
            }
        } else {
            int chan = 0;
            while (chan < this.nbChans) {
                int r = ((ISingleChanPullEffect)this.targets.get(chan)).process(this.sources[chan], output[chan]);
                if (chan == 0) {
                    result = r;
                } else if (result != r) {
                    throw new IllegalStateException("Plugin " + ((ISingleChanPullEffect)this.descTarget).getClassName() + " returned an inconsistent number of samples accross channels." + " Channel 0 returned " + result + " samples and channel " + chan + " returned " + r + " samples");
                }
                ++chan;
            }
        }
        super.postProcessMidSide(output);
        return result;
    }

    static void await(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void stopProcessing() {
        if (this.latch != null) {
            McPullFromScPull.await(this.latch);
        }
        super.stopProcessing();
        this.inputs = null;
        this.sources = null;
        this.tasks = null;
        this.offsets = null;
        this.work = null;
        this.curBuffer = 0;
        this.latch = null;
        this.freePool = null;
        this.block = null;
    }

    class CollectingSource
    implements ISingleChanAudioSource {
        private final AudioFormat format;
        private final int chan;

        public CollectingSource(AudioFormat format, int chan) {
            this.format = format;
            this.chan = chan;
        }

        public AudioFormat getAudioFormat() {
            return this.format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int readSamples(float[] target) {
            int remaining = target.length;
            int result = 0;
            Object object = McPullFromScPull.this.processLock;
            synchronized (object) {
                while (remaining > 0) {
                    if (((Queue)McPullFromScPull.this.inputs.get(this.chan)).isEmpty()) {
                        McPullFromScPull.this.fetchNextInputBlock(remaining);
                    }
                    if (((Queue)McPullFromScPull.this.inputs.get(this.chan)).isEmpty()) {
                        return result;
                    }
                    float[] block = (float[])((Queue)McPullFromScPull.this.inputs.get(this.chan)).peek();
                    int amount = Math.min(remaining, block.length - McPullFromScPull.this.offsets[this.chan]);
                    System.arraycopy(block, McPullFromScPull.this.offsets[this.chan], target, result, amount);
                    remaining -= amount;
                    result += amount;
                    int[] nArray = McPullFromScPull.this.offsets;
                    int n = this.chan;
                    nArray[n] = nArray[n] + amount;
                    if (McPullFromScPull.this.offsets[this.chan] < block.length) continue;
                    assert (McPullFromScPull.this.offsets[this.chan] == block.length);
                    float[] toFree = (float[])((Queue)McPullFromScPull.this.inputs.get(this.chan)).remove();
                    McPullFromScPull.this.freePool.add(toFree);
                    ((McPullFromScPull)McPullFromScPull.this).offsets[this.chan] = 0;
                }
            }
            return result;
        }
    }

    class ProcessOneChanTask
    extends Task {
        private final int chan;
        private float[] output;
        private int result;

        public ProcessOneChanTask(int chan) {
            this.chan = chan;
        }

        void setup(float[] output) {
            this.output = output;
        }

        public int getResult() {
            return this.result;
        }

        public void run() {
            this.result = ((ISingleChanPullEffect)McPullFromScPull.this.targets.get(this.chan)).process(McPullFromScPull.this.sources[this.chan], this.output);
        }
    }
}

