/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.chan;

import ch.tachyon.tunnel.common.IMultiChanAudioSink;
import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.engine.bridges.chan.McFromScBase;
import ch.tachyon.tunnel.engine.utils.concurrent.Task;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.effect.IEffect;
import ch.tachyon.tunnel.host.effect.IPushEffect;
import ch.tachyon.tunnel.host.effect.ISingleChanPushEffect;
import ch.tachyon.tunnel.utils.Monitor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class McPushFromScPush
extends McFromScBase<IPushEffect, ISingleChanPushEffect>
implements IPushEffect {
    private List<Queue<float[]>> outputs;
    private int[] offsets;
    private ProcessOnChanTask[][] tasks;
    private CollectingSink[] sinks;
    private volatile IMultiChanAudioSink mcSink;
    private final Object processLock = new Monitor("McPushFromScPush#process");
    private final AtomicReference<RuntimeException> exRef = new AtomicReference();
    private Queue<float[]> freePool;
    private transient float[][] nextBlock;
    private transient float[][] dequeued;
    private transient float[][][] work;
    private transient int curBuffer = 0;
    private transient CountDownLatch latch;

    @Override
    public Class<? extends IEffect> getInterface() {
        return IPushEffect.class;
    }

    @Override
    public boolean canWriteFasterThanRead() {
        return ((ISingleChanPushEffect)this.descTarget).canWriteFasterThanRead();
    }

    void transmitNewlyAvailableFrames() {
        int available;
        do {
            float[] current;
            Queue<float[]> chanQueue;
            available = Integer.MAX_VALUE;
            int chan = 0;
            while (chan < this.nbChans) {
                chanQueue = this.outputs.get(chan);
                if (chanQueue.isEmpty()) {
                    available = 0;
                } else {
                    current = chanQueue.peek();
                    available = Math.min(available, current.length - this.offsets[chan]);
                }
                ++chan;
            }
            if (available <= 0) continue;
            chan = 0;
            while (chan < this.nbChans) {
                chanQueue = this.outputs.get(chan);
                current = chanQueue.peek();
                this.dequeued[chan] = null;
                if (this.offsets[chan] == 0 && current.length == available) {
                    this.nextBlock[chan] = current;
                } else {
                    this.nextBlock[chan] = new float[available];
                    System.arraycopy(current, this.offsets[chan], this.nextBlock[chan], 0, available);
                }
                int n = chan;
                this.offsets[n] = this.offsets[n] + available;
                if (this.offsets[chan] >= current.length) {
                    assert (this.offsets[chan] == current.length);
                    this.dequeued[chan] = chanQueue.remove();
                    this.offsets[chan] = 0;
                }
                ++chan;
            }
            super.postProcessMidSide(this.nextBlock);
            this.mcSink.writeSamples(this.nextBlock);
            chan = 0;
            while (chan < this.nbChans) {
                if (this.dequeued[chan] != null && this.dequeued[chan] != this.nextBlock[chan]) {
                    this.freePool.add(this.dequeued[chan]);
                }
                ++chan;
            }
        } while (available > 0);
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.sinks = new CollectingSink[this.nbChans];
        this.tasks = new ProcessOnChanTask[2][this.nbChans];
        this.outputs = new ArrayList<Queue<float[]>>(this.nbChans);
        this.freePool = new ConcurrentLinkedQueue<float[]>();
        this.offsets = new int[this.nbChans];
        int chan = 0;
        while (chan < this.nbChans) {
            this.sinks[chan] = new CollectingSink(chan);
            this.tasks[0][chan] = new ProcessOnChanTask(chan);
            this.tasks[1][chan] = new ProcessOnChanTask(chan);
            this.outputs.add(new LinkedList());
            ++chan;
        }
        if (this.pool != null) {
            this.work = new float[2][][];
        }
        this.nextBlock = new float[this.nbChans][];
        this.dequeued = new float[this.nbChans][];
    }

    @Override
    public void process(float[][] input, int length, IMultiChanAudioSink mcSink) {
        if (input.length != this.nbChans) {
            throw new IllegalArgumentException("Wrong number of channels. Found input.length = " + input.length + ", excpected: " + this.nbChans);
        }
        assert (this.targets.size() == this.nbChans);
        this.mcSink = mcSink;
        super.preProcessMidSide(input);
        if (this.pool != null) {
            if (this.work[this.curBuffer] == null || this.work[this.curBuffer].length != input.length || this.work[this.curBuffer][0].length != input[0].length) {
                this.work[this.curBuffer] = new float[input.length][input[0].length];
            }
            int chan = 0;
            while (chan < this.nbChans) {
                System.arraycopy(input[chan], 0, this.work[this.curBuffer][chan], 0, length);
                this.tasks[this.curBuffer][chan].setup(this.work[this.curBuffer][chan], length);
                ++chan;
            }
            if (this.latch != null) {
                McPushFromScPush.await(this.latch);
            }
            this.latch = this.pool.submit(this.tasks[this.curBuffer]);
            if (length < input[0].length) {
                McPushFromScPush.await(this.latch);
                this.latch = null;
            }
            this.curBuffer = 1 - this.curBuffer;
            RuntimeException ex = this.exRef.getAndSet(null);
            if (ex != null) {
                throw ex;
            }
        } else {
            int chan = 0;
            while (chan < this.nbChans) {
                ((ISingleChanPushEffect)this.targets.get(chan)).process(input[chan], length, this.sinks[chan]);
                ++chan;
            }
        }
    }

    static void await(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void stopProcessing() {
        if (this.latch != null) {
            McPushFromScPush.await(this.latch);
        }
        super.stopProcessing();
        this.outputs = null;
        this.tasks = null;
        this.sinks = null;
        this.work = null;
        this.curBuffer = 0;
        this.latch = null;
        this.freePool = null;
        this.nextBlock = null;
        this.dequeued = null;
    }

    class CollectingSink
    implements ISingleChanAudioSink {
        private final int chan;

        public CollectingSink(int chan) {
            this.chan = chan;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeSamples(float[] samples) {
            float[] copy = (float[])McPushFromScPush.this.freePool.poll();
            if (copy == null || copy.length != samples.length) {
                copy = new float[samples.length];
            }
            System.arraycopy(samples, 0, copy, 0, samples.length);
            Object object = McPushFromScPush.this.processLock;
            synchronized (object) {
                Queue queue = (Queue)McPushFromScPush.this.outputs.get(this.chan);
                queue.add(copy);
                try {
                    McPushFromScPush.this.transmitNewlyAvailableFrames();
                }
                catch (RuntimeException ex) {
                    McPushFromScPush.this.exRef.compareAndSet(null, ex);
                }
            }
        }
    }

    class ProcessOnChanTask
    extends Task {
        private final int chan;
        private float[] input;
        private int length;

        public ProcessOnChanTask(int chan) {
            this.chan = chan;
        }

        void setup(float[] input, int length) {
            this.input = input;
            this.length = length;
        }

        public void run() {
            ((ISingleChanPushEffect)McPushFromScPush.this.targets.get(this.chan)).process(this.input, this.length, McPushFromScPush.this.sinks[this.chan]);
        }
    }
}

