/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread;

import ch.tachyon.tunnel.engine.ProcessingInfoBridge;
import ch.tachyon.tunnel.engine.bridges.chan.IChanPartInfo;
import ch.tachyon.tunnel.engine.bridges.mthread.IProcessedFramesMonitor;
import ch.tachyon.tunnel.engine.bridges.mthread.MtContext;
import ch.tachyon.tunnel.engine.bridges.mthread.SerialSectionPool;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.DebugSerialSection;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.ISerialSectionExt;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.ISerialSectionHandler;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.ProfiledSerialSection;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.SerialSectionImpl;
import ch.tachyon.tunnel.engine.utils.ConcurrentHistoryBuffer;
import ch.tachyon.tunnel.engine.utils.PluginDuplicator;
import ch.tachyon.tunnel.engine.utils.concurrent.ThreadPool;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.ILoadUnload;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ITimeLocal;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.utils.Debug;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MtBase<E extends IPlugin>
implements IPlugin,
IStartStop,
IBeginProcessing,
ISerialSectionHandler,
IProcessedFramesMonitor {
    private static final int DEFAULT_CHUNK_LENGTH = 2048;
    public static final String DEBUG_PROPERTY = "ch.tachyon.tunnel.debug";
    public static final String PROFILE_PROPERTY = "ch.tachyon.tunnel.profile";
    private static final String READ_SECTION_NAME = "ch.tachyon.tunnel.engine.source.reader";
    private static final String WRITE_SECTION_NAME = "ch.tachyon.tunnel.engine.sink.writer";
    private static final String HISTORY_SECTION_NAME = "ch.tachyon.tunnel.engine.history";
    private final E target;
    private final boolean needsReadSection;
    protected final MtContext mtContext;
    private final Map<Thread, E> pool = new ConcurrentHashMap<Thread, E>(8, 0.75f, 1);
    private int poolSize;
    private int minInputPoolSize = 0;
    protected ThreadPool threadPool;
    protected ISerialSectionExt[] serialSections;
    protected ISerialSectionExt readSection;
    protected ISerialSectionExt writeSection;
    protected int historySize;
    protected int pluginFixedSize;
    protected ConcurrentHistoryBuffer historyBuffer;
    protected ISerialSection historySection;
    protected boolean serialize;
    protected AtomicLong framesCounter;

    static {
        if (System.getProperty(DEBUG_PROPERTY) != null && !System.getProperty(DEBUG_PROPERTY).equalsIgnoreCase("false")) {
            Debug.warn("Debug mode enabled", new Object[0]);
        }
    }

    protected MtBase(E target, boolean needsReadSection, MtContext mtContext) {
        this.target = target;
        this.needsReadSection = needsReadSection;
        this.mtContext = mtContext;
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        this.setupPool(this.target, info);
    }

    private ISerialSectionExt newSerialSection(String name, Object userData) {
        if (System.getProperty(DEBUG_PROPERTY) != null && !System.getProperty(DEBUG_PROPERTY).equalsIgnoreCase("false")) {
            return new DebugSerialSection(this.threadPool, name, userData);
        }
        if (System.getProperty(PROFILE_PROPERTY) != null && !System.getProperty(PROFILE_PROPERTY).equalsIgnoreCase("false")) {
            return new ProfiledSerialSection(this.threadPool, name, userData);
        }
        return new SerialSectionImpl(this.threadPool, name, userData);
    }

    private void setupPool(E plugin, final IProcessingInfo info) {
        final SerialSectionPool ssPool = new SerialSectionPool(info, this.mtContext);
        int chanDiv = 1;
        if (info instanceof IChanPartInfo) {
            chanDiv = ((IChanPartInfo)((Object)info)).getTotalNbChannels() / info.getNumberOfChannels();
        }
        this.threadPool = this.mtContext.setupPool(this, chanDiv);
        if (this.needsReadSection) {
            this.readSection = this.newSerialSection(READ_SECTION_NAME, null);
            ssPool.addSerialSection(READ_SECTION_NAME, this.readSection);
        }
        this.historySize = 0;
        this.serialize = false;
        Set<Thread> threads = this.threadPool.getPoolThreads();
        int index = 0;
        for (Thread thread : threads) {
            E poolPlugin;
            if (index == 0) {
                poolPlugin = plugin;
                if (plugin instanceof IStartStop) {
                    ((IStartStop)plugin).startProcessing(info);
                }
                if (plugin instanceof ITimeLocal) {
                    this.pluginFixedSize = this.getFixedChunkLength();
                    int pluginChunkSize = this.getActualChunkLength();
                    int hostChunkLength = info.getMaxChunkLength(pluginChunkSize);
                    ITimeLocal tl = (ITimeLocal)plugin;
                    int historySize = tl.getRequiredFramesBefore(info);
                    if (historySize != 0) {
                        boolean isWorthParallelizing;
                        if (this.pluginFixedSize > 0) {
                            isWorthParallelizing = historySize > 0 && this.pluginFixedSize * 11 / 10 < (this.pluginFixedSize - historySize) * this.threadPool.getPoolSize();
                        } else {
                            boolean bl = isWorthParallelizing = historySize > 0 && (historySize + hostChunkLength) * 11 / 10 < hostChunkLength * this.threadPool.getPoolSize();
                        }
                        if (isWorthParallelizing) {
                            int historyCapacity = historySize + hostChunkLength;
                            this.historyBuffer = new ConcurrentHistoryBuffer(historyCapacity, historyCapacity + pluginChunkSize * this.mtContext.getSerialRunningMaxSkew());
                            this.historySection = this.newSerialSection(HISTORY_SECTION_NAME, this.historyBuffer);
                            ssPool.addSerialSection(HISTORY_SECTION_NAME, this.historySection);
                            this.historySize = historySize;
                            ((ProcessingInfoBridge)info).setTimeLocal(historySize);
                        } else {
                            this.serialize = true;
                            this.historySize = 0;
                        }
                    }
                }
                if (plugin instanceof IHasSerialSections) {
                    ((IHasSerialSections)plugin).createSerialSections(new ISerialSectionFactory(){

                        public ISerialSection createSerialSection(String name, Object userData) {
                            ISerialSectionExt ss = MtBase.this.newSerialSection(name, userData);
                            ssPool.addSerialSection(name, ss);
                            return ss;
                        }

                        public void ensureMinInputHistorySize(int value) {
                            MtBase.this.minInputPoolSize = Math.max(MtBase.this.minInputPoolSize, value);
                        }

                        public IProcessingInfo getProcessingInfo() {
                            return info;
                        }

                        public IMtContext getMtContext() {
                            return MtBase.this.mtContext;
                        }
                    });
                }
                if (this.serialize) {
                    break;
                }
            } else {
                poolPlugin = PluginDuplicator.prepareCopy(plugin, info);
                if (poolPlugin instanceof IStartStop && !(poolPlugin instanceof Cloneable)) {
                    ((IStartStop)poolPlugin).startProcessing(info);
                }
                ssPool.setThreadIndex(index);
                if (poolPlugin instanceof IHasSerialSections) {
                    ((IHasSerialSections)poolPlugin).setSerialSections(ssPool);
                }
            }
            this.pool.put(thread, poolPlugin);
            ++index;
        }
        this.writeSection = this.newSerialSection(WRITE_SECTION_NAME, null);
        ssPool.addSerialSection(WRITE_SECTION_NAME, this.writeSection);
        this.serialSections = ssPool.getSerialSections().toArray(new ISerialSectionExt[ssPool.getNbSerialSections()]);
        this.poolSize = this.pool.size();
    }

    protected int getInputPoolSize() {
        return this.mtContext.getSerialTotalMaxSkew() + this.minInputPoolSize;
    }

    protected E getBaseTarget() {
        return this.target;
    }

    public int getFixedChunkLength() {
        if (this.target instanceof IFixedChunkLength) {
            return ((IFixedChunkLength)this.target).getFixedChunkLength();
        }
        return -1;
    }

    protected int getActualChunkLength() {
        int result = this.getFixedChunkLength();
        if (result < 0) {
            result = 2048;
        }
        return result;
    }

    protected E getProcessingTarget(Thread thread) {
        if (this.poolSize == 1) {
            return this.target;
        }
        return (E)((IPlugin)this.pool.get(thread));
    }

    @Override
    public void setCounter(AtomicLong framesCounter) {
        this.framesCounter = framesCounter;
    }

    public boolean isParallelized() {
        return !this.serialize;
    }

    @Override
    public void beginProcessing(final IProcessingInfo info) {
        if (this.serialize) {
            if (this.target instanceof IBeginProcessing) {
                ((IBeginProcessing)this.target).beginProcessing(info);
            }
        } else {
            this.threadPool.executeByEachThread(new Runnable(){

                public void run() {
                    Object plugin = MtBase.this.getProcessingTarget(Thread.currentThread());
                    if (plugin instanceof IBeginProcessing) {
                        ((IBeginProcessing)plugin).beginProcessing(info);
                    }
                }
            });
        }
    }

    @Override
    public void stopProcessing() {
        this.flushPool(this.target);
        this.threadPool.executeByEachThread(new Runnable(){

            public void run() {
                ISerialSectionExt[] iSerialSectionExtArray = MtBase.this.serialSections;
                int n = MtBase.this.serialSections.length;
                int n2 = 0;
                while (n2 < n) {
                    ISerialSectionExt serialSection = iSerialSectionExtArray[n2];
                    serialSection.clearClock();
                    ++n2;
                }
            }
        });
        this.mtContext.releasePool(this);
        this.threadPool = null;
    }

    private void flushPool(E main) {
        if (this.serialize) {
            if (main instanceof IStartStop) {
                ((IStartStop)main).stopProcessing();
            }
        } else {
            this.threadPool.waitForCurrentlyQueuedTasks();
            this.threadPool.executeByEachThread(new Runnable(){

                public void run() {
                    IPlugin plugin = (IPlugin)MtBase.this.pool.get(Thread.currentThread());
                    if (plugin instanceof IStartStop) {
                        ((IStartStop)((Object)plugin)).stopProcessing();
                    }
                }
            });
        }
        for (IPlugin plugin : this.pool.values()) {
            if (plugin == main || !(plugin instanceof ILoadUnload)) continue;
            ((ILoadUnload)((Object)plugin)).unload();
        }
        this.pool.clear();
    }
}

