/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread;

import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.engine.bridges.mthread.ClockedAsynchronousQueue;
import ch.tachyon.tunnel.engine.bridges.mthread.MtBase;
import ch.tachyon.tunnel.engine.bridges.mthread.MtContext;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.ISerialSectionExt;
import ch.tachyon.tunnel.engine.utils.concurrent.Task;
import ch.tachyon.tunnel.plugin.IMultiChanPullEffect;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import java.util.concurrent.atomic.AtomicLong;
import javax.sound.sampled.AudioFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MtMcPull
extends MtBase<IMultiChanPullEffect>
implements IMultiChanPullEffect,
IMultiChanAudioSource {
    volatile boolean active = false;
    boolean started = false;
    private IMultiChanAudioSource source;
    private int nbChans;
    private int length;
    private SourceTask[] taskSources;
    private float[][][] buffers;
    private int taskIndex;
    ClockedAsynchronousQueue<float[][]> queue;
    private AtomicLong producerClock = new AtomicLong();
    private long consumerClock;
    private float[][] curBuffer;
    private int srcIndex;

    public MtMcPull(IMultiChanPullEffect target, MtContext mtContext) {
        super(target, true, mtContext);
        if (!mtContext.isMultiCore()) {
            throw new IllegalStateException("MtScPull not supported when only one CPU core is used");
        }
    }

    @Override
    public boolean canWriteFasterThanRead() {
        return ((IMultiChanPullEffect)this.getBaseTarget()).canWriteFasterThanRead();
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        int capacity = this.mtContext.getSerialRunningMaxSkew();
        this.queue = new ClockedAsynchronousQueue(capacity);
        this.curBuffer = null;
        this.srcIndex = 0;
        this.producerClock.set(0L);
        this.consumerClock = 0L;
        this.length = -1;
        this.nbChans = -1;
        if (this.getBaseTarget() instanceof IFixedChunkLength) {
            this.length = ((IFixedChunkLength)this.getBaseTarget()).getFixedChunkLength();
        }
        this.active = true;
        this.started = false;
        this.taskSources = new SourceTask[super.getInputPoolSize() + 1];
        int i = 0;
        while (i < this.taskSources.length) {
            this.taskSources[i] = new SourceTask();
            ++i;
        }
        this.taskIndex = 0;
    }

    @Override
    public int process(IMultiChanAudioSource source, float[][] output) {
        this.source = source;
        if (!this.started && this.active) {
            this.started = true;
            if (this.nbChans <= 0) {
                this.nbChans = output.length;
            }
            if (this.length <= 0) {
                this.length = output[0].length;
            }
            this.buffers = new float[this.taskSources.length][this.nbChans][this.length];
            this.threadPool.addTaskFactory(new Task(){

                public void run() {
                    if (MtMcPull.this.active) {
                        MtMcPull.this.submitNextTask();
                    } else {
                        MtMcPull.this.threadPool.removeSelfTaskFactory();
                    }
                }
            });
        }
        int dstIndex = 0;
        while (dstIndex < output[0].length) {
            int amount;
            if (this.curBuffer == null || this.srcIndex >= this.curBuffer[0].length) {
                if (this.curBuffer != null && this.curBuffer[0].length < this.length) {
                    while (this.consumerClock < this.producerClock.get()) {
                        float[][] end = this.queue.take(this.consumerClock++);
                        assert (end[0].length == 0) : "Buffer of length " + end[0].length + " received after EOF";
                    }
                    break;
                }
                this.curBuffer = this.queue.take(this.consumerClock++);
                this.srcIndex = 0;
            }
            if ((amount = Math.min(output[0].length - dstIndex, this.curBuffer[0].length - this.srcIndex)) > 0) {
                int chan = 0;
                while (chan < this.nbChans) {
                    System.arraycopy(this.curBuffer[chan], this.srcIndex, output[chan], dstIndex, amount);
                    ++chan;
                }
            }
            this.srcIndex += amount;
            dstIndex += amount;
        }
        return dstIndex;
    }

    @Override
    public AudioFormat getAudioFormat() {
        return this.source.getAudioFormat();
    }

    private void submitNextTask() {
        SourceTask task = this.taskSources[this.taskIndex];
        float[][] buffer = this.buffers[this.taskIndex];
        task.init(this.producerClock.getAndIncrement(), buffer);
        this.taskIndex = (this.taskIndex + 1) % this.taskSources.length;
        this.threadPool.submitAsync(task);
    }

    @Override
    public void stopProcessing() {
        this.active = false;
        this.queue.dispose();
        super.stopProcessing();
        this.source = null;
        this.queue = null;
        this.curBuffer = null;
        this.taskSources = null;
        this.buffers = null;
    }

    @Override
    public int readSamples(float[][] target) {
        this.readSection.enterSerialSection();
        try {
            if (!this.active) {
                return 0;
            }
            int result = this.source.readSamples(target);
            if (result < target[0].length) {
                this.active = false;
            }
            int n = result;
            return n;
        }
        finally {
            this.readSection.leaveSerialSection();
        }
    }

    class SourceTask
    extends Task {
        private long taskClock;
        private float[][] output;

        SourceTask() {
        }

        void init(long taskClock, float[][] buffer) {
            this.taskClock = taskClock;
            this.output = buffer;
        }

        public void run() {
            ISerialSectionExt serialSection;
            ISerialSectionExt[] iSerialSectionExtArray = MtMcPull.this.serialSections;
            int n = MtMcPull.this.serialSections.length;
            int n2 = 0;
            while (n2 < n) {
                serialSection = iSerialSectionExtArray[n2];
                serialSection.setActive(true);
                serialSection.setClock(this.taskClock);
                ++n2;
            }
            if (MtMcPull.this.active) {
                IMultiChanPullEffect plugin = (IMultiChanPullEffect)MtMcPull.super.getProcessingTarget(Thread.currentThread());
                int amount = plugin.process(MtMcPull.this, this.output);
                if (amount < this.output[0].length) {
                    float[][] tmp = this.output;
                    this.output = new float[MtMcPull.this.nbChans][amount];
                    int chan = 0;
                    while (chan < MtMcPull.this.nbChans) {
                        System.arraycopy(tmp[chan], 0, this.output[chan], 0, amount);
                        ++chan;
                    }
                }
                MtMcPull.this.queue.put(this.taskClock, this.output);
                MtMcPull.this.framesCounter.addAndGet(amount);
            } else {
                MtMcPull.this.queue.put(this.taskClock, new float[MtMcPull.this.nbChans][0]);
            }
            MtMcPull.this.writeSection.sync();
            iSerialSectionExtArray = MtMcPull.this.serialSections;
            n = MtMcPull.this.serialSections.length;
            n2 = 0;
            while (n2 < n) {
                serialSection = iSerialSectionExtArray[n2];
                serialSection.setActive(false);
                ++n2;
            }
        }
    }
}

