/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread;

import ch.tachyon.tunnel.common.IMultiChanAudioSink;
import ch.tachyon.tunnel.engine.bridges.mthread.MtBase;
import ch.tachyon.tunnel.engine.bridges.mthread.MtContext;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.ISerialSectionExt;
import ch.tachyon.tunnel.engine.utils.concurrent.Task;
import ch.tachyon.tunnel.plugin.IMultiChanPushEffect;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MtMcPush
extends MtBase<IMultiChanPushEffect>
implements IMultiChanPushEffect {
    private float[][][] buffers;
    private int bufferIndex;
    private TaskSink[] taskSinks;
    private int taskIndex;
    private long clock;
    private AtomicInteger nbTasks = new AtomicInteger();
    private volatile Thread completionWaiter = null;

    public MtMcPush(IMultiChanPushEffect target, MtContext mtContext) {
        super(target, false, mtContext);
    }

    @Override
    public boolean canWriteFasterThanRead() {
        return ((IMultiChanPushEffect)this.getBaseTarget()).canWriteFasterThanRead();
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.buffers = null;
        this.taskSinks = new TaskSink[super.getInputPoolSize() + 1];
        int i = 0;
        while (i < this.taskSinks.length) {
            this.taskSinks[i] = new TaskSink();
            ++i;
        }
        this.clock = 0L;
    }

    @Override
    public void process(float[][] input0, int length, IMultiChanAudioSink sink) {
        int nbChans = input0.length;
        int nbSamples = input0[0].length;
        if (this.buffers == null) {
            this.buffers = new float[this.getInputPoolSize() + 1][][];
        }
        float[][] input = this.getNextBuffer(nbChans, nbSamples);
        int c = 0;
        while (c < nbChans) {
            System.arraycopy(input0[c], 0, input[c], 0, nbSamples);
            ++c;
        }
        this.submitChunk(sink, input, length < nbSamples, length);
    }

    private float[][] getNextBuffer(int nbChans, int nbSamples) {
        float[][] input = this.buffers[this.bufferIndex];
        if (input == null || input.length != nbChans || input[0].length != nbSamples) {
            input = new float[nbChans][nbSamples];
            this.buffers[this.bufferIndex] = input;
        }
        this.bufferIndex = (this.bufferIndex + 1) % this.buffers.length;
        return input;
    }

    private void submitChunk(IMultiChanAudioSink sink, float[][] input, boolean isLast, int chunkLength) {
        TaskSink task = this.taskSinks[this.taskIndex];
        this.taskIndex = (this.taskIndex + 1) % this.taskSinks.length;
        task.init(input, chunkLength, this.clock++, sink);
        if (this.serialize) {
            task.run();
        } else {
            this.started();
            this.threadPool.submitFragment(task);
            if (isLast) {
                this.waitCompletion();
            }
        }
    }

    void started() {
        this.nbTasks.incrementAndGet();
    }

    void completed() {
        int newValue = this.nbTasks.decrementAndGet();
        Thread waiter = this.completionWaiter;
        if (newValue == 0 && waiter != null) {
            LockSupport.unpark(waiter);
        }
    }

    private void waitCompletion() {
        this.completionWaiter = Thread.currentThread();
        while (this.nbTasks.get() > 0) {
            LockSupport.park();
        }
        this.completionWaiter = null;
    }

    @Override
    public void stopProcessing() {
        this.waitCompletion();
        super.stopProcessing();
        Arrays.fill(this.taskSinks, null);
    }

    class TaskSink
    extends Task
    implements IMultiChanAudioSink {
        private float[][] input;
        private int length;
        private long clock;
        private IMultiChanAudioSink sink;
        private final List<float[][]> outputs = new ArrayList<float[][]>();

        TaskSink() {
        }

        public void init(float[][] input, int length, long clock, IMultiChanAudioSink sink) {
            this.input = input;
            this.length = length;
            this.clock = clock;
            this.sink = sink;
            this.outputs.clear();
        }

        public void run() {
            ISerialSectionExt[] iSerialSectionExtArray = MtMcPush.this.serialSections;
            int n = MtMcPush.this.serialSections.length;
            int n2 = 0;
            while (n2 < n) {
                ISerialSectionExt serialSection = iSerialSectionExtArray[n2];
                serialSection.setActive(true);
                serialSection.setClock(this.clock);
                ++n2;
            }
            IMultiChanPushEffect plugin = (IMultiChanPushEffect)MtMcPush.super.getProcessingTarget(Thread.currentThread());
            if (plugin == null) {
                assert (MtMcPush.this.serialize);
                plugin = (IMultiChanPushEffect)MtMcPush.this.getBaseTarget();
            }
            plugin.process(this.input, this.length, this);
            MtMcPush.this.writeSection.enterSerialSection();
            try {
                for (float[][] output : this.outputs) {
                    this.sink.writeSamples(output);
                }
            }
            finally {
                MtMcPush.this.writeSection.leaveSerialSection();
            }
            MtMcPush.this.framesCounter.addAndGet(this.length);
            MtMcPush.this.completed();
            ISerialSectionExt[] iSerialSectionExtArray2 = MtMcPush.this.serialSections;
            int n3 = MtMcPush.this.serialSections.length;
            int n4 = 0;
            while (n4 < n3) {
                ISerialSectionExt serialSection = iSerialSectionExtArray2[n4];
                serialSection.setActive(false);
                ++n4;
            }
        }

        public void writeSamples(float[][] samples) {
            this.outputs.add(samples);
        }
    }
}

