/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread;

import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialSectionPool
implements ISerialSectionPool {
    private final IProcessingInfo info;
    private final IMtContext mtContext;
    private final Map<String, ISerialSection> serialSections = new LinkedHashMap<String, ISerialSection>();
    private int threadIndex;

    public SerialSectionPool(IProcessingInfo info, IMtContext mtContext) {
        this.info = info;
        this.mtContext = mtContext;
    }

    @Override
    public ISerialSection getSerialSection(String name) {
        return this.serialSections.get(name);
    }

    public void addSerialSection(String name, ISerialSection serialSection) {
        if (this.serialSections.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate serial section name " + name);
        }
        this.serialSections.put(name, serialSection);
    }

    public Collection<ISerialSection> getSerialSections() {
        return this.serialSections.values();
    }

    public int getNbSerialSections() {
        return this.serialSections.size();
    }

    void setThreadIndex(int threadIndex) {
        this.threadIndex = threadIndex;
    }

    @Override
    public int getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public IProcessingInfo getProcessingInfo() {
        return this.info;
    }

    @Override
    public IMtContext getMtContext() {
        return this.mtContext;
    }
}

