/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.TextComponent;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class AwtTools {
    private AwtTools() {
    }

    public static Window getWindow(Component cmp) {
        Container parent = cmp.getParent();
        while (parent != null && !(parent instanceof Window)) {
            parent = parent.getParent();
        }
        return (Window)parent;
    }

    private static Action wrapShortcutKeyAction(final Action target) {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Component cmp;
                Window window;
                Component focused;
                Object source = e.getSource();
                if (source instanceof Component && ((focused = (window = AwtTools.getWindow(cmp = (Component)source)).getFocusOwner()) instanceof JTextComponent || focused instanceof TextComponent)) {
                    return;
                }
                target.actionPerformed(e);
            }
        };
    }

    public static void addKeyboardShortcut(AbstractButton button, KeyStroke keyStroke) {
        AwtTools.addKeyboardShortcut(button, keyStroke, true);
    }

    public static void addKeyboardShortcut(AbstractButton button, KeyStroke keyStroke, boolean excludeTextInputComponent) {
        if (button.getAction() == null) {
            throw new IllegalArgumentException("The button must have an action");
        }
        Object actionKey = new Object();
        button.getInputMap(2).put(keyStroke, actionKey);
        Action action = button.getAction();
        if (excludeTextInputComponent) {
            action = AwtTools.wrapShortcutKeyAction(action);
        }
        button.getActionMap().put(actionKey, action);
    }

    public static void addKeyboardShortcut(AbstractButton button, int keyCode) {
        AwtTools.addKeyboardShortcut(button, KeyStroke.getKeyStroke(keyCode, 0));
    }

    public static void addKeyboardShortcut(JComponent button, KeyStroke keyStroke, Action action) {
        Object actionKey = new Object();
        button.getInputMap(2).put(keyStroke, actionKey);
        button.getActionMap().put(actionKey, AwtTools.wrapShortcutKeyAction(action));
    }

    public static void addKeyboardShortcut(JComponent button, int when, KeyStroke keyStroke, Action action) {
        Object actionKey = new Object();
        button.getInputMap(when).put(keyStroke, actionKey);
        button.getActionMap().put(actionKey, action);
    }
}

