/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.storage;

import ch.tachyon.tunnel.engine.storage.XmlReader;
import ch.tachyon.tunnel.engine.storage.XmlWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class BinaryStorage {
    public static void save(Object obj, String name, OutputStream output) throws IOException, InvocationTargetException {
        BufferedOutputStream boutput = new BufferedOutputStream(output);
        GZIPOutputStream goutput = new GZIPOutputStream(boutput);
        OutputStreamWriter owriter = new OutputStreamWriter(goutput);
        try {
            XmlWriter writer = new XmlWriter();
            writer.saveXml(obj, name, owriter);
        }
        finally {
            owriter.flush();
            owriter.close();
        }
    }

    public static Object load(InputStream input, String name, ClassLoader classLoader) throws IOException, InvocationTargetException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        BufferedInputStream binput = new BufferedInputStream(input);
        GZIPInputStream ginput = new GZIPInputStream(binput);
        InputStreamReader ireader = new InputStreamReader(ginput);
        try {
            XmlReader reader = new XmlReader(classLoader);
            Object object = reader.loadXml(ireader, name);
            return object;
        }
        finally {
            ireader.close();
        }
    }
}

