/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.storage;

import ch.tachyon.tunnel.plugin.IStorage;
import ch.tachyon.tunnel.plugin.ScopeType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginStorage
implements IStorage {
    private static final Map<String, Object> hostSessionMap = new HashMap<String, Object>();
    private final Map<String, Object> pluginSessionMap = new HashMap<String, Object>();
    private Map<String, Object> channelProcessMap;
    private final Class<?> pluginClass;
    private Preferences userPrefs;
    private Preferences systemPrefs;

    public PluginStorage(Class<?> pluginClass) {
        this.pluginClass = pluginClass;
    }

    private Preferences userPrefs() {
        if (this.userPrefs == null) {
            this.userPrefs = Preferences.userNodeForPackage(this.pluginClass);
        }
        return this.userPrefs;
    }

    private Preferences systemPrefs() {
        if (this.systemPrefs == null) {
            this.systemPrefs = Preferences.systemNodeForPackage(this.pluginClass);
        }
        return this.systemPrefs;
    }

    public void createChannelStorage() {
        this.channelProcessMap = new HashMap<String, Object>();
    }

    public void destroyChannelStorage() {
        this.channelProcessMap = null;
    }

    private Map<String, Object> getMapFor(ScopeType scope) {
        switch (scope) {
            case AUDIO_PROCESS: {
                return this.channelProcessMap;
            }
            case CHANNEL_PROCESS: {
                return this.channelProcessMap;
            }
            case PLUGIN_SESSION: {
                return this.pluginSessionMap;
            }
            case HOST_SESSION: {
                return hostSessionMap;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void store(String key, ScopeType scope, Object data) {
        if (scope == ScopeType.SYSTEM_PERSISTENT) {
            this.storePrefs(this.systemPrefs(), key, data);
        } else if (scope == ScopeType.USER_PERSISTENT) {
            this.storePrefs(this.userPrefs(), key, data);
        } else {
            Map<String, Object> map = this.getMapFor(scope);
            if (map == null) {
                throw new IllegalStateException("The given scope (" + (Object)((Object)scope) + ") does not exist now");
            }
            map.put(key, data);
        }
    }

    @Override
    public synchronized <E> E load(String key, ScopeType scope, Class<E> dataType) {
        Object result;
        if (scope == ScopeType.SYSTEM_PERSISTENT) {
            result = this.loadPrefs(this.systemPrefs(), key, dataType);
        } else if (scope == ScopeType.USER_PERSISTENT) {
            result = this.loadPrefs(this.userPrefs(), key, dataType);
        } else {
            Map<String, Object> map = this.getMapFor(scope);
            if (map == null) {
                throw new IllegalStateException("The given scope (" + (Object)((Object)scope) + ") does not exist now");
            }
            result = map.get(key);
        }
        if (result == null) {
            return null;
        }
        if (!dataType.isInstance(result)) {
            throw new ClassCastException("Cannot cast " + result.getClass() + " to " + dataType);
        }
        Object result0 = result;
        return (E)result0;
    }

    @Override
    public void setProcessData(Object data) {
        this.store("", ScopeType.AUDIO_PROCESS, data);
    }

    @Override
    public <E> E getProcessData(Class<E> dataType) {
        return this.load("", ScopeType.AUDIO_PROCESS, dataType);
    }

    private void storePrefs(Preferences prefs, String key, Object data) {
        if (data == null) {
            prefs.remove(key);
        } else if (data instanceof Boolean) {
            prefs.putBoolean(key, (Boolean)data);
        } else if (data instanceof Integer) {
            prefs.putInt(key, (Integer)data);
        } else if (data instanceof Long) {
            prefs.putLong(key, (Long)data);
        } else if (data instanceof Float) {
            prefs.putFloat(key, ((Float)data).floatValue());
        } else if (data instanceof Double) {
            prefs.putDouble(key, (Double)data);
        } else if (data instanceof String) {
            prefs.put(key, (String)data);
        } else if (data instanceof byte[]) {
            prefs.putByteArray(key, (byte[])data);
        } else {
            throw new IllegalArgumentException("Supported types are byte[], String, Boolean, Integer, Long, Float, Double");
        }
    }

    private Object loadPrefs(Preferences prefs, String key, Class<?> dataType) {
        if (dataType.equals(String.class)) {
            return prefs.get(key, null);
        }
        if (dataType.equals(byte[].class)) {
            return prefs.getByteArray(key, null);
        }
        try {
            HashSet<String> keys = new HashSet<String>(Arrays.asList(prefs.keys()));
            if (!keys.contains(key)) {
                return null;
            }
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
        if (dataType.equals(Boolean.class) || dataType.equals(Boolean.TYPE)) {
            return prefs.getBoolean(key, false);
        }
        if (dataType.equals(Integer.class) || dataType.equals(Integer.TYPE)) {
            return prefs.getInt(key, 0);
        }
        if (dataType.equals(Long.class) || dataType.equals(Long.TYPE)) {
            return prefs.getLong(key, 0L);
        }
        if (dataType.equals(Float.class) || dataType.equals(Float.TYPE)) {
            return Float.valueOf(prefs.getFloat(key, Float.NaN));
        }
        if (dataType.equals(Double.class) || dataType.equals(Double.TYPE)) {
            return prefs.getDouble(key, Double.NaN);
        }
        return null;
    }
}

