/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.storage;

import ch.tachyon.tunnel.engine.storage.XmlCommon;
import ch.tachyon.tunnel.engine.utils.bean.MemberInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlReader
extends XmlCommon {
    private final ClassLoader classLoader;

    public XmlReader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public XmlReader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public Object fromXml(Document doc, String name) throws InvocationTargetException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Element root = (Element)doc.getChildNodes().item(0);
        if (!root.getNodeName().equals(name)) {
            throw new IllegalArgumentException("Names do not match");
        }
        String className = root.getAttribute("type");
        if (className == null) {
            return null;
        }
        Class<?> type = Class.forName(className, true, this.classLoader);
        return this.fromXml(type, root, new HashMap<String, Object>());
    }

    private Object fromXml(Class<?> type, Element elt, Map<String, Object> cache) throws InvocationTargetException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if ("true".equalsIgnoreCase(elt.getAttribute("isNull"))) {
            return null;
        }
        if (XmlCommon.isSimple(type)) {
            Text text = (Text)elt.getFirstChild();
            return this.parseSimpleType(type, text.getNodeValue());
        }
        String ref = elt.getAttribute("ref");
        if (ref != null && !ref.equals("")) {
            if (!cache.containsKey(ref)) {
                throw new IllegalArgumentException("Forward reference: " + ref);
            }
            return cache.get(ref);
        }
        Object result = null;
        if (Map.class.isAssignableFrom(type)) {
            result = this.mapFromXml(type, elt, cache);
        } else if (Collection.class.isAssignableFrom(type)) {
            result = this.collectionFromXml(type, elt, cache);
        } else if (Enum.class.isAssignableFrom(type)) {
            String name = (String)this.fromXml(String.class, elt, cache);
            ?[] objArray = type.getEnumConstants();
            int n = objArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objArray[n2];
                Enum enumItem = (Enum)item;
                if (enumItem.name().equals(name)) {
                    result = item;
                }
                ++n2;
            }
        } else if (type.isArray()) {
            result = this.arrayFromXml(type, elt, cache);
        } else {
            result = type.newInstance();
            NodeList nodes = elt.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node instanceof Element) {
                    Element child = (Element)node;
                    String name = child.getNodeName();
                    MemberInfo info = new MemberInfo(type, name);
                    Object value = this.fromXml(info.getType(), child, cache);
                    info.setValue(result, value);
                }
                ++i;
            }
        }
        String key = elt.getAttribute("key");
        if (key != null && !key.equals("")) {
            cache.put(key, result);
        }
        return result;
    }

    private Object parseSimpleType(Class<?> type, String value) {
        if (type.equals(String.class)) {
            return value;
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return Byte.valueOf(value);
        }
        if (type.equals(Character.TYPE) || type.equals(Character.class)) {
            return Character.valueOf(value.charAt(0));
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return Short.valueOf(value);
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return Integer.valueOf(value);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return Long.valueOf(value);
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return Boolean.valueOf(value);
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return Float.valueOf(value);
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return Double.valueOf(value);
        }
        return null;
    }

    private Map<?, ?> mapFromXml(Class<?> type, Element elt, Map<String, Object> cache) throws IllegalAccessException, InstantiationException, ClassNotFoundException, InvocationTargetException {
        Map result = type.isInterface() ? (Map)LinkedHashMap.class.newInstance() : (Map)type.newInstance();
        String keyClassName = elt.getAttribute("keyType");
        Class<?> keysType = null;
        if (keyClassName != null && !keyClassName.equals("")) {
            keysType = Class.forName(keyClassName, true, this.classLoader);
        }
        String itemClassName = elt.getAttribute("itemType");
        Class<?> itemsType = null;
        if (itemClassName != null && !itemClassName.equals("")) {
            itemsType = Class.forName(itemClassName, true, this.classLoader);
        }
        NodeList nodes = elt.getChildNodes();
        Object lastKey = null;
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                Element child = (Element)node;
                if ("key".equals(child.getNodeName())) {
                    keyClassName = child.getAttribute("type");
                    Class<?> keyType = keysType;
                    if (keyClassName != null && !keyClassName.equals("")) {
                        keyType = Class.forName(keyClassName, true, this.classLoader);
                    }
                    if (keyType == null) {
                        throw new IllegalArgumentException("Unknown key type at " + elt);
                    }
                    lastKey = this.fromXml(keyType, child, cache);
                } else if ("item".equals(child.getNodeName())) {
                    itemClassName = child.getAttribute("type");
                    Class<?> itemType = itemsType;
                    if (itemClassName != null && !itemClassName.equals("")) {
                        itemType = Class.forName(itemClassName, true, this.classLoader);
                    }
                    if (itemType == null) {
                        throw new IllegalArgumentException("Unknown item type at " + elt);
                    }
                    Object item = this.fromXml(itemType, child, cache);
                    this.putUnsafe(result, lastKey, item);
                }
            }
            ++i;
        }
        return result;
    }

    private void putUnsafe(Map result, Object key, Object value) {
        result.put(key, value);
    }

    private Collection<?> collectionFromXml(Class<?> type, Element elt, Map<String, Object> cache) throws IllegalAccessException, InstantiationException, ClassNotFoundException, InvocationTargetException {
        Collection result = type.isInterface() ? (Collection)ArrayList.class.newInstance() : (Collection)type.newInstance();
        String itemClassName = elt.getAttribute("itemType");
        Class<?> itemsType = null;
        if (itemClassName != null && !itemClassName.equals("")) {
            itemsType = Class.forName(itemClassName, true, this.classLoader);
        }
        NodeList nodes = elt.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Element child;
            Node node = nodes.item(i);
            if (node instanceof Element && "item".equals((child = (Element)node).getNodeName())) {
                itemClassName = child.getAttribute("type");
                Class<?> itemType = itemsType;
                if (itemClassName != null && !itemClassName.equals("")) {
                    itemType = Class.forName(itemClassName, true, this.classLoader);
                }
                if (itemType == null) {
                    throw new IllegalArgumentException("Unknown item type at " + elt);
                }
                Object item = this.fromXml(itemType, child, cache);
                this.addUnsafe(result, item);
            }
            ++i;
        }
        return result;
    }

    private Object[] arrayFromXml(Class<?> type, Element elt, Map<String, Object> cache) throws IllegalAccessException, InstantiationException, ClassNotFoundException, InvocationTargetException {
        ArrayList result = new ArrayList();
        Class<?> itemsType = type.getComponentType();
        NodeList nodes = elt.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Element child;
            Node node = nodes.item(i);
            if (node instanceof Element && "item".equals((child = (Element)node).getNodeName())) {
                String itemClassName = child.getAttribute("type");
                Class<?> itemType = itemsType;
                if (itemClassName != null && !itemClassName.equals("")) {
                    itemType = Class.forName(itemClassName, true, this.classLoader);
                }
                if (itemType == null) {
                    throw new IllegalArgumentException("Unknown item type at " + elt);
                }
                if (!itemsType.isAssignableFrom(itemType)) {
                    throw new IllegalArgumentException("Item type " + itemType + " not assignable to array component type " + itemsType);
                }
                Object item = this.fromXml(itemType, child, cache);
                this.addUnsafe(result, item);
            }
            ++i;
        }
        return result.toArray();
    }

    private void addUnsafe(Collection coll, Object item) {
        coll.add(item);
    }

    public Object loadXml(Reader reader, String name) throws InvocationTargetException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        StreamSource src = new StreamSource(reader);
        DOMResult dst = new DOMResult();
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.transform(src, dst);
        }
        catch (TransformerException ex) {
            throw new UnsupportedOperationException(ex);
        }
        Document doc = (Document)dst.getNode();
        return this.fromXml(doc, name);
    }

    public Object loadXml(File file, String name) throws IOException, InvocationTargetException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        FileReader freader = new FileReader(file);
        BufferedReader breader = new BufferedReader(freader);
        try {
            Object object = this.loadXml(breader, name);
            return object;
        }
        finally {
            breader.close();
        }
    }
}

