/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.utils;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentLastUrlClassLoader
extends ClassLoader
implements Closeable {
    private final ChildUrlClassLoader childFirstClassLoader;
    private final boolean parentLast;

    public ParentLastUrlClassLoader(URL[] urls, boolean parentLast) {
        super(Thread.currentThread().getContextClassLoader());
        this.childFirstClassLoader = new ChildUrlClassLoader(urls, new FindClassClassLoader(this.getParent()), parentLast);
        this.parentLast = parentLast;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!this.parentLast) {
            try {
                return super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.childFirstClassLoader.findClass(name);
    }

    @Override
    public URL getResource(String name) {
        URL result = null;
        if (!this.parentLast && (result = super.getResource(name)) != null) {
            return result;
        }
        if (this.parentLast) {
            result = this.childFirstClassLoader.getResource(name);
        }
        return result;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.childFirstClassLoader.getResources(name);
    }

    @Override
    protected String findLibrary(String libname) {
        String result = null;
        if (!this.parentLast) {
            result = super.findLibrary(libname);
        }
        if (result != null) {
            return result;
        }
        return this.childFirstClassLoader.findLibrary(libname);
    }

    @Override
    public void close() {
        this.childFirstClassLoader.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChildUrlClassLoader
    extends URLClassLoader {
        private final boolean parentLast;
        private final FindClassClassLoader realParent;

        public ChildUrlClassLoader(URL[] urls, FindClassClassLoader realParent, boolean parentLast) {
            super(urls, (ClassLoader)null);
            this.realParent = realParent;
            this.parentLast = parentLast;
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> result = super.findLoadedClass(name);
            if (result != null) {
                return result;
            }
            try {
                if (this.parentLast) {
                    return super.findClass(name);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return this.realParent.loadClass(name);
        }

        @Override
        protected String findLibrary(String libname) {
            String result = null;
            if (this.parentLast) {
                result = super.findLibrary(libname);
            }
            if (result != null) {
                return result;
            }
            return this.realParent.findLibrary(libname);
        }

        public void dispose() {
            if (this instanceof Closeable) {
                try {
                    ((Closeable)this).close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindClassClassLoader
    extends ClassLoader {
        public FindClassClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }

        @Override
        public String findLibrary(String libname) {
            return super.findLibrary(libname);
        }
    }
}

