/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.host;

import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.common.ISingleChanAudioSource;
import ch.tachyon.tunnel.host.EngineResolver;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.effect.ISingleChanPullEffect;
import ch.tachyon.tunnel.plugin.IPlugin;
import java.io.Closeable;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonoStreamProcessor
implements IProcessingInfo {
    protected static final int MIN_CHUNK_LENGTH = 64;
    protected static final int PREFERRED_CHUNK_LENGTH = 2048;
    protected static final int MAX_CHUNK_LENGTH = 16384;
    protected float sampleRate;
    protected final long length;
    protected int chunkLength = 2048;

    public MonoStreamProcessor(long length) {
        this.length = length;
    }

    public MonoStreamProcessor() {
        this(-1L);
    }

    public <E extends IPlugin> ISingleChanPullEffect getPlugin(Class<E> pluginClass) {
        ISingleChanPullEffect effect = EngineResolver.getEngine().getStaticPlugin(ISingleChanPullEffect.class, pluginClass);
        effect.load(this);
        return effect;
    }

    public void process(ISingleChanAudioSource source, ISingleChanPullEffect effect, ISingleChanAudioSink target) {
        this.sampleRate = source.getAudioFormat().getSampleRate();
        effect.startProcessing(this);
        try {
            int amount;
            float[] buffer = new float[this.chunkLength];
            do {
                if ((amount = effect.process(source, buffer)) == this.chunkLength) {
                    target.writeSamples(buffer);
                    continue;
                }
                float[] tail = new float[amount];
                System.arraycopy(buffer, 0, tail, 0, amount);
                target.writeSamples(tail);
            } while (amount == this.chunkLength);
        }
        finally {
            effect.stopProcessing();
            effect.unload();
        }
    }

    public float[] process(final float[] audio, final float sampleRate, ISingleChanPullEffect effect) {
        this.sampleRate = sampleRate;
        ISingleChanAudioSource source = new ISingleChanAudioSource(){
            private final int length;
            private int offset;
            {
                this.length = fArray.length;
                this.offset = 0;
            }

            public int readSamples(float[] target) {
                int requested = target.length;
                int amount = Math.min(requested, this.length - this.offset);
                if (amount > 0) {
                    System.arraycopy(audio, this.offset, target, 0, amount);
                    this.offset += amount;
                }
                return amount;
            }

            public AudioFormat getAudioFormat() {
                return new AudioFormat(sampleRate, 24, 1, true, false);
            }
        };
        final ArrayList outputs = new ArrayList();
        ISingleChanAudioSink sink = new ISingleChanAudioSink(){

            public void writeSamples(float[] samples) {
                float[] copy = new float[samples.length];
                System.arraycopy(samples, 0, copy, 0, samples.length);
                outputs.add(copy);
            }
        };
        this.process(source, effect, sink);
        int length = 0;
        for (float[] chunk : outputs) {
            length += chunk.length;
        }
        float[] output = new float[length];
        int offset = 0;
        for (float[] chunk : outputs) {
            int chunkLength = chunk.length;
            System.arraycopy(chunk, 0, output, offset, chunkLength);
            offset += chunkLength;
        }
        return output;
    }

    public ISingleChanAudioSource filter(ISingleChanAudioSource source, ISingleChanPullEffect effect) {
        this.sampleRate = source.getAudioFormat().getSampleRate();
        effect.startProcessing(this);
        return new FilterSource(source, effect);
    }

    @Override
    public int getNumberOfChannels() {
        return 1;
    }

    @Override
    public float getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public int getQuantization() {
        return 24;
    }

    @Override
    public int getMaxChunkLength(int pluginOptimalChunkLength) {
        return this.chunkLength;
    }

    @Override
    public int getHostPreferredChunkLength() {
        return 2048;
    }

    @Override
    public int negociateFixedChunkLength(int pluginOptimalChunkLength) {
        this.chunkLength = pluginOptimalChunkLength < 64 || pluginOptimalChunkLength > 16384 ? 2048 : pluginOptimalChunkLength;
        return this.chunkLength;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    class FilterSource
    implements ISingleChanAudioSource,
    Closeable {
        private final ISingleChanAudioSource source;
        private final ISingleChanPullEffect effect;
        private final float[] buffer;
        private int available;
        private int index;
        private boolean disposed;

        private FilterSource(ISingleChanAudioSource source, ISingleChanPullEffect effect) {
            this.buffer = new float[MonoStreamProcessor.this.chunkLength];
            this.index = MonoStreamProcessor.this.chunkLength;
            this.disposed = false;
            this.source = source;
            this.effect = effect;
        }

        public int readSamples(float[] target) {
            int remaining = target.length;
            int result = 0;
            while (remaining > 0) {
                int amount;
                if (this.index >= MonoStreamProcessor.this.chunkLength) {
                    this.available = this.effect.process(this.source, this.buffer);
                    this.index = 0;
                }
                if ((amount = Math.min(remaining, this.available - this.index)) > 0) {
                    System.arraycopy(this.buffer, this.index, target, result, amount);
                    this.index += amount;
                    result += amount;
                    remaining -= amount;
                }
                if (this.index < this.available || this.available >= MonoStreamProcessor.this.chunkLength) continue;
                this.close();
                break;
            }
            return result;
        }

        public AudioFormat getAudioFormat() {
            return this.source.getAudioFormat();
        }

        public void close() {
            if (!this.disposed) {
                this.effect.stopProcessing();
                this.effect.unload();
                this.disposed = true;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

