/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.host;

import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import javax.sound.sampled.AudioFormat;

public class MultiChanArraySource
implements IMultiChanAudioSource {
    private final float[][] array;
    private final AudioFormat format;
    private int offset;

    public MultiChanArraySource(float[][] array, float sampleRate) {
        this(array, sampleRate, 24);
    }

    public MultiChanArraySource(float[][] array, float sampleRate, int precision) {
        this.array = array;
        this.format = new AudioFormat(sampleRate, precision, array.length, true, false);
        int nbFrames = 0;
        int chan = 0;
        while (chan < nbFrames) {
            if (chan == 0) {
                nbFrames = array[0].length;
            } else if (nbFrames != array[chan].length) {
                throw new IllegalArgumentException("The number of samples must be the same in all channels");
            }
            ++chan;
        }
    }

    public AudioFormat getAudioFormat() {
        return this.format;
    }

    public int readSamples(float[][] target) {
        int amount = Math.min(this.array[0].length - this.offset, target[0].length);
        if (amount == 0) {
            return 0;
        }
        int chan = 0;
        while (chan < this.array.length) {
            System.arraycopy(this.array[chan], this.offset, target[chan], 0, amount);
            ++chan;
        }
        this.offset += amount;
        return amount;
    }
}

