/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.host;

import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.host.EngineResolver;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.effect.IPullEffect;
import ch.tachyon.tunnel.plugin.IPlugin;
import java.io.Closeable;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamProcessor
implements IProcessingInfo {
    protected static final int MIN_CHUNK_LENGTH = 64;
    protected static final int PREFERRED_CHUNK_LENGTH = 2048;
    protected static final int MAX_CHUNK_LENGTH = 16384;
    protected final float sampleRate;
    protected final int nbChannels;
    protected final long length;
    protected int chunkLength = 2048;

    public StreamProcessor(AudioFormat format) {
        this.sampleRate = format.getSampleRate();
        this.nbChannels = format.getChannels();
        this.length = -1L;
    }

    public StreamProcessor(AudioFormat format, long length) {
        this.sampleRate = format.getSampleRate();
        this.nbChannels = format.getChannels();
        this.length = length;
    }

    public StreamProcessor(AudioFileFormat fileFormat) {
        this(fileFormat.getFormat(), fileFormat.getFrameLength());
    }

    public <E extends IPlugin> IPullEffect getPlugin(Class<E> pluginClass) {
        IPullEffect effect = EngineResolver.getEngine().getStaticPlugin(IPullEffect.class, pluginClass);
        effect.load(this);
        return effect;
    }

    public IMultiChanAudioSource filter(IMultiChanAudioSource source, IPullEffect effect) {
        if (this.nbChannels != source.getAudioFormat().getChannels()) {
            throw new IllegalArgumentException("The numnber of channel in the source (" + source.getAudioFormat().getChannels() + ") does not match the number of channels of this StreamProcessor (" + this.nbChannels + ")");
        }
        if (this.sampleRate != source.getAudioFormat().getSampleRate()) {
            throw new IllegalArgumentException("The sample rate of the source (" + source.getAudioFormat().getSampleRate() + ") does not match the sample rate of the StreamProcessor (" + this.sampleRate + ")");
        }
        effect.startProcessing(this);
        return new FilterSource(effect, source);
    }

    @Override
    public int getNumberOfChannels() {
        return this.nbChannels;
    }

    @Override
    public float getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public int getQuantization() {
        return 24;
    }

    @Override
    public int getMaxChunkLength(int pluginOptimalChunkLength) {
        return this.chunkLength;
    }

    @Override
    public int getHostPreferredChunkLength() {
        return 2048;
    }

    @Override
    public int negociateFixedChunkLength(int pluginOptimalChunkLength) {
        this.chunkLength = pluginOptimalChunkLength < 64 || pluginOptimalChunkLength > 16384 ? 2048 : pluginOptimalChunkLength;
        return this.chunkLength;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    class FilterSource
    implements IMultiChanAudioSource,
    Closeable {
        private final IPullEffect effect;
        private final IMultiChanAudioSource source;
        private final float[][] buffer;
        private int available;
        private int index;
        private boolean disposed;

        FilterSource(IPullEffect effect, IMultiChanAudioSource source) {
            this.buffer = new float[StreamProcessor.this.nbChannels][StreamProcessor.this.chunkLength];
            this.index = StreamProcessor.this.chunkLength;
            this.disposed = false;
            this.effect = effect;
            this.source = source;
        }

        public int readSamples(float[][] target) {
            int remaining = target[0].length;
            int result = 0;
            while (remaining > 0) {
                int amount;
                if (this.index >= StreamProcessor.this.chunkLength) {
                    this.available = this.effect.process(this.source, this.buffer);
                    this.index = 0;
                }
                if ((amount = Math.min(remaining, this.available - this.index)) > 0) {
                    int c = 0;
                    while (c < StreamProcessor.this.nbChannels) {
                        System.arraycopy(this.buffer[c], this.index, target[c], result, amount);
                        ++c;
                    }
                    this.index += amount;
                    result += amount;
                    remaining -= amount;
                }
                if (this.index < this.available || this.available >= StreamProcessor.this.chunkLength) continue;
                this.close();
                break;
            }
            return result;
        }

        public void close() {
            if (!this.disposed) {
                this.effect.stopProcessing();
                this.effect.unload();
                this.disposed = true;
            }
        }

        public AudioFormat getAudioFormat() {
            return this.source.getAudioFormat();
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

