/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.plugin.param;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ScaleType {
    LINEAR("Linear"){

        public double forwScale(double value, double minValue, double maxValue) {
            return value;
        }

        public double backScale(double value, double minValue, double maxValue) {
            return value;
        }
    }
    ,
    LOGARITHMIC("Logarithmic"){

        public double forwScale(double value, double minValue, double maxValue) {
            if (minValue >= 0.0 == maxValue >= 0.0) {
                double min = minValue;
                double max = maxValue;
                if (min == 0.0) {
                    double incr = maxValue / 1000.0;
                    min += incr;
                    max += incr;
                    value += incr;
                }
                double logMin = ScaleType.log2(Math.abs(min));
                double logMax = ScaleType.log2(Math.abs(max));
                double logValue = ScaleType.log2(Math.abs(value));
                double normalized = (logValue - logMin) / (logMax - logMin);
                return minValue + normalized * (max - min);
            }
            return CUBEROOT.forwScale(value, minValue, maxValue);
        }

        public double backScale(double value, double minValue, double maxValue) {
            if (minValue >= 0.0 == maxValue >= 0.0) {
                double min = minValue;
                double max = maxValue;
                if (minValue == 0.0) {
                    double incr = maxValue / 1000.0;
                    min += incr;
                    max += incr;
                }
                double normalized = (value - minValue) / (max - min);
                double logMin = ScaleType.log2(Math.abs(min));
                double logMax = ScaleType.log2(Math.abs(max));
                double scaled = logMin + normalized * (logMax - logMin);
                double result = ScaleType.exp2(scaled);
                if (minValue == 0.0) {
                    result -= maxValue / 1000.0;
                }
                return result;
            }
            return CUBEROOT.backScale(value, minValue, maxValue);
        }
    }
    ,
    CUBE("Cubic"){

        public double forwScale(double value, double minValue, double maxValue) {
            double cbMin = Math.pow(minValue, 3.0);
            double cbMax = Math.pow(maxValue, 3.0);
            double cbValue = Math.pow(value, 3.0);
            double normalized = (cbValue - cbMin) / (cbMax - cbMin);
            return minValue + normalized * (maxValue - minValue);
        }

        public double backScale(double value, double minValue, double maxValue) {
            double normalized = (value - minValue) / (maxValue - minValue);
            double cbMin = Math.pow(minValue, 3.0);
            double cbMax = Math.pow(maxValue, 3.0);
            double scaled = cbMin + normalized * (cbMax - cbMin);
            return Math.cbrt(scaled);
        }
    }
    ,
    CUBEROOT("Cube root"){

        public double forwScale(double value, double minValue, double maxValue) {
            double crMin = Math.cbrt(minValue);
            double crMax = Math.cbrt(maxValue);
            double crValue = Math.cbrt(value);
            double normalized = (crValue - crMin) / (crMax - crMin);
            return minValue + normalized * (maxValue - minValue);
        }

        public double backScale(double value, double minValue, double maxValue) {
            double normalized = (value - minValue) / (maxValue - minValue);
            double crMin = Math.cbrt(minValue);
            double crMax = Math.cbrt(maxValue);
            double scaled = crMin + normalized * (crMax - crMin);
            return Math.pow(scaled, 3.0);
        }
    }
    ,
    LOG_CUBEROOT("Log + Cube root"){

        public double forwScale(double value, double minValue, double maxValue) {
            if (minValue >= 0.0 == maxValue >= 0.0) {
                double min = minValue;
                double max = maxValue;
                if (min == 0.0) {
                    double incr = maxValue / 1000.0;
                    min += incr;
                    max += incr;
                    value += incr;
                }
                double lcMin = Math.cbrt(ScaleType.log2(Math.abs(min)));
                double lcMax = Math.cbrt(ScaleType.log2(Math.abs(max)));
                double lcValue = Math.cbrt(ScaleType.log2(Math.abs(value)));
                double normalized = (lcValue - lcMin) / (lcMax - lcMin);
                return minValue + normalized * (max - min);
            }
            return CUBEROOT.forwScale(value, minValue, maxValue);
        }

        public double backScale(double value, double minValue, double maxValue) {
            if (minValue >= 0.0 == maxValue >= 0.0) {
                double min = minValue;
                double max = maxValue;
                if (minValue == 0.0) {
                    double incr = maxValue / 1000.0;
                    min += incr;
                    max += incr;
                }
                double normalized = (value - minValue) / (max - min);
                double lcMin = Math.cbrt(ScaleType.log2(Math.abs(min)));
                double lcMax = Math.cbrt(ScaleType.log2(Math.abs(max)));
                double scaled = lcMin + normalized * (lcMax - lcMin);
                double result = ScaleType.exp2(Math.pow(scaled, 3.0));
                if (minValue == 0.0) {
                    result -= maxValue / 1000.0;
                }
                return result;
            }
            return CUBEROOT.backScale(value, minValue, maxValue);
        }
    };

    private String name;
    private static final double LOG_2;

    static {
        LOG_2 = Math.log(2.0);
    }

    private ScaleType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public abstract double forwScale(double var1, double var3, double var5);

    public abstract double backScale(double var1, double var3, double var5);

    private static double log2(double value) {
        return Math.log(value) / LOG_2;
    }

    private static double exp2(double value) {
        return Math.exp(value * LOG_2);
    }

    /* synthetic */ ScaleType(String string, int n, String string2, ScaleType scaleType) {
        this(string2);
    }
}

