/*
 * Decompiled with CFR 0.152.
 */
package javatester;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Label;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class TestJavaApplet
extends Applet {
    public void start() {
        String urlStr;
        super.start();
        String paramVersion = super.getParameter("javaVersion");
        if (paramVersion != null && !paramVersion.trim().equals("")) {
            int[] reqVersion = this.getVersion(paramVersion, 0);
            int[] curVersion = this.getVersion(System.getProperty("java.version"), reqVersion.length);
            int i = 0;
            while (i < reqVersion.length) {
                if (curVersion[i] > reqVersion[i]) break;
                if (curVersion[i] < reqVersion[i]) {
                    this.displayErrorMessage(paramVersion, System.getProperty("java.version"));
                    return;
                }
                ++i;
            }
        }
        if ((urlStr = super.getParameter("showURL")) == null) {
            return;
        }
        try {
            URL url = new URL(urlStr);
            String target = super.getParameter("showTarget");
            if (target != null) {
                this.getAppletContext().showDocument(url, target);
            } else {
                this.getAppletContext().showDocument(url);
            }
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            this.showStatus("Cannot redirect to \"" + urlStr + "\": " + ex.toString());
        }
    }

    public String getAppletInfo() {
        return "Java Version Tester";
    }

    private int[] getVersion(String versionStr, int minPos) {
        StringTokenizer tk = new StringTokenizer(versionStr, ".");
        int count = tk.countTokens();
        String[] parts = new String[count];
        int i = 0;
        while (i < count) {
            parts[i] = tk.nextToken();
            ++i;
        }
        int[] result = new int[Math.max(parts.length, minPos)];
        int i2 = 0;
        while (i2 < parts.length) {
            try {
                result[i2] = Integer.parseInt(parts[i2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i2;
        }
        return result;
    }

    private void displayErrorMessage(String minVersion, String curVersion) {
        super.setLayout(new BorderLayout());
        Container panel = new Container();
        super.add((Component)panel, "North");
        panel.setLayout(new GridLayout(3, 1));
        Label lbl1 = new Label("This applet requires Java version " + minVersion + " or greater.");
        panel.add(lbl1);
        Label lbl2 = new Label("Currently only Java version " + curVersion + " is installed.");
        panel.add(lbl2);
        Label lbl3 = new Label("Please go to http://www.java.com to download and install the latest Java version.");
        panel.add(lbl3);
    }
}

